﻿//Start: 用户
function User()
{
	var __uploadHead;
	
	this.modifyPassword = function()
	{
		if ($.trim(this.OldPassword.value) == '')
		{
			ali.error(_lang_old_password_empty, $.proxy(function(){this.OldPassword.select();},this));
			return false;
		}
		
		if ($.trim(this.NewPassword.value) == '')
		{
			ali.error(_lang_new_password_empty, $.proxy(function(){this.NewPassword.select();}, this));
			return false;	
		}
		
		var data = 'OldPassword=' + encodeURIComponent(this.OldPassword.value);
			data += '&NewPassword=' + encodeURIComponent(this.NewPassword.value);

		ali.working(_lang_working);
		 
		$.ajax(
		{
			url: _webPath + 'alicms.aspx?Object=User&Operation=ModifyPassword&ID=' + _id,
			data: data,
			type: 'POST',
			error: function()
			{
				ali.error(_lang_operation_fail);
				ali.working();
			},
			success: function(data)
			{
				ali.success(_lang_operation_success);
				ali.working();
			}
		});
		
		return false;
	};

	this.modifyMaterial = function()
	{ 
		if (this.Mobile.value != '' && !this.Mobile.value.match(/^\d{11}$/))
		{
			ali.error(_lang_mobile_incorrect, $.proxy(function(){this.Mobile.select();}, this));
			return false;	
		}
		
		if (this.Email.value != '' && !this.Email.value.match(/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/))
		{
			ali.error(_lang_email_incorrect, $.proxy(function(){this.Mobile.select();},this));
			return false;
		}
		
		checkMobile();
		
		return false;
	};
	
	function checkMobile()
	{
		var me = $('[name=Mobile]');
		
		if (me.val() == '')
		{
			checkEmail();
			return;
		}
		
		if (typeof(me.data('old')) == 'undefined' || me.val() != me.data('old'))
		{
			$.get(_webPath + 'alicms.aspx?Object=User&Operation=IsMobileExist&Mobile=' + encodeURIComponent(me.val()), function(data)
			{
				if (data.toLowerCase() == 'true')
				{
					ali.error(_lang_mobile_exist, $.proxy(function(){me[0].select();}, this));
				}
				else
				{
					checkEmail();
				}
			});
		}
		else
		{
			checkEmail();
		}
	}
	
	function checkEmail()
	{
		var me = $('[name=Email]');
		if (me.val() == '')
		{
			modify_send();
			return;
		}

		if (typeof(me.data('old')) == 'undefined' || me.val() != me.data('old'))
		{
			$.get(_webPath + 'alicms.aspx?Object=User&Operation=IsEmailExist&Email=' + encodeURIComponent(me.val()), function(data)
			{
				if (data.toLowerCase() == 'true')
				{
					ali.error(_lang_email_exist, $.proxy(function(){me[0].select();}, this));
				}
				else
				{
					modify_send();
				}
			});
		}
		else
		{
			modify_send();
		}
	}
	
	function modify_send()
	{
		var form = $('.post')[0];

		var data = 'RealName=' + encodeURIComponent(form.RealName.value);
		data += '&Sex=' + encodeURIComponent(form.Sex.value);
		data += '&QQ=' + encodeURIComponent(form.QQ.value);
		data += '&Mobile=' + encodeURIComponent(form.Mobile.value);
		data += '&Email=' + encodeURIComponent(form.Email.value);
		data += '&Profile=' + encodeURIComponent(form.Profile.value);

		__uploadHead = ali.uploader($('.ali-uploader', form), 'needUpload');
		if (!__uploadHead)
		{
			data += '&Head=' + encodeURIComponent(form.Head.value);
			$('.block13 dt img').attr('src', form.Head.value);
		}
		
		ali.working(_lang_working);
		$(':submit', form)[0].disabled = true;
	
		$.ajax(
		{
			url: _webPath + 'alicms.aspx?Object=User&Operation=Modify&ID=' + _id,
			data: data,
			type: 'POST',
			error: function(request)
			{
				ali.error(_lang_operation_fail);
				ali.working();
				$(':submit', form)[0].disabled = false;
			},
			success: function(data)
			{				
				$(form.Mobile).data('old', form.Mobile.value);
				$(form.Email).data('old', form.Email.value);

				uploadHead(form);
			}
		});
	}

	function uploadHead(form)
	{
		if (!__uploadHead)
		{
			ali.success(_lang_operation_success);
			ali.working();
			$(':submit', form)[0].disabled = false;
			return;
		}
	
		ali.uploader($('.ali-uploader:first', form), 'upload', {status:_lang_uploading,params:'Object=User&Operation=UploadHead&ID=' + _id,onComplete:function()
		{
			if (arguments[0] != 0)
			{
				//Alert(arguments[1]);
				ali.error(arguments[1]);
				ali.working();
				$(':submit', form)[0].disabled = false;
			}
			else
			{
				$('[name=Head]').val(arguments[1]);
				$('.block13 dt img').attr('src', arguments[1]);
				
				ali.success(_lang_operation_success);
				ali.working();
				$(':submit', form)[0].disabled = false;
			}
		}});
	}
}
//End: 用户

//登陆有关
function login()
{
	if ($.trim(this.Name.value) == '' || this.Name.title == this.Name.value)
	{
		ali.error(_lang_name_empty, $.proxy(function(){this.Name.select();}, this));
		return false;
	}
	
	if ($.trim(this.Password.value) == '')
	{
		ali.error(_lang_password_empty, $.proxy(function(){this.Password.select();}, this));
		return false;
	}
	
	if (this.CheckCode != null && $.trim(this.CheckCode.value) == '')
	{
		//Alert(_lang_check_code_empty, function(){this.CheckCode.select();}, this);
		ali.error(_lang_check_code_empty, $.proxy(function(){this.CheckCode.select();}, this));
		return false;
	}
	
	var data = 'Name=' + encodeURIComponent(this.Name.value);
	data += '&Password=' + encodeURIComponent(this.Password.value);
	if (this.CheckCode != null)
		data += '&CheckCode=' + encodeURIComponent(this.CheckCode.value);
	if ($('#remember')[0].checked)
		data += '&Minutes=' + (60*24*365);
	
	var form = $(this);
	ali.working(_lang_working);
	$(':submit', form).prop('disabled', true);
	
	$.ajax(
	{
		url: _webPath + 'alicms.aspx?Object=User&Operation=Login',
		data: data,
		type: 'POST',
		error: function()
		{
			ali.error(_lang_login_fail);
			$('#check-code-image').attr('src', _webPath + 'alicms.aspx?Action=CheckCode&' + Math.random());
			ali.working();
			$(':submit', form).prop('disabled', false);
		},
		success: function()
		{
			if (_referer != '')
				window.location = _referer;
			else
				window.location = window.location.href.replace('login', 'index');
		}
	});

	return false;
}

//注册时的填相关信息
function Register()
{
 	this.onNameBlur = function()
	{
		var me = $(this);
		
		if (me.val() == '')
		{
			me.addClass('error').nextAll('strong').addClass('error').html(_lang_name_empty);
			return;
		}
		
		if (!me.val().match(/^[a-zA-Z0-9]{5,20}$/))
		{
			me.addClass('error').nextAll('strong').addClass('error').html(_lang_name_incorrect);
			return;
		}
		
		$.get(_webPath + 'alicms.aspx?Mark=User&Object=User&Operation=IsNameExist&Name=' + encodeURIComponent(me.val()),function(data)
		{
			if (data.toLowerCase() == 'true')
				me.addClass('error').nextAll('strong').addClass('error').html(_lang_name_exist);
			else
				me.removeClass('error').nextAll('strong').removeClass('error').html(me.attr('title'));
		});
		
	};
	
	this.onPasswordBlur = function()
	{
		var me = $(this);
		if (me.val() == '')
		{
			me.addClass('error').nextAll('strong').addClass('error').html(_lang_password_empty);
			return;	
		}
		if (!me.val().match(/^[a-zA-Z0-9]{5,20}$/))
			me.addClass('error').nextAll('strong').addClass('error').html(_lang_password_incorrect);
		else
			me.removeClass('error').nextAll('strong').removeClass('error').html(me.attr('title'));
	};
	
	this.onConfirmBlur = function()
	{
		var me = $(this);
		
		if (me.val() != this.form.Password.value)
			me.addClass('error').nextAll('strong').addClass('error').html(_lang_password_nosame);
		else
			me.removeClass('error').nextAll('strong').removeClass('error').html(me.attr('title'));
	};
	
	this.onEmailBlur= function()
	{
		var me = $(this);
		
		if (me.val() == '')
		{
			me.removeClass('error').nextAll('strong').removeClass('error').html(me.attr('title'));
			return;
		}
		if (!ali.util.isEmail(me.val()))
		{
			me.addClass('error').nextAll('strong').addClass('error').html(_lang_email_incorrect);
			return;
		}
		$.get(_webPath + 'alicms.aspx?Object=User&Operation=IsEmailExist&Email=' + encodeURIComponent(me.val()),function(data)
		{
			if (data.toLowerCase() == 'true')
				me.addClass('error').nextAll('strong').addClass('error').html(_lang_email_exist);
			else
				me.removeClass('error').nextAll('strong').removeClass('error').html(me.attr('title'));
		});
	}

	this.onMobileBlur = function()
	{
		var me = $(this);
		
		if (me.val() == '')
		{
			me.removeClass('error').nextAll('strong').removeClass('error').html(me.attr('title'));
			return;
		}

		if (!ali.util.isMobile(me.val()))
		{
			me.addClass('error').nextAll('strong').addClass('error').html(_lang_mobile_incorrect);
			return;
		}
	};
	
	this.onQQBlur = function()
	{
		var me = $(this);
		
		if (me.val() == '')
		{
			me.removeClass('error').nextAll('strong').removeClass('error').html(me.attr('title'));
			return;
		}
		
		if (!me.val().match(/^[0-9]{5,15}$/))
			me.addClass('error').nextAll('strong').addClass('error').html(_lang_qq_incorrect);
		else
			me.removeClass('error').nextAll('strong').removeClass('error').html(me.attr('title'));
	};
	
	this.onSubmit = function()
	{
		//检查用户名
		if (!$('#agreement').prop('checked'))
		{
			ali.error(_lang_tongyi_exist);
			return false;
		}
		
		if (this.Name.value == '')
		{
			$(this.Name).addClass('error');
			ali.error(_lang_name_empty);
			return false;
		}
		
		if (!this.Name.value.match(/^[a-zA-Z0-9]{5,20}$/))
		{
			ali.error(_lang_name_incorrect, $.proxy(function(){this.Name.select();}, this));
			return false;
		}
	
		$(this.Name).removeClass('error');
		
		//检查密码
		if (this.Password.value == '')
		{
			$(this.Password).addClass('error');
			ali.error(_lang_password_empty, $.proxy(function(){this.password.select();}, this));
			return false;	
		}

		if (!this.Password.value.match(/^[a-zA-Z0-9]{6,20}$/))
		{
			$(this.Password).addClass('error');
			ali.error(_lang_password_incorrect, $.proxy(function(){this.Password.select();}, this));
			return;
		}

		$(this.Password).removeClass('error');
		
		//检查第二次输入的密码
		if (this.Confirm.value != this.Password.value)
		{
			$(this.Confirm).addClass(error);
			ali.error(_lang_password_nosame, $.proxy(function(){this.Confirm.select();}, this));
			return false;
		}
		
		$(this.Confirm).removeClass('error');

		//检查手机
		if (this.Mobile.value != '' && !ali.util.isMobile(this.Mobile.value))
		{
			$(this.Mobile).addClass('error');
			ali.error(_lang_mobile_incorrect, $.proxy(function(){this.Mobile.select();}, this));
			return false;
		}
	
		$(this.Mobile).removeClass('error');
		
		//检查电子邮件
		if (this.Email.value != '' && !ali.util.isEmail(this.Email.value))
		{
			$(this.Email).addClass('error');
			ali.error(_lang_email_incorrect, $.proxy(function(){this.Email.select();}, this));
			return false;
		}
	
		$(this.Email).removeClass('error');
		
		$(':submit', this)[0].disabled = true;
		ali.working(_lang_working);
		
		checkName(this);	
		
		return false;
	};
	
	function checkName(form)
	{
		$.get(_webPath + 'alicms.aspx?Object=User&Operation=IsNameExist&Name=' + encodeURIComponent(form.Name.value),function(data)
		{
			if (data.toLowerCase() == 'true')
			{
				ali.error(_lang_name_exist, function(){form.Name.select();});
				$(':submit')[0].disabled = false;
				ali.working();
			}
			else
			{
				checkMobile(form);
			}
		});
	}
	
	function checkMobile(form)
	{
		if (form.Mobile.value == '')
		{
			checkEmail(form);
			return;
		}
		
		$.get(_webPath + 'alicms.aspx?Object=User&Operation=IsMobileExist&Mobile=' + encodeURIComponent(form.Mobile.value),function(data)
		{
			if (data.toLowerCase() == 'true')
			{
				Alert(_lang_mobile_exist, function(){form.Mobile.select();}, this);
				ali.error(_lang_mobile_exist, function(){form.Mobile.select();});
				$(':submit')[0].disabled = false;
				ali.working();
			}
			else
			{
				checkEmail(form);
			}
		});	
	}
	
	function checkEmail(form)
	{
		if (form.Email.value == '')
		{
			Send(form);
			return;
		}
	
		$.get(_webPath + 'alicms.aspx?Object=User&Operation=IsEmailExist&Email=' + encodeURIComponent(form.Email.value),function(data)
		{
			if (data.toLowerCase() == 'true')
			{
				ali.error(_lang_email_exist, function(){form.Email.select();});
				$(':submit')[0].disabled = false;
				ali.working();
			}
			else
			{
				Send(form);
			}
		});
	}
	
	function Send(form)
	{
		var data = 'IsChecked=' + !_isNeedToCheck + '&Name=' + encodeURIComponent(form.Name.value);
		data += '&Password=' + encodeURIComponent(form.Password.value);
		data += '&Mobile=' + encodeURIComponent(form.Mobile.value);
		data += '&Email=' + encodeURIComponent(form.Email.value);
		
		$.ajax(
		{
			url: _webPath + 'alicms.aspx?Object=User&Operation=Register',
			data: data,
			type: 'POST',
			error: function()
			{
				ali.error(_lang_operation_fail);
				$(':submit')[0].disabled = false;
				ali.working();
			},
			success: function(data)
			{
				ali.working();
				ali.success(_lang_register_success, {modal:true,onClose:function()
				{
					data = 'Name=' + encodeURIComponent(form.Name.value);
					data += '&Password=' + encodeURIComponent(form.Password.value);
	
					$.ajax(
					{
						url: _webPath + 'alicms.aspx?Mark=User&Object=User&Operation=Login',
						data: data,
						type: 'POST',
						complete: function()
						{
							if (window.location.search.length > 0)
								window.location = window.location.search.substr(1);
							else
								window.location = window.location.href.replace('register', 'index');
						}
					});
				}});
			}
		});
	}
}

function onAddressSubmit()
{
	var sel = $('[name=Sel]:checked');
	if (sel.length == 0)
		addAddress(this);
	else
		modifyAddress(this);

	return false;
}

function addAddress(form)
{
	//检查地区
	var region = $('select:first', form);
	if (region.val() == '')
	{
		ali.error(_lang_region_empty);
		return false;	
	}
	
	//检查收货地址
	if (form.SubAddress.value == '')
	{
		ali.error(_lang_sub_address_empty, $.proxy(function(){form.SubAddress.select();}, this));
		return false;
	}
	
	//检查邮政编码
	if (form.Zip.value == '')
	{
		ali.error(_lang_zip_empty, $.proxy(function(){form.Zip.select();}, this));
		return false;
	}
	
	//检查收货人名称
	if (form.Name.value == '')
	{
		ali.error(_lang_name_empty, $.proxy(function(){form.Name.select();}, this));
		return false;
	}
	
	//检查收货人手机
	if (!form.Mobile.value.match(/^\d{11}$/))
	{
		ali.error(_lang_mobile_incorrect, $.proxy(function(){form.Mobile.select();}, this));
		return false;
	}
	
	//准备数据
	var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&RegionID=' + $('select:last', form).val();
		data += '&SubAddress=' + encodeURIComponent(form.SubAddress.value);
		data += '&Zip=' + form.Zip.value;
		data += '&Mobile=' + form.Mobile.value;
		data += '&Phone=' + form.Phone.value;
		data += '&IsDefault=' + form.IsDefault.checked;
		data += '&UserID=' + ali.util.cookie('UserID');
		data += '&UserName=' + encodeURIComponent(ali.util.cookie('UserName'));
	
	//提交数据
	ali.working(_lang_working);
	
	$.ajax(
	{
		url: _webPath + 'alicms.aspx?Mark=Home&Object=Address&Operation=Add',
		data: data,
		type: 'POST',
		error: function()
		{
			ali.error(_lang_operation_fail);
			ali.working();
		},
		success: function(guid)
		{
			$.get(_webPath + 'alicms.aspx?Mark=Home&Object=Address&Operation=GetInnerIDFromGuid&ID=' + guid, function(id)
			{
				//获取tbody
				var list = $(form).next();	
				var tbody = $('tbody', list);
				if (tbody.length == 0)
				{
					$('thead', list).after('<tbody>');
					tbody = $('tbody', list);
				}
				
				//处理默认地址
				if (form.IsDefault.checked)
					$('td:contains(' + _lang_default + ')', list).html('<a href="" data-operation="SetDefault">' + _lang_set_default + '</a>');
				
				//增加到列表中	
				var tr = '<tr data-id="' + id + '">';
				tr += '<td><input type="checkbox" name="Sel"></td>';
				tr += '<td>' + form.Name.value + '</td>';
				tr += '<td>' + $(form.SubAddress).prev().text() + '</td>';
				tr += '<td>' + form.SubAddress.value + '</td>';
				tr += '<td>' + form.Zip.value + '</td>';
				tr += '<td>' + form.Mobile.value + '</td>';
				tr += '<td>' + form.Phone.value + '</td>';
				tr += '<td>' + _lang_delete + '</td>';
				tr += '<td>' + (form.IsDefault.checked ? '<strong>' + _lang_default + '</strong>' : '<a href="" data-operation="SetDefault">' + _lang_set_default + '</a>') + '</td>';
				tr += '</tr>';
				tbody.append(tr);
				
				//提示
				ali.success(_lang_operation_success);
				ali.working();
			});
		}
	});
}


function modifyAddress(form)
{
	//检查收货地址
	if (form.SubAddress.value == '')
	{
		ali.error(_lang_sub_address_empty, $.proxy(function(){form.SubAddress.select();}, this));
		return false;
	}
	
	//检查邮政编码
	if (form.Zip.value == '')
	{
		ali.error(_lang_zip_empty, $.proxy(function(){form.Zip.select();}, this));
		return false;
	}
	
	//检查收货人名称
	if (form.Name.value == '')
	{
		ali.error(_lang_name_empty, $.proxy(function(){form.Name.select();}, this));
		return false;
	}
	
	//检查收货人手机
	if (!form.Mobile.value.match(/^\d{11}$/))
	{
		ali.error(_lang_mobile_incorrect, $.proxy(function(){form.Mobile.select();}, this));
		return false;
	}
	
	//准备数据
	var data = 'Name=' + encodeURIComponent(form.Name.value);
		data += '&RegionID=' + $('select:last', form).val();
		data += '&SubAddress=' + encodeURIComponent(form.SubAddress.value);
		data += '&Zip=' + form.Zip.value;
		data += '&Mobile=' + form.Mobile.value;
		data += '&Phone=' + form.Phone.value;
		data += '&IsDefault=' + form.IsDefault.checked;
	
	//提交数据
	var row = $('[name=Sel]:checked').closest('tr');
	var id = row.data('id');
	
	ali.working(_lang_working);

	$.ajax(
	{
		url: _webPath + 'alicms.aspx?Mark=Home&Object=Address&Operation=Modify&ID=' + id,
		data: data,
		type: 'POST',
		error: function()
		{
			ali.error(_lang_operation_fail);
			ali.working();
		},
		success: function(guid)
		{
			ali.success(_lang_operation_success);
			ali.working();
			
			//从列表中修改	
			var tr = '<td><input type="checkbox" name="Sel"></td>';
			tr += '<td>' + form.Name.value + '</td>';
			tr += '<td>' + $(form.SubAddress).prev().text() + '</td>';
			tr += '<td>' + form.SubAddress.value + '</td>';
			tr += '<td>' + form.Zip.value + '</td>';
			tr += '<td>' + form.Mobile.value + '</td>';
			tr += '<td>' + form.Phone.value + '</td>';
			tr += '<td>' + _lang_delete + '</td>';
			tr += '<td>' + (form.IsDefault.checked ? _lang_default : '<a href="" data-operation="SetDefault">' + _lang_set_default + '</a>') + '</td>';
			row.html(tr);
		}
	});
}

function deleteAddress()
{
	var row = $(this).closest('tr');
	var id = row.data('id');
	
	ali.working(_lang_working);

	$.ajax(
	{
		url: _webPath + 'alicms.aspx?Mark=Home&Object=Address&Operation=Delete&ID=' + id,
		data: {},
		type: 'POST',
		error: function()
		{
			ali.error(_lang_operation_fail);
			ali.working();
		},
		success: function(guid)
		{
			row.remove();
			
			ali.success(_lang_operation_success);
			ali.working();			
		}
	});

	return false;
}

function setDefaultAddress()
{
	var row = $(this).closest('tr');
	var id = row.data('id');
	
	ali.working(_lang_working);

	$.ajax(
	{
		url: _webPath + 'alicms.aspx?Mark=Home&Object=Address&Operation=Modify&ID=' + id,
		data: 'IsDefault=true',
		type: 'POST',
		error: function()
		{
			ali.error(_lang_operation_fail);
			ali.working();
		},
		success: function(guid)
		{
			var old = row.parent().find('td:contains(' + _lang_default + ')');
			if (old.length != 0)
				old.html('<a href="" data-operation="SetDefault">' + _lang_set_default + '</a>');
			$('td:last', row).html('<strong>' + _lang_default + '</strong>');
			
			ali.success(_lang_operation_success);
			ali.working();			
		}
	});

	return false;
}

function deleteCollect()
{
	var li = $(this).closest('li');
	var id = li.data('id');

	ali.working(_lang_working);
	
	$.ajax(
	{
		url: _webPath + 'alicms.aspx?Mark=Home&Object=Collect&Operation=Delete&ID=' + id,
		data: {},
		type: 'POST',
		error: function()
		{
			ali.error(_lang_operation_fail);
			ali.working();
		},
		success: function()
		{
			li.remove();
			ali.success(_lang_operation_success);
			ali.working();
		}
	});

	return false;
}


function onConfirmReceiveSubmit()
{
	var scores = $('.score', this);
	for (var i = 0; i < scores.length; i++)
	{
		var active = $('.active', scores[i]);
		if (active.length == 0)
		{
			ali.error(_lang_score_empty);
			return false;
		}
	}

	var result = true;	
	ali.working(_lang_working);
	$(':submit', this).prop('disabled', true);
	
	//确认收货
	result = confirmReceive(_orderId);
	
	//#region 评价订单
	var stars = $('a', scores[0]);
	var score = stars.index(stars.filter('.active:last')) + 1;

	var data = 'OrderID=' + _orderId;
	data += '&Score=' + score;
	data += '&Content=' + encodeURIComponent($('textarea:first', this).val());
	result = comment(data);
	//#endregion
	
	//#region 评价商品
	var tables = $('table:gt(0)', this);
	for (var i = 0; i < tables.length; i++)
	{
		stars = $('.score a', tables[i]);
		score = stars.index(stars.filter('.active:last')) + 1;

		data = 'OrderID=' + _orderGuid;
		data += '&DetailID=' + tables.eq(i).data('detailId');
		data += '&GoodsID=' + tables.eq(i).data('goodsId');
		data += '&Score=' + score;
		data += '&Content=' + encodeURIComponent($('textarea:first', this).val());
		result = comment(data);
		if (!result)
			break;
	}
	//#endregion
	
	if (result)
	{
		ali.success(_lang_operation_success, $.proxy(function(){window.location = _orderListPath;}, this));
		$(':submit', this).prop('disabled', false);
		ali.working();
	}
	else
	{
		ali.error(_lang_operation_fail);
		$(':submit', this).prop('disabled', false);
		ali.working();
	}
	
	return false;
}

function confirmReceive(orderId)
{
	var result = true;

	$.ajax(
	{
		url: _webPath + 'alicms.aspx?Mark=Home&Object=Order&Operation=ConfirmReceive&ID=' + orderId,
		data: {},
		type: 'POST',
		async: false,
		error: function()
		{
			result = false;
		}
	});
	
	return result;
}

function comment(data)
{
	var result = true;

	$.ajax(
	{
		url: _webPath + 'alicms.aspx?Mark=Home&Object=Comment&Operation=Add',
		data: data,
		type: 'POST',
		async: false,
		error: function()
		{
			result = false;
		}
	});	
	
	return result;
}

(function()
{
	if (typeof(_page) == 'undefined')
		return;
	if (_page == 'material')
	{
		var user = new User();
		$('.block14 .post').submit(user.modifyMaterial);
		
		ali.uploader(null, {url:_webPath + 'alicms.aspx'});

		ali.calendar('[name=Birthday]');
		ali.button('.ali-button');
		ali.uploader('.ali-uploader');
	}
	else if (_page == 'password')
	{
		var user = new User();
		$('.block14 form').submit(user.modifyPassword);
	}
	else if (_page == 'recharge')
	{
		$('.block16 form').submit(function()
		{
			if (!this.Amount.value.match(/^[1-9]\d*(\.\d{1,2})?$/))
			{
				ali.error(_lang_amount_incorrect, $.proxy(function(){this.Amount.select();}, this));
				return false;
			}
			
			var data = 'Title=' + encodeURIComponent(_lang_title);
			data += '&Amount=' + this.Amount.value;
			data += '&PaymentID=' + $('[name=Payment]:checked').val();
			data += '&ReturnUrl=' + encodeURIComponent(window.location.href.replace('recharge', 'recharge_return_url'));
			
			var form = this;
			ali.working(_lang_working);
			$(':submit', form)[0].disabled = true;
		
			$.ajax(
			{
				url: _webPath + 'alicms.aspx?Object=User.Money&Operation=OnlineRecharge',
				data: data,
				type: 'POST',
				error: function(request)
				{
					ali.error(_lang_operation_fail);
					ali.working();
					$(':submit', form)[0].disabled = false;
				},
				success: function(data)
				{
					$('body').append('<div style="display:none">' + data + '</div>').find('form:last').submit();
				}
			});
			
			return false;
		});
	}
	else if(_page == 'login')
	{
		//登录信息
		var form = $('.block11-right form');
		
		//验证码
		$('#check-code-image').click(function(){$(this).attr('src', _webPath + 'alicms.aspx?Action=CheckCode&' + Math.random());});
		
		$('[name=Name]', form).focus(function()
		{
			if ($(this).val() == $(this).attr('title'))
				$(this).val('');
		}).blur(function()
		{
			if (this.value == '')
				$(this).val($(this).attr('title'));
		})
		form.submit(login);
		//end登录
		
		//注册
		var register = new Register();
		
		//事件绑定
		var form = $('.block12 form');
		form.submit(register.onSubmit);
		$('[name=Name]', form).blur(register.onNameBlur);
		$('[name=Password]', form).blur(register.onPasswordBlur);
		$('[name=Confirm]', form).blur(register.onConfirmBlur);
		$('[name=Email]', form).blur(register.onEmailBlur);
		$('[name=Mobile]', form).blur(register.onMobileBlur);
		$('[name=QQ]', form).blur(register.onQQBlur);

	}
	else if(_page == 'address')
	{
		var form = $('.block19');
		
		//处理地区变化
		form.on('change', 'select', onRegionChange);
		
		//表单处理
		form.submit(onAddressSubmit);
		
		//处理删除
		$('[data-operation=Delete]').click(deleteAddress);
		
		//处理设为默认
		$('.block20').on('click', '[data-operation=SetDefault]', setDefaultAddress);
		
		//处理选择
		var sels = $('[name=Sel]');
		sels.click(function()
		{
			if (this.checked)
			{
				//限制只选择一条
				sels.prop('checked', false);
				this.checked = true;
				
				//设置提交按钮为“修改”
				$(':submit', form).val(_lang_modify);
				
				//当前地址填充到表单
				var row = $(this).closest('tr');
				$(form[0].SubAddress).prev().text($('td:eq(2)', row).text());
				form[0].SubAddress.value = $('td:eq(3)', row).text();
				form[0].Zip.value = $('td:eq(4)', row).text();
				form[0].Name.value = $('td:eq(1)', row).text();
				form[0].Mobile.value = $('td:eq(5)', row).text();
				form[0].Phone.value = $('td:eq(6)', row).text();
				form[0].IsDefault.checked = $.trim($('td:last', row).text()) == _lang_default;
			}
			else
			{
				//设置提交按钮为“添加”
				$(':submit', form).val(_lang_add);
			}
		});
	}
	else if(_page == 'collect')
	{
		$('.list24 h2 a:nth-child(2)').click(deleteCollect);
	}
	else if(_page == 'receive')
	{
		$('.score a').mouseenter(function()
		{
			$(this).addClass('active').prevAll().addClass('active').end().nextAll().removeClass('active');
		});
		
		$('.block21').submit(onConfirmReceiveSubmit);
	}
	
})();