<%@ Page PathInChannel="login{Ext}"%>
<!doctype html>
<html lang="<%=PageLang%>">
<head>
<ali:Get ID="Config" Object="InstanceConfig" Operation="GetBasicSettings()" />
<meta charset="utf-8">
<meta name="keywords" content="<%=MetaKeywords%>">
<meta name="description" content="<%=MetaDescription%>">
<title>请登录 - <%=Channel[Name]%> - <%=Site[Name]%></title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<link rel="stylesheet" href="<%=CommonPath%>aliui/skin/default/common.css">
<ali:Comment><link rel="stylesheet" href="../S01/CHS/css/common.css"></ali:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css">
<script>
var _page = 'login',
	_webPath = '<%=WebPath%>',
	_referer = '<%=Request.QueryString["Referer"]%>',
	_isNeedToCheck = <%=Config[IsNeedToCheck]%>,
	_lang_name_empty = '用户名不能为空！',
	_lang_password_empty = '密码不能为空！',
	_lang_check_code_empty = '验证码不能为空！',
	_lang_login_fail = '登陆失败！<br />请检查你的用户名和密码是否正确！',
	_lang_name_incorrect = '用户名为5-20位的字母或数！',
	_lang_name_exist = '此用户名已被别人使用！',
	_lang_password_empty = '密码不能为空！',
	_lang_password_incorrect = '密码格式有错！',
	_lang_password_nosame = '两次密码不一致！',
	_lang_mobile_incorrect = '手机格式有错！',
	_lang_email_incorrect = '电子邮件格式有错！',
	_lang_email_exist = '电子邮件已存在！',
	_lang_qq_incorrect ='QQ号码不正确！',
	_lang_tongyi_exist = '你还没选择我们的注册协议！'
	_lang_register_success = '注册成功！',
	_lang_login_success = '登录成功！'
	_lang_working = '正在操作...',
	_lang_operation_fail = '操作失败！';
</script>
</head>
<body>
<div class="top-menu">
	<div class="wrap">
		<!-- start="登陆状态" -->
		<div> <span> 亲，欢迎您的光临本站，赶快淘喜欢的宝贝吧！ <a href="<%=BuildUrl("login")%>?Referer=<%=Request.RawUrl%>">[请登录]</a> <a href="<%=BuildUrl("register")%>">[免费注册]</a> </span> <span style="display:none">你好！<a href="<%=BuildUrl("index")%>" id="user"></a>，<a href="<%=BuildUrl("logout")%>?Referer=<%=Request.RawUrl%>">安全退出</a></span> </div>
		<!-- end="登陆状态" -->
		
		<!-- start="语言导航"-->
		<ali:Menu Condition="CategoryID={7dfb1283-df5c-4c2a-a94e-61d8dd38df5d}">
			<ul>
				<ali:Record>
					<li><a href="<%=URL%>"<%=Style%> target="<%=Target%>"><%=Name%></a></li>
				</ali:Record>
			</ul>
		</ali:Menu>
		<!-- end="语言导航" -->
	</div>
</div>

<div class="header">
	<div class="header-left"> <a href="<%=BuildUrl("index")%>"><img src="<%=Logo%>" alt="<%=Site[Name]%>"></a> </div>
	<div class="header-mid">
	   <!-- start="搜索" -->
		<form action="<%=BuildUrl(null, "goods_category", "CategoryID=_&BrandID=_&List=_&Order=_&OrderMore=_&q=_{q}")%>">
			<dl>
				<dd>
					<input type="text" name="q" class="keyword <%=PageLang%>Font">
				</dd>
				<dt>
					<input type="submit" value="搜索">
				</dt>
			</dl>
		</form>
		<!-- end="搜索" -->
		
		<!-- start="热门搜索" -->
		<ul>
			<li>热门搜索：</li>
			<ali:List Mark="Goods" Object="Goods" Page="1" PageSize="3" Condition="IsDeleted=false and IsReleased=true" Sort="HitCount DESC">
				<ali:Record>
					<li><a href="<%=BuildUrl()%>" target="_blank"><%=Name%></a></li>
				</ali:Record>
			</ali:List>
		</ul>
	    <!-- end="热门搜索" -->
	</div>
	<div class="header-right">
		<dl>
			<dt><a href="<%=BuildUrl("index")%>">我的账号</a></dt>
			<dd style="display:none">
				<!-- start="我的账号" -->
				<ali:Menu Condition="CategoryID={1155117e-8090-4978-8359-b3719f325d34}">
					<ali:Record>
						 <a href="<%=URL%>" target="<%=Target%>"><%=Name%></a> 
					 </ali:Record> 	
				</ali:Menu>
				<!-- end="我的账号" -->
			</dd>
		</dl>
		<div><a href="<%=BuildUrl("Home", "cart")%>">购物车(<b id="cart-count">0</b>)</a></div>
	</div>
</div>

<div class="menu">
	<dl>
		<!-- start="主菜单" -->
		<ali:Menu Condition="IsDisplay=true and CategoryID IS NULL" >
			<ali:Record>
				<dd><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dd>
			</ali:Record>
		</ali:Menu>
		<!-- end="主菜单" -->
	</dl>
</div>

<!-- start="路径" -->
<div class="path">
	<ali:Path IncludeCurrentChannel="True">
		你的位置 :
		<ali:Record>
			<a href="<%=URL%>" title="<%=Name%>"><%=Name%></a> &gt;
		</ali:Record>
	</ali:Path>
	登录页
</div>
<!-- end="路径" -->

<div class="userbg">
	<dl>
		<dd>
			<h2>用户注册</h2>
		</dd>
		<dt>
			<h2>用户登录</h2>
		</dt>
	</dl>
</div>
<div class="user-Main">
	<div class="block11-right">
		<form action="" method="post">
			<dl>
				<dt>用户名字 :</dt>
				<dd><input type="text" name="Name" value="账号/手机号/电子邮箱" title="账号/手机号/电子邮箱"></dd>
				<dt>用户密码:</dt>
				<dd><input  type="password" name="Password"></dd>
				<dt>验证码:</dt>
				<dd><input type="text"  name="CheckCode"><img id="check-code-image" src="<%=WebPath%>alicms.aspx?Action=CheckCode" title="点击图片重新生成"></dd>
				<dt> 记住</dt>
				<dd><input type="checkbox" class="a" id="remember">记住登录状态</dd>
				<dt class="btn"><input  type="submit" value="登录" class="login_btn"><dt>
			</dl>
		</form>
	</div>
	
	<div class="block12">
		<form action="" method="post">
			<table>
				<tbody>
					<tr>
						<th>用户名<em>*</em></th>
						<td><input type="text" name="Name" class="<%=PageLang%>Font" title="5-20位字母或数字" maxlength="20" autocomplete="off">
							<strong>5-20位字母或数字</strong></td>
					</tr>
					<tr>
						<th>密码<em>*</em></th>
						<td><input type="password" name="Password"  class="CHSFont"  title="6-20位字母或数字" maxlength="20" autocomplete="off">
							<strong>6-20位字母或数字</strong>
						</td>
					</tr>
					<tr>
						<th>确认密码<em>*</em></th>
						<td><input type="password" name="Confirm" class="CHSFont" title="请重复输入密码"><strong>请重复输入密码</strong></td>
					</tr>
					<tr>
						<th>邮箱</th>
						<td><input type="text" name="Email" class="CHSFont" title="请输入常用的电子邮箱" autocomplete="off">
							<strong>请输入常用的电子邮箱</strong>
						</td>
					</tr>
					<tr>
						<th>手机号码</th>
						<td><input type="text" name="Mobile" title="请输入常用的手机号码，是11位哦" autocomplete="off" class="CHSFont">
							<strong>请输入常用的手机号码，是11位哦</strong>
						</td>
					</tr>
					<tr>
						<th>QQ</th>
						<td><input type="text" name="QQ" title="请输入常用的QQ账号" autocomplete="off" class="CHSFont">
							<strong>请输入常用的QQ账号</strong>
						</td>
					</tr>
				</tbody>
				<tfoot>
					<tr>
						<th colspan="3"><input type="checkbox" id="agreement">
							已阅读并同意服务条款 
							<a href="" style="color:blue" >阅读服务条款</a>
						 </th>
					</tr>
					<tr>
						<td colspan="3"><input type="submit" value="注册"></td>
					</tr>
				</tfoot>
			</table>
		</form>
	</div>
</div>

<!-- start="页脚帮助导航" -->
<ali:Menu Condition="IsDisplay=true and CategoryID={43933a81-064a-4f2c-b32e-5e5f7f319f8e} and ParentID IS NULL">
	<div class="block2 margin1">
		<div class="block2-wrap">
			<ali:Record>
				<dl>
					<dt><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dt>
					<ali:Menu Condition="IsDisplay=true and ParentID=ID">
						<ali:Record>
							<dd><a href="<%=URL%>" target="<%=Target%>"><%=Name%></a></dd>
						</ali:Record>
					</ali:Menu>
				</dl>
			</ali:Record>
		</div>
	</div>
</ali:Menu>
<!-- end="页脚帮助导航" -->

<!-- start="友情链接" -->
<div class="link">
	<ul>
		<ali:List Mark="System" Object="Link" Condition="IsChecked=true and Logo IS NOT NULL">
			<ali:Record>
				<li><a href="<%=URL%>" target="_blank" ><img src="<%=Logo%>" alt="<%=Name%>"></a></li>
			</ali:Record>
		</ali:List>
	</ul>
</div>
<!-- end="友情链接" -->

<!-- start="脚注菜单" -->
<div class="footer-menu">
	<ali:Menu Condition="IsDisplay=true and CategoryID={BAC035A8-F6BB-4772-8D51-A7F4F3AB7AD3}">
		<ali:Record>
			<a href="<%=URL%>" target="<%=Target%>"><%=Name%></a>
			<ali:Separator>|</ali:Separator>
		</ali:Record>
	</ali:Menu>
</div>
<!--end="脚注菜单" -->
	
<!-- start="脚注" -->
<div class="footer">
	<%=Footer%>
</div>
<!-- end="脚注" -->

<script src="<%=CommonPath%>jquery/core.js"></script> 
<script src="<%=CommonPath%>json2.js"></script>
<script src="<%=CommonPath%>aliui/ali.min.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script src="<%=JsPath("global.js")%>"></script>
<script src="<%=JsPath%>common.js"></script>
<%=StatCode%>
</body>
</html>
