(function()
{
	//-------------------------------------------------
	//Start: 获取模板路径，并加到helper中
	var __p = $('script:last').attr('src');
	__p = __p.substr(0, __p.lastIndexOf('/js/module.js') + 1);
	_helper.addInit(__p, init);
	//End: 获取模板路径，并加到helper中
	//-------------------------------------------------
	
	//-------------------------------------------------
	//Start: 辅助函数
	//词典中，获取关键字对应的值
	function w(k){return _helper.dict(__p, k);}
	//获取对象名称
	function o(f){return f.toString().match(/^function (\w+)\(/)[1];}
	//获取页面变量值
	function v(p, n){return $('>section', p).data(n);}
	//End: 辅助函数
	//-------------------------------------------------

	//-------------------------------------------------
	//Start: 初始化
	function init(instance, page, panel)
	{
		if (page == 'purchase_list')
		{
			//创建对象
			var purchase = new Purchase(instance, panel);

			//绑定事件
			panel.on('click', '[data-operation=ConfirmReceive]', purchase.onConfirmReceiveClick)
				.on('submit', '[data-page=confirm_receive] form:first', purchase.onConfirmReceiveSubmit)
				.on('submit', '[data-page=stock_in_from_purchase] form:first', purchase.onStockInFromPurchaseSubmit);
		}
	}
	//End: 初始化
	//-------------------------------------------------

	//-------------------------------------------------
	//Start: 采购单
	function Purchase(instance, panel)
	{
		var __object = o(arguments.callee);		

		this.onConfirmReceiveClick = function()
		{
			ali.dialog({name:'ConfirmReceive',modal:true,appendTo:panel,width:500,height:200,resizable:false,url:_helper.toAbsPanel(panel, 'confirm_receive.aspx?PurchaseID=' + $(this).closest('tr').data('id')),onBeforeLoad:_helper.onDialogBeforeLoad,onShow:_helper.onDialogShow});
			return false;
		};
		
		this.onConfirmReceiveSubmit = function()
		{
			var data = _helper.serialize(this),
				purchaseId = $(this).data('purchaseId');

			//提交数据
			_helper.post({instance:instance,object:__object,operation:'ConfirmReceive',data:data,params:'ID=' + purchaseId,silent:true});

			//关闭对话框
			ali.dialog($(this).closest('.ali-dialog-body').children(), 'close');
			
			//弹出入库单对话框
			ali.dialog({name:'StockInFromPurchase',modal:true,appendTo:panel,width:800,height:400,resizable:false,url:_helper.toAbsPanel(panel, 'stock_in_from_purchase.aspx?PurchaseID=' + purchaseId),onBeforeLoad:_helper.onDialogBeforeLoad,onShow:_helper.onDialogShow});

			return false;
		};
		
		this.onStockInFromPurchaseSubmit = function()
		{
			var grid = $('.ali-grid', this).prev();
			
			//获取所有行
			var rows = ali.grid(grid, 'getRows');

			//准备编号
			var nos = '';
			for (var i = 0; i < rows.length; i++)
			{
				if (i > 0)
					nos += '|';
				nos += rows[i].goodsNo;
			}
			
			//获取商品其他属性
			var moreProps = null;
			$.ajax(
			{
				type: 'GET',
				dataType: 'json',
				url: _helper.toAbsPanel(panel, 'ajax_goods.aspx?Nos=' + nos),
				async: false,
				success: function(data)
				{
					moreProps = data;
				}
			});
			
			//补充属性
			for (var i = 0; i < rows.length; i++)
			{
				for (var j = 0; j < moreProps.length; j++)
				{
					if (rows[i].goodsNo == moreProps[j].no || moreProps[j].spec.indexOf(rows[i].goodNo) != -1)
					{
						rows[i].categoryName = moreProps[j].categoryName;
						rows[i].categoryId = moreProps[j].categoryId;
						rows[i].categoryParentChain = moreProps[j].categoryParentChain;
						break;
					}
				}
			}

			//准备数据
			var data = 'No=' + $(this).data('stockInNo');
			data += '&WarehouseID=' + $(this).data('warehouseId');
			data += '&PurchaseID=' + $(this).data('purchaseGuid');
			data += '&PurchaseNo=' + $(this).data('purchaseNo');
			data += '&Memo=' + encodeURIComponent(this.Memo.value);

			//提交入库单数据
			var stockInId = _helper.post({mark:'Warehouse',object:'StockIn',operation:'Add',data:data,silent:true});
			
			//#region 提交入库单商品
			for (var i = 0; i < rows.length; i++)
			{
				//准备数据
				data = 'StockInID=' + stockInId;
				data += '&GoodsName=' + encodeURIComponent(rows[i].goodsName);
				data += '&GoodsNo=' + rows[i].goodsNo;
				data += '&GoodsBarCode=' + rows[i].goodsBarCode;
				data += '&GoodsSpec=' + encodeURIComponent(rows[i].goodsSpec);
				data += '&Price=' + encodeURIComponent(rows[i].price);
				data += '&Amount=' + encodeURIComponent(rows[i].amount);
				data += '&Memo=' + encodeURIComponent(rows[i].memo);
				
				//提交数据
				_helper.post({mark:'Warehouse',object:'StockIn.Detail',operation:'Add',data:data,silent:true});
				
				//#region 提交库存数据
				
				//准备数据
				data = 'WarehouseID=' + $(this).data('warehouseId');
				data += '&GoodsName=' + encodeURIComponent(rows[i].goodsName);
				data += '&GoodsNo=' + rows[i].goodsNo;
				data += '&GoodsBarCode=' + rows[i].goodsBarCode;
				data += '&GoodsSpec=' + encodeURIComponent(rows[i].goodsSpec);
				data += '&SupplierName=' + encodeURIComponent($(this).data('supplierName'));
				data += '&SupplierID=' + $(this).data('supplierId');
				data += '&CategoryName=' + encodeURIComponent(rows[i].categoryName);
				data += '&CategoryID=' + rows[i].categoryId;
				data += '&CategoryParentChain=' + rows[i].categoryParentChain;
				data += '&Price=' + encodeURIComponent(rows[i].price);
				data += '&Amount=' + encodeURIComponent(rows[i].amount);
				data += '&ExpiredTime=' + encodeURIComponent(rows[i].expiredTime);
				
				//提交数据
				_helper.post({mark:'Warehouse',object:'Stock',operation:'Add',data:data,silent:true});
				
				//#endregion
			}
			//#endregion
			
			ali.success(_lang_operation_success);

			//刷新列表
			$('.search1', panel).submit();

			//关闭对话框
			ali.dialog($(this).closest('.ali-dialog-body').children(), 'close');
			
			return false;
		};
	}
	//End: 采购单
	//-------------------------------------------------
})();
////@ sourceURL=AliShop.PurchaseModule.js