﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.AdminPageBase" %>
<ali:Get ID="Purchase" Object="Purchase" InnerID="Request.QueryString['PurchaseID']" />
<section data-page="stock_in_from_purchase" data-title="入库单">
	<div class="content">
		<form action="" class="post" data-stock-in-no="<%=DateTime.Now.ToString("yyyyMMddhhmmss")%>" data-purchase-id="<%=Purchase[InnerID]%>" data-purchase-guid="<%=Purchase[ID]%>" data-purchase-no="<%=Purchase[No]%>" data-warehouse-id="<%=Purchase[WarehouseID]%>" data-supplier-name="<%=Purchase[SupplierName]%>" data-supplier-id="<%=Purchase[SupplierID]%>">
			<div class="post-body">
				<table data-ali-widget="grid" class="grid1">
					<thead>
						<tr>
							<th data-name="goodsName">商品名称</th>
							<th data-name="goodsNo">商品编码</th>
							<th data-name="goodsBarCode">商品条码</th>
							<th data-name="goodsSpec">商品规格</th>
							<th data-name="price">进货价格</th>
							<th data-name="amount">进货数量</th>
							<th data-name="expiredTime">过期日期</th>
							<th data-name="memo">备注</th>
						</tr>
					</thead>
					<tbody>
						<ali:List Object="Purchase.Detail" Condition="PurchaseID=Purchase[ID]">
							<ali:Record>
								<tr>
									<td><%=GoodsName%></td>
									<td><%=GoodsNo%></td>
									<td><%=GoodsBarCode%></td>
									<td><%=GoodsSpec%></td>
									<td><%=Convert.ToDecimal(Price).ToString("0.00")%></td>
									<td><%=Amount%></td>
									<td><input type="text" size="10" class="ali-input" readonly data-ali-widget="calendar"></td>
									<td><input type="text" size="10" class="ali-input"></td>
								</tr>
							</ali:Record>
						</ali:List>
					</tbody>
				</table>

				<table class="post-table">
					<tr>
						<th>备注：</th>
						<td><textarea rows="5" cols="50" name="Memo"></textarea></td>
					</tr>
				</table>
			</div>
			<div class="post-footer"><button type="submit" class="ali-button">入库</button></div>
		</form>
		</form>
	</div>
</section>