﻿<%@ Page CodeFileBaseClass="AliCMS.Lib.AdminPageBase" %>
<ali:Get ID="StockOut" Object="StockOut" InnerID="Request.QueryString['ID']" Validate="True" />
<section data-page="stock_out_edit" data-title="编辑出库单" data-id="<%=StockOut[InnerID]%>" data-guid="<%=StockOut[ID]%>" data-to-type="<%=StockOut[ToType]%>">
	<div class="path1"><span>您的位置：</span><a href="list.aspx" target="ali-navtab">出库单列表</a> → <b class="<%=ContentLang%>Font"><%=StockOut[No]%></b></div>
	<form action="" class="post">
		<div class="post-body">
			<table class="post-table">
				<tr>
					<th width="140">出库单号：</th>
					<td><input type="text" name="No" value="<%=StockOut[No]%>" size="40" maxlength="150" class="ali-input ali-input-required"></td>
				</tr>
				<tr>
					<th>目标类型：</th>
					<td>
						<select name="ToType">
							<option value="Shop">店铺</option>
							<option value="Warehouse">仓库（暂未实现）</option>
							<option value="Online">线上电商平台（暂未实现）</option>
						</select>
					</td>
				</tr>
				<tr>
					<th>目标<span>店铺</span>：</th>
					<td><input type="text" name="ToName" value="<%=StockOut[ToName]%>" size="40" maxlength="50" readonly class="ali-input ali-input-required <%=ContentLang%>Font"><input type="hidden" name="ToNo" value="<%=StockOut[ToNo]%>"><input type="hidden" name="ToID" value="<%=StockOut[ToID]%>"> <a class="ali-button" data-operation="SelectTo">选择</a></td>
				</tr>
				<tr>
					<th>收货人名称：</th>
					<td><input type="text" name="ReceiverName" value="<%=StockOut[ReceiverName]%>" size="40" class="ali-input ali-input-required"></td>
				</tr>
				<tr>
					<th>收货人地址：</th>
					<td><input type="text" name="ReceiverAddress" value="<%=StockOut[ReceiverAddress]%>" size="40" class="ali-input ali-input-required"></td>
				</tr>
				<tr>
					<th>收货人电话：</th>
					<td><input type="text" name="ReceiverPhone" value="<%=StockOut[ReceiverPhone]%>" size="40" maxlength="50" class="ali-input ali-input-required"></td>
				</tr>
				<tr>
					<th>邮政编码：</th>
					<td><input type="text" name="ReceiverZip" value="<%=StockOut[ReceiverZip]%>" size="40" maxlength="50" class="ali-input ali-input-required"></td>
				</tr>
			</table>

			<div class="ali-panel margin3" data-height-style="content">
				<div class="ali-panel-header">商品清单</div>
				<div class="ali-panel-body">
					<a class="ali-button" data-operation="SelectGoods">选择商品</a>
					<table data-ali-widget="grid" class="grid1">
						<thead>
							<tr>
								<th data-name="goodsName">商品名称</th>
								<th data-name="goodsNo">商品编号</th>
								<th data-name="goodsBarCode">商品条码</th>
								<th data-name="goodsSpec">商品规格</th>
								<th data-name="price" width="60">平均单价</th>
								<th data-name="amount" width="60">数量</th>
								<th data-name="memo" width="120">备注</th>
								<th data-name="operation" width="80">删除</th>
							</tr>
						</thead>
						<tbody>
							<ali:List Object="StockOut.Detail" Condition="StockOutID=StockOut[ID]">
								<ali:Record>
									<tr data-id="<%=InnerID%>">
										<td><%=GoodsName%></td>
										<td><%=GoodsNo%></td>
										<td><%=GoodsBarCode%></td>
										<td><%=GoodsSpec%></td>
										<td><%=Price%></td>
										<td><%=Amount%></td>
										<td><input type="text" value="<%=Memo%>" size="10" class="ali-input"></td>
										<td><a href="" class="ali-button">删除</a></td>
									</tr>
								</ali:Record>
							</ali:List>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="post-footer"><button type="submit" class="ali-button">保 存</button></div>
	</form>
</section>