﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;
using System.Text;

public partial class Advert_Update : PasePage
{
    JY.BLL.Advert bll = new JY.BLL.Advert();
    JY.Model.Advert model = new JY.Model.Advert();
    JY.BLL.ComDataList combll = new ComDataList();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.txtSort.Attributes["number_type"] = "int";
            bing_dd_type();
            initAdvert();
        }
    }

    /// <summary>
    /// 一级菜单下拉框
    /// </summary>
    protected void bing_dd_type()
    {
        try
        {
            ddlAdvertType.Items.Clear();
            DataTable dt = new DataTable();
            if (Request.QueryString["TypeId"] == null || Request.QueryString["TypeId"] == "" || Request.QueryString["TypeId"] == "0")
            {
                //ddlAdType.Items.Add(new ListItem("一级父类", "0,-1"));
                dt = combll.GetComList(0, " id,TypeName,Depth ", " AdvertType ", " isdelete=0 and depth=0 and Fid=0 ", " Sort asc,id desc ");
            }
            else
            {
                dt = combll.GetComList(0, " id,TypeName,Depth ", " AdvertType ", " isdelete=0 and id=" + Request.QueryString["TypeId"], " Sort asc,id desc ");
            }
            if (dt != null && dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    ListItem li = new ListItem();
                    li.Text = "╋" + dt.Rows[i]["TypeName"].ToString();
                    li.Value = dt.Rows[i]["id"].ToString() + "," + dt.Rows[i]["Depth"].ToString();
                    ddlAdvertType.Items.Add(li);
                    BindChild(dt.Rows[i]["id"].ToString(), Convert.ToInt32(dt.Rows[i]["Depth"].ToString()) + 1);
                }
            }
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    /// <summary>
    /// 子菜单下拉框
    /// </summary>
    protected void BindChild(string fatherid, int depth)
    {
        try
        {
            DataTable dt = combll.GetComList(0, " id,TypeName,Depth ", " AdvertType ", " isdelete=0 and Depth=" + depth + " and Fid=" + fatherid + " ", " Sort asc,id desc ");
            if (dt != null && dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    string separator = "├──";
                    if (depth > 1)
                    {
                        for (int j = 2; j <= depth; j++)
                        {
                            separator += "──";
                        }
                    }
                    ListItem li = new ListItem();
                    li.Text = separator + dt.Rows[i]["TypeName"].ToString();
                    li.Value = dt.Rows[i]["id"].ToString() + "," + dt.Rows[i]["Depth"].ToString();
                    ddlAdvertType.Items.Add(li);
                    BindChild(dt.Rows[i]["id"].ToString(), Convert.ToInt32(dt.Rows[i]["Depth"].ToString()) + 1);
                }
            }
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    /// <summary>
    /// 绑定数据
    /// </summary>
    protected void initAdvert()
    {
        model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
        JY.BLL.AdvertType adbll = new JY.BLL.AdvertType();
        JY.Model.AdvertType admodel = new JY.Model.AdvertType();
        admodel = adbll.GetModel(Convert.ToInt32(model.AdvertTypeId.ToString()));
        this.ddlAdvertType.SelectedValue = admodel.ID.ToString() + "," + admodel.Depth.ToString();
        this.txtAdvertName.Text = model.AdvertName;
        this.txtHight.Text = model.Height.ToString();
        this.txtWidth.Text = model.Width.ToString();
        this.txtAdvertUrl.Text = model.AdvertUrl.ToString();
        this.txtSort.Text = model.Sort.ToString();
        this.hid.Value = model.AdvertPic;
        this.txtDescription.Text = model.Description.ToString();
    }

    /// <summary>
    /// 保存图片
    /// </summary>
    public void btnUpPic_Click(object sender, EventArgs e)
    {

        if (file1.PostedFile != null)
        {
            if (file1.PostedFile.ContentLength > 2097152)
            {
                publicHandle.ShowMessage(this.Page, "提示：图片不能大于2M！");
                return;
            }
            else
            {
                hid.Value = upPhoto(file1);
                Response.Write("<script>alert('上传成功！');</script>");
            }
        }
    }

    /// <summary>
    /// 返回文件名称
    /// </summary>
    protected string upPhoto(FileUpload file)
    {
        if (file.PostedFile != null)
        {
            if (file.PostedFile.ContentLength > 2097152)
            {
                publicHandle.ShowMessage(this.Page, "提示：图片不能大于2M！");
                return "";
            }
            else
            {
                string filename;//文件名字
                string hz;
                string newname;
                filename = file.FileName;
                //取后缀
                int pos = filename.IndexOf(".");
                hz = filename.Substring((pos + 1)).ToLower();
                //newname = System.Guid.NewGuid().ToString("N") + "." + hz;
                newname = sjname() + "." + hz;
                //保存图片
                string pathurl;
                pathurl = Server.MapPath("~") + "\\Admin\\Upfile\\" + newname;
                string kb = file1.FileContent.Length.ToString();
                file.PostedFile.SaveAs(pathurl);
                return newname;
            }
        }
        else
        {
            return "";
        }
    }

    /// <summary>
    /// 产生一个随机名称，以免图片名重复时将覆盖文件原有文件
    /// </summary>
    public string sjname()
    {
        string sj = null;
        sj = DateTime.Now.Year.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Day.ToString() + DateTime.Now.TimeOfDay.Hours.ToString() + DateTime.Now.TimeOfDay.Minutes.ToString() + DateTime.Now.TimeOfDay.Milliseconds.ToString();
        return sj;
    }

    /// <summary>
    /// 提交事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void tijiao_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
            model.AdvertName = this.txtAdvertName.Text.Trim();
            model.AdvertTypeId = Convert.ToInt32(this.ddlAdvertType.SelectedValue.Split(new char[] { ',' })[0]);
            if (rbtAdvertPic.Checked)
            {
                model.AdvertCategory = 0;
            }
            else
            {
                model.AdvertCategory = 1;
            }
            model.Sort = Convert.ToInt32(this.txtSort.Text.Trim());
            model.Height = Convert.ToInt32(this.txtHight.Text.Trim());
            model.Width = Convert.ToInt32(this.txtWidth.Text.Trim());
            model.AdvertUrl = this.txtAdvertUrl.Text.Trim();
            model.AdvertPic = hid.Value;
            if (this.hidfuPic.Value.Trim() != null && this.hidfuPic.Value.Trim() != "")
            {
                model.AdvertPic = this.hidfuPic.Value.Trim();
            }
            model.Description = this.txtDescription.Text.Trim();
            if (bll.Update(model))
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，广告信息修改成功！", "Advert_Manage.aspx");
            }
            else 
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，广告信息修改失败！", "Advert_Manage.aspx");
            }
        }
        catch (Exception ex)
        {
            publicHandle.ShowMessage(this, ex.Message);
        }
    }

    /// <summary>
    /// 取消事件
    /// </summary>
    public void btnReturn_Click(object sender, EventArgs e)
    {
        Response.Redirect("Advert_Manage.aspx");
    }
}