﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;
using System.Text;

public partial class Brand_Add : PasePage
{
    JY.BLL.Brand bll = new JY.BLL.Brand();
    JY.Model.Brand model = new JY.Model.Brand();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            
        }
    }

    /// <summary>
    /// 保存图片
    /// </summary>
    public void btnUpPic_Click(object sender, EventArgs e)
    {

        if (file1.PostedFile != null)
        {
            if (file1.PostedFile.ContentLength > 2097152)
            {
                publicHandle.ShowMessage(this.Page, "提示：图片不能大于2M！");
                return;
            }
            else
            {
                hid.Value = upPhoto(file1);
                Response.Write("<script>alert('上传成功！');</script>");
            }
        }
    }

    /// <summary>
    /// 返回文件名称
    /// </summary>
    protected string upPhoto(FileUpload file)
    {
        if (file.PostedFile != null)
        {
            if (file.PostedFile.ContentLength > 2097152)
            {
                publicHandle.ShowMessage(this.Page, "提示：图片不能大于2M！");
                return "";
            }
            else
            {
                string filename;//文件名字
                string hz;
                string newname;
                filename = file.FileName;
                //取后缀
                int pos = filename.IndexOf(".");
                hz = filename.Substring((pos + 1)).ToLower();
                //newname = System.Guid.NewGuid().ToString("N") + "." + hz;
                newname = sjname() + "." + hz;
                //保存图片
                string pathurl;
                pathurl = Server.MapPath("~") + "\\Admin\\Upfile\\" + newname;
                string kb = file1.FileContent.Length.ToString();
                file.PostedFile.SaveAs(pathurl);
                return newname;
            }
        }
        else
        {
            return "";
        }
    }

    /// <summary>
    /// 产生一个随机名称，以免图片名重复时将覆盖文件原有文件
    /// </summary>
    public string sjname()
    {
        string sj = null;
        sj = DateTime.Now.Year.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Day.ToString() + DateTime.Now.TimeOfDay.Hours.ToString() + DateTime.Now.TimeOfDay.Minutes.ToString() + DateTime.Now.TimeOfDay.Milliseconds.ToString();
        return sj;
    }


    /// <summary>
    /// 提交事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void tijiao_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            model.BrandName = txtBrandName.Text.Trim();
            model.LogoPic = hid.Value;
            model.Description = txtDescription.Value;
            model.IsDelete = false;
            if (bll.Add(model) > 0)
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，品牌添加成功！", "Brand_Manage.aspx");
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "对不起，品牌添加失败！", "Brand_Manage.aspx");
            }
        }
        catch (Exception er)
        {
            publicHandle.ShowMessage(this, er.Message);
        }
    }

    /// <summary>
    /// 取消事件
    /// </summary>
    public void btnReturn_Click(object sender, EventArgs e)
    {
        Response.Redirect("Brand_Manage.aspx");
    }
}

