﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;

public partial class Collection_Manage : PasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BindData();
        }
    }

    private int GetInt(object obj, int defaultValue)
    {
        if (obj != null)
        {
            try
            {
                defaultValue = Convert.ToInt32(obj);
            }
            catch
            {
            }
        }
        return defaultValue;
    }

    /// <summary>
    /// 获取列表数据
    /// </summary>
    private void BindData()
    {
        int pageIndex = GetInt(Request.QueryString["Page"], 1);
        Pagination.Pagination _page = new Pagination.Pagination();

        _page.ItemUnit = "个号码";
        _page.ImagesPath = "~/Images/ui_form/";
        _page.Sequence = pageIndex;
        _page.PageSize = pager.PageSize;
        _page.TableName = "  Collection ";
        _page.SearchField = " * ";

        _page.SearchSentence = " and Collection.Isdelete=0 ";

        if (Request.QueryString["ProductId"] != null && Request.QueryString["ProductId"] != "")
        {
            _page.SearchSentence += " and ProductId=" + Request.QueryString["ProductId"];
            txtProductId.Text = Request.QueryString["ProductId"];
        }

        if (Request.QueryString["keyWord"] != null && Request.QueryString["keyWord"] != "")
        {
            _page.SearchSentence += " and (ProductName like '%" + Server.UrlDecode(Request.QueryString["keyWord"]) + "%' or MemberName  like '%" + Server.UrlDecode(Request.QueryString["keyWord"]) + "%') ";
            txtKeyword.Text = Request.QueryString["keyWord"];
        }

        _page.SortSentence = " Order By Collection.Id desc ";
        _page.Primarykey = " Collection.Id ";
        DataTable dt = _page.GetDataTable();

        rptCollection.DataSource = dt;
        rptCollection.DataBind();

        pager.RecordCount = _page.RecordCount;
        //显示记录信息   [ 共1508条 第1页 共151页 ]
        pager.CustomInfoHTML = "<span>共有&nbsp;<b>" + pager.RecordCount.ToString() + "</b>&nbsp;条记录，";
        pager.CustomInfoHTML += " 当前第&nbsp;<font color=\"red\"><b>" + pageIndex.ToString() + "</b></font>&nbsp;页，";
        pager.CustomInfoHTML += " 共&nbsp;<b>" + pager.PageCount.ToString() + "</b>&nbsp;页</span>";

    }

    /// <summary>
    /// 查询
    /// </summary>
    protected void btnquery_Click(object sender, EventArgs e)
    {
        string strUrl = "Collection_Manage.aspx?1=1";

        if (txtProductId.Text.Trim() != "")
        {
            strUrl += "&ProductId=" + Server.UrlEncode(txtProductId.Text.Trim());
        }
        if (txtKeyword.Text.Trim() != "")
        {
            strUrl += "&keyWord=" + Server.UrlEncode(txtKeyword.Text.Trim());
        }
        Response.Redirect(strUrl);
    }

    /// <summary>
    /// 触发活动表的ItemCommand事件
    /// </summary>
    protected void rptCollection_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        try
        {
            if (e.CommandName == "Del")
            {
                JY.BLL.Collection bll = new JY.BLL.Collection();
                JY.Model.Collection model = bll.GetModel(Convert.ToInt32(e.CommandArgument.ToString()));
                model.IsDelete = true;

                bll.Update(model);
            }
            this.BindData();
        }
        catch (Exception er)
        {
            publicHandle.ShowMessage(this, er.Message);
        }
    }
}
