﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;
using System.Text;

public partial class Collection_Update : PasePage
{
    JY.BLL.Collection bll = new JY.BLL.Collection();
    JY.Model.Collection model = new JY.Model.Collection();
    JY.BLL.ComDataList combll = new ComDataList();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            initCollection();
        }
    }

    /// <summary>
    /// 绑定数据
    /// </summary>
    protected void initCollection()
    {
        if (Request.QueryString["id"] != null && Request.QueryString["id"] != "")
        {
            JY.BLL.Collection bll = new JY.BLL.Collection();
            JY.Model.Collection model = bll.GetModel(Convert.ToInt32(Request.QueryString["id"]));

            txtProductId.Text = model.ProductId.ToString();
            txtMemberId.Text = model.MemberId.ToString();
        }
    }

    /// <summary>
    /// 提交事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void tijiao_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            model.ProductId = Convert.ToInt32(txtProductId.Text.Trim());
            model.MemberId = Convert.ToInt32(txtMemberId.Text.Trim());
            model.CollectionDate = DateTime.Now;
            model.IsDelete = false;
            
            if (bll.Update(model))
            {
                string strUrl = "Collection_Manage.aspx";
                if (Session["urlLink"] != null)
                {
                    strUrl = Session["urlLink"].ToString();
                    Session["urlLink"] = null;
                }
                publicHandle.ShowMessage(this.Page, "修改成功！", strUrl);
            }
        }
        catch (Exception ex)
        {
            publicHandle.ShowMessage(this, ex.Message);
        }
    }
 
    /// <summary>
    /// 取消事件
    /// </summary>
    public void btnReturn_Click(object sender, EventArgs e)
    {
        Response.Redirect("Collection_Manage.aspx");
    }
}