﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;

public partial class InformationType_Add : PasePage
{
    JY.BLL.ComDataList combll = new JY.BLL.ComDataList();
    JY.BLL.InformationType bll = new JY.BLL.InformationType();
    JY.Model.InformationType model = new JY.Model.InformationType();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.txtSort.Attributes["number_type"] = "int";

            bing_dd_type();
        }
    }

    /// <summary>
    /// 一级菜单下拉框
    /// </summary>
    protected void bing_dd_type()
    {
        try
        {
            ddlFidType.Items.Clear();
            DataTable dt = new DataTable();
            if (Request.QueryString["fatherId"] == null || Request.QueryString["fatherId"] == "" || Request.QueryString["fatherId"] == "0")
            {
                ddlFidType.Items.Add(new ListItem("一级父类", "0,-1"));
                dt = combll.GetComList(0, " id,TypeName,Depth ", " InformationType ", " isdelete=0 and depth=0 and Fid=0 ", " Sort asc,id desc ");
            }
            else
            {
                dt = combll.GetComList(0, " id,TypeName,Depth ", " InformationType ", " isdelete=0 and id=" + Request.QueryString["fatherId"], " Sort asc,id desc ");
            }
            if (dt != null && dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    ListItem li = new ListItem();
                    li.Text = "╋" + dt.Rows[i]["TypeName"].ToString();
                    li.Value = dt.Rows[i]["id"].ToString() + "," + dt.Rows[i]["Depth"].ToString();
                    ddlFidType.Items.Add(li);
                    BindChild(dt.Rows[i]["id"].ToString(), Convert.ToInt32(dt.Rows[i]["Depth"].ToString()) + 1);
                }
            }
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    /// <summary>
    /// 绑定子下拉框
    /// </summary>
    protected void BindChild(string fatherid, int depth)
    {
        try
        {
            DataTable dt = combll.GetComList(0, " id,TypeName,Depth ", " InformationType ", " isdelete=0 and Depth=" + depth + " and Fid=" + fatherid + " ", " Sort asc,id desc ");
            if (dt != null && dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    string separator = "├──";
                    if (depth > 1)
                    {
                        for (int j = 2; j <= depth; j++)
                        {
                            separator += "──";
                        }
                    }
                    ListItem li = new ListItem();
                    li.Text = separator + dt.Rows[i]["TypeName"].ToString();
                    li.Value = dt.Rows[i]["id"].ToString() + "," + dt.Rows[i]["Depth"].ToString();
                    ddlFidType.Items.Add(li);
                    BindChild(dt.Rows[i]["id"].ToString(), Convert.ToInt32(dt.Rows[i]["Depth"].ToString()) + 1);
                }
            }
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    /// <summary>
    /// 提交事件
    /// </summary>
    protected void tijiao_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            model.TypeName = txtInformationTypeName.Text.Trim();
            model.Sort = Convert.ToInt32(txtSort.Text.Trim());
            model.Fid = Convert.ToInt32(this.ddlFidType.SelectedValue.Split(new char[] { ',' })[0]);
            model.Depth = Convert.ToInt32(this.ddlFidType.SelectedValue.Split(new char[] { ',' })[1]) + 1;
            model.IsDelete = false;
            model.CreateDate = DateTime.Now;
            if (bll.Add(model) > 0)
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，资讯类型添加成功！", "InformationType_Manage.aspx");
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "对不起，资讯类型添加失败！", "InformationType_Manage.aspx");
            }
        }
        catch (Exception ex)
        {
            publicHandle.ShowMessage(this, ex.Message);
        }
    }

    /// <summary>
    /// 取消事件
    /// </summary>
    public void btnReturn_Click(object sender, EventArgs e)
    {
        Response.Redirect("InformationType_Manage.aspx");
    }
}
