﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;

public partial class InformationType_Update : PasePage
{
    JY.BLL.ComDataList combll = new JY.BLL.ComDataList();
    JY.BLL.InformationType bll = new JY.BLL.InformationType();
    JY.Model.InformationType model = new JY.Model.InformationType();
    string Ids = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            bing_dd_type();
            bindDate();
        }
    }

    /// <summary>
    /// 绑定数据
    /// </summary>
    protected void bindDate()
    {
        model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
        this.txtInformationTypeName.Text = model.TypeName;
        this.txtSort.Text = model.Sort.ToString();
        this.ddlFidType.SelectedValue = model.Fid.ToString() + "," + (model.Depth - 1).ToString();
    }

    /// <summary>
    /// 一级菜单下拉框
    /// </summary>
    protected void bing_dd_type()
    {
        try
        {
            ddlFidType.Items.Clear();
            DataTable dt = new DataTable();
            if (Request.QueryString["fatherId"] == null || Request.QueryString["fatherId"] == "" || Request.QueryString["fatherId"] == "0")
            {
                ddlFidType.Items.Add(new ListItem("一级父类", "0,-1"));
                dt = combll.GetComList(0, " id,TypeName,Depth ", " InformationType ", " isdelete=0 and depth=0 and Fid=0 ", " Sort asc,id desc ");
            }
            else
            {
                dt = combll.GetComList(0, " id,TypeName,Depth ", " InformationType ", " isdelete=0 and id=" + Request.QueryString["fatherId"], " Sort asc,id desc ");
            }

            //ddlFidType.Items.Add(new ListItem("一级父类", "0,-1"));
            //DataTable dt = combll.GetComList(0, " id,TypeName,Depth ", " InformationType ", " isdelete=0 and depth=0 and Fid=0 ", " sort asc,id asc ");
            if (dt != null && dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    ListItem li = new ListItem();
                    li.Text = "╋" + dt.Rows[i]["TypeName"].ToString();
                    li.Value = dt.Rows[i]["id"].ToString() + "," + dt.Rows[i]["Depth"].ToString();
                    ddlFidType.Items.Add(li);
                    BindChild(dt.Rows[i]["id"].ToString(), Convert.ToInt32(dt.Rows[i]["Depth"].ToString()) + 1);
                }
            }
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }


    /// <summary>
    /// 绑定子下拉框
    /// </summary>
    /// <param name="fatherid"></param>
    /// <param name="depth"></param>
    protected void BindChild(string fatherid, int depth)
    {
        try
        {
            DataTable dt = combll.GetComList(0, " id,TypeName,Depth ", " InformationType ", " isdelete=0 and Depth=" + depth + " and Fid=" + fatherid + " ", " sort asc,id desc ");
            if (dt != null && dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    string separator = "├──";
                    if (depth > 1)
                    {
                        for (int j = 2; j <= depth; j++)
                        {
                            separator += "──";
                        }
                    }
                    ListItem li = new ListItem();
                    li.Text = separator + dt.Rows[i]["TypeName"].ToString();
                    li.Value = dt.Rows[i]["id"].ToString() + "," + dt.Rows[i]["Depth"].ToString();
                    ddlFidType.Items.Add(li);
                    BindChild(dt.Rows[i]["id"].ToString(), Convert.ToInt32(dt.Rows[i]["Depth"].ToString()) + 1);
                }
            }
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    /// <summary>
    /// 获取Ids
    /// </summary>
    /// <param name="fid"></param>
    private void getIds(string fid)
    {
        DataTable dt11 = combll.GetComList(0, " id", "InformationType", "Fid=" + fid, "");
        if (dt11.Rows.Count > 0)
        {
            for (int i = 0; i < dt11.Rows.Count; i++)
            {
                Ids += dt11.Rows[i][0].ToString() + ",";
                getIds(dt11.Rows[i][0].ToString());
            }
        }
    }

    /// <summary>
    /// 提交事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void tijiao_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
            getIds(model.ID.ToString());
            if (Array.IndexOf((Ids + model.ID.ToString()).Split(new char[] { ',' }), this.ddlFidType.SelectedValue.Split(new char[] { ',' })[0]) >= 0)
            {
                Response.Write("<script type='text/javascript'>alert('父节类型不能是自身或者自身的子类型！')</script>");
            }
            else
            {
                model.TypeName = txtInformationTypeName.Text.Trim();
                model.Sort = Convert.ToInt32(txtSort.Text.Trim());
                model.Fid = Convert.ToInt32(this.ddlFidType.SelectedValue.Split(new char[] { ',' })[0]);
                model.Depth = Convert.ToInt32(this.ddlFidType.SelectedValue.Split(new char[] { ',' })[1]) + 1;
                string strUrl = "InformationType_Manage.aspx";
                if (Request.QueryString["fatherId"] != null && Request.QueryString["fatherId"] != "")
                {
                    strUrl += "?fatherId=" + Request.QueryString["fatherId"];
                }
                if (bll.Update(model))
                {
                    publicHandle.ShowMessage(this.Page, "修改成功！", strUrl);
                }
            }
        }
        catch (Exception ex)
        {
            publicHandle.ShowMessage(this, ex.Message);
        }
    }

    /// <summary>
    /// 取消事件
    /// </summary>
    public void btnReturn_Click(object sender, EventArgs e)
    {
        Response.Redirect("InformationType_Manage.aspx");
    }
}
