﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;
using System.Text;

public partial class Information_Update : PasePage
{
    JY.BLL.Information bll = new JY.BLL.Information();
    JY.Model.Information model = new JY.Model.Information();
    JY.BLL.ComDataList combll = new ComDataList();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.txtSort.Attributes["number_type"] = "int";
            bing_dd_type();
            initInformation();
        }
    }

    /// <summary>
    /// 一级菜单下拉框
    /// </summary>
    protected void bing_dd_type()
    {
        try
        {
            ddlInformationType.Items.Clear();
            DataTable dt = new DataTable();
            if (Request.QueryString["TypeId"] == null || Request.QueryString["TypeId"] == "" || Request.QueryString["TypeId"] == "0")
            {
                //ddlAdType.Items.Add(new ListItem("一级父类", "0,-1"));
                dt = combll.GetComList(0, " id,TypeName,Depth ", " InformationType ", " isdelete=0 and depth=0 and Fid=0 ", " Sort asc,id desc ");
            }
            else
            {
                dt = combll.GetComList(0, " id,TypeName,Depth ", " InformationType ", " isdelete=0 and id=" + Request.QueryString["TypeId"], " Sort asc,id desc ");
            }
            if (dt != null && dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    ListItem li = new ListItem();
                    li.Text = "╋" + dt.Rows[i]["TypeName"].ToString();
                    li.Value = dt.Rows[i]["id"].ToString() + "," + dt.Rows[i]["Depth"].ToString();
                    ddlInformationType.Items.Add(li);
                    BindChild(dt.Rows[i]["id"].ToString(), Convert.ToInt32(dt.Rows[i]["Depth"].ToString()) + 1);
                }
            }
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    /// <summary>
    /// 绑定子下拉框
    /// </summary>
    protected void BindChild(string fatherid, int depth)
    {
        try
        {
            DataTable dt = combll.GetComList(0, " id,TypeName,Depth ", " InformationType ", " isdelete=0 and Depth=" + depth + " and Fid=" + fatherid + " ", " Sort asc,id desc ");
            if (dt != null && dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    string separator = "├──";
                    if (depth > 1)
                    {
                        for (int j = 2; j <= depth; j++)
                        {
                            separator += "──";
                        }
                    }
                    ListItem li = new ListItem();
                    li.Text = separator + dt.Rows[i]["TypeName"].ToString();
                    li.Value = dt.Rows[i]["id"].ToString() + "," + dt.Rows[i]["Depth"].ToString();
                    ddlInformationType.Items.Add(li);
                    BindChild(dt.Rows[i]["id"].ToString(), Convert.ToInt32(dt.Rows[i]["Depth"].ToString()) + 1);
                }
            }
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    /// <summary>
    /// 绑定数据
    /// </summary>
    protected void initInformation()
    {
        model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
        JY.BLL.InformationType ptbll = new JY.BLL.InformationType();
        JY.Model.InformationType ptmodel = new JY.Model.InformationType();
        ptmodel = ptbll.GetModel(Convert.ToInt64(model.InformationTypeId.ToString()));
        this.txtInformationName.Text = model.InformationName;
        this.ddlInformationType.SelectedValue = ptmodel.ID.ToString() + "," + ptmodel.Depth.ToString();
        this.hid.Value = model.InformationPic;
        this.txtInformationContent.Value = model.InformationContent;
        this.txtDescription.Value = model.Description.ToString();
        this.txtSort.Text = model.Sort.ToString();
    }

    /// <summary>
    /// 保存图片
    /// </summary>
    public void btnUpPic_Click(object sender, EventArgs e)
    {

        if (file1.PostedFile != null)
        {
            if (file1.PostedFile.ContentLength > 2097152)
            {
                publicHandle.ShowMessage(this.Page, "提示：图片不能大于2M！");
                return;
            }
            else
            {
                hid.Value = upPhoto(file1);
                Response.Write("<script>alert('上传成功！');</script>");
            }
        }
    }

    /// <summary>
    /// 返回文件名称
    /// </summary>
    protected string upPhoto(FileUpload file)
    {
        if (file.PostedFile != null)
        {
            if (file.PostedFile.ContentLength > 2097152)
            {
                publicHandle.ShowMessage(this.Page, "提示：图片不能大于2M！");
                return "";
            }
            else
            {
                string filename;//文件名字
                string hz;
                string newname;
                filename = file.FileName;
                //取后缀
                int pos = filename.IndexOf(".");
                hz = filename.Substring((pos + 1)).ToLower();
                //newname = System.Guid.NewGuid().ToString("N") + "." + hz;
                newname = sjname() + "." + hz;
                //保存图片
                string pathurl;
                pathurl = Server.MapPath("~") + "\\Admin\\Upfile\\" + newname;
                string kb = file1.FileContent.Length.ToString();
                file.PostedFile.SaveAs(pathurl);
                return newname;
            }
        }
        else
        {
            return "";
        }
    }

    /// <summary>
    /// 产生一个随机名称，以免图片名重复时将覆盖文件原有文件
    /// </summary>
    public string sjname()
    {
        string sj = null;
        sj = DateTime.Now.Year.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Day.ToString() + DateTime.Now.TimeOfDay.Hours.ToString() + DateTime.Now.TimeOfDay.Minutes.ToString() + DateTime.Now.TimeOfDay.Milliseconds.ToString();
        return sj;
    }

    /// <summary>
    /// 提交事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void tijiao_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
            model.InformationName = this.txtInformationName.Text.Trim();
            model.InformationTypeId = Convert.ToInt32(this.ddlInformationType.SelectedValue.Split(new char[] { ',' })[0]);
            model.InformationPic = this.hid.Value;
            model.InformationContent = txtInformationContent.Value;
            model.Description = this.txtDescription.Value;
            model.Sort = Convert.ToInt32(this.txtSort.Text.Trim());
            model.CreateDate = Convert.ToDateTime(DateTime.Now.ToString());
            model.IsDelete = false;
            if (bll.Update(model))
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，资讯修改成功！", "Information_Manage.aspx");
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "对不起，资讯修改失败！", "Information_Manage.aspx");
            }
        }
        catch (Exception ex)
        {
            publicHandle.ShowMessage(this, ex.Message);
        }
    }

    /// <summary>
    /// 取消事件
    /// </summary>
    public void btnReturn_Click(object sender, EventArgs e)
    {
        Response.Redirect("Information_Manage.aspx");
    }
}