﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;
using System.Text;

public partial class Member_Add : PasePage
{
    JY.BLL.Member bll = new JY.BLL.Member();
    JY.Model.Member model = new JY.Model.Member();
    JY.BLL.ComDataList combll = new ComDataList();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            bindDdlMemberRank();
        }
    }

    /// <summary>
    /// 绑定下拉框
    /// </summary>
    private void bindDdlMemberRank()
    {
        JY.BLL.MemberRank bll = new JY.BLL.MemberRank();
        ddlMemberRank.DataSource = bll.GetList(" isdelete=0 ").Tables[0];
        ddlMemberRank.DataTextField = "MemberRankName";
        ddlMemberRank.DataValueField = "id";
        ddlMemberRank.DataBind();
    }

    /// <summary>
    /// 提交事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void tijiao_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            JY.BLL.Member brandbll = new JY.BLL.Member();
            JY.Model.Member brandmodel = new JY.Model.Member();

            model.MemberName = this.txtMemberName.Text.Trim();
            model.MemberRankId = Convert.ToInt32(this.ddlMemberRank.SelectedValue.Split(new char[] { ',' })[0]);
            model.Password = this.txtPassword.Text.Trim();
            model.Email = this.txtEmail.Text.Trim();
            model.Phone = this.txtPhone.Text.Trim();
            model.QQ = this.txtQQ.Text.Trim();
            model.Address = this.txtAddress.Text.Trim();
            model.CreateDate = Convert.ToDateTime(DateTime.Now.ToString());
            model.IsDelete = false;
            if (bll.Add(model) > 0)
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，会员信息添加成功！", "Member_Manage.aspx");
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "对不起，会员信息添加失败！");
            }
        }
        catch (Exception er)
        {
            publicHandle.ShowMessage(this, er.Message);
        }
    }

    /// <summary>
    /// 取消事件
    /// </summary>
    public void btnReturn_Click(object sender, EventArgs e)
    {
        Response.Redirect("Member_Manage.aspx");
    }
}

