﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;

public partial class Member_Manage : PasePage
{
    JY.BLL.Member bll = new JY.BLL.Member();
    JY.Model.Member model = new JY.Model.Member();
    JY.BLL.ComDataList combll = new JY.BLL.ComDataList();
    protected Dictionary<string, string> dicFunctionList = new Dictionary<string, string>();
    string Ids = "";
    string[] numstr = { "Page", "page", "membername", "memberrankId", "Ids" };
    protected void Page_Load(object sender, EventArgs e)
    {
        dicFunctionList.Add("添加", "false");
        dicFunctionList.Add("修改", "false");
        dicFunctionList.Add("删除", "false");
        string url = Request.Url.ToString();
        if (url.IndexOf("adminsys") > -1)
        {
            url = url.Replace("adminsys", "Adminsys");
        }
        url = url.Substring(url.IndexOf("Adminsys") + 9);
        url = GetSubStr(numstr, url);
        if (!IsPostBack)
        {
            if (Request.QueryString["DeID"] != null)
            {
                //得到需要删除的记录的编号（Id）
                clear();
            }
            else
            {
                Session["urlLink"] = Request.RawUrl;
            }
            bing_dd_type();
            BindDate();
        }
    }

    /// <summary>
    /// 绑定数据
    /// </summary>
    protected void BindDate()
    {
        try
        {
            int pageIndex = GetInt(Request.QueryString["Page"], 1);
            Pagination.Pagination _page = new Pagination.Pagination();

            _page.ItemUnit = "个号码";
            _page.ImagesPath = "../Images/ui_form/";
            _page.Sequence = pageIndex;
            _page.PageSize = pager.PageSize;
            _page.TableName = " Member ";
            _page.SearchField = " * ";
            if (Request.QueryString["memberrankId"] != null && Request.QueryString["memberrankId"] != "")
            {
                _page.SearchSentence = " and Member.IsDelete=0 ";
            }
            else
            {
                if (Request.QueryString["TypeId"] != null && Request.QueryString["TypeId"] != "")
                {
                    getIds(Request.QueryString["TypeId"]);
                    _page.SearchSentence = " and Member.IsDelete=0 and ProductTypeId in(" + Ids + Request.QueryString["TypeId"] + ")";
                }
                else
                {
                    _page.SearchSentence = " and Member.IsDelete=0 ";
                }
            }

            #region 按查询条件查询数据
            if (Request.QueryString["membername"] != null && Request.QueryString["membername"] != "")
            {
                this.txtMemberName.Text = Request.QueryString["membername"].ToString();
                _page.SearchSentence += " and membername like '%" + Request.QueryString["membername"] + "%'";
            }
            if (Request.QueryString["memberrankId"] != null && Request.QueryString["memberrankId"] != "")
            {
                this.ddlMemberRank.SelectedValue = Request.QueryString["memberrankId"].ToString();
                string aa = Request.QueryString["Ids"];
                _page.SearchSentence += " and ProductTypeId in(" + Request.QueryString["Ids"] + Request.QueryString["memberrankId"].Split(new char[] { ',' })[0] + ")";
            }

            #endregion

            _page.SortSentence = " order by Member.ID desc ";
            _page.Primarykey = " Member.id ";
            DataTable dt = _page.GetDataTable();

            rptMember.DataSource = dt;
            rptMember.DataBind();

            pager.RecordCount = _page.RecordCount;
            //显示记录信息   [ 共1508条 第1页 共151页 ]
            pager.CustomInfoHTML = "【 共<b>" + pager.RecordCount.ToString() + "</b> 条&nbsp;";
            pager.CustomInfoHTML += " 当前第<font color=\"red\"><b>" + pageIndex.ToString() + "</b></font>页&nbsp;";
            pager.CustomInfoHTML += " 共<b>" + pager.PageCount.ToString() + "</b>页 】&nbsp;&nbsp;";

            trRecord.Visible = _page.RecordCount / _page.PageSize > 0;
            btndel.Visible = _page.RecordCount > 0;
            data_page_div.Visible = _page.RecordCount > 0;
        }
        catch (Exception ex)
        {
            publicHandle.ShowMessage(this, ex.Message);
        }
    }

    /// <summary>
    /// 删除
    /// </summary>
    protected void clear()
    {
        try
        {
            long ID = Convert.ToInt64(Request.QueryString["DeID"].ToString());
            JY.BLL.Member bll1 = new JY.BLL.Member();
            if (bll.Delete(ID))
            {
                string strUrl = "Member_Manage.aspx";
                if (Session["urlLink"] != null)
                {
                    strUrl = Session["urlLink"].ToString();
                    Session["urlLink"] = null;
                }
                publicHandle.ShowMessage(this.Page, "删除成功！", strUrl);
            }
        }
        catch (Exception ex)
        {
            publicHandle.ShowMessage(this, ex.Message);
        }
    }

    /// <summary>
    /// 获取会员等级名称
    /// </summary>
    protected string getMemberRankName(string typeId)
    {
        JY.BLL.MemberRank mrbll = new JY.BLL.MemberRank();
        JY.Model.MemberRank mrmodel = new JY.Model.MemberRank();
        if (typeId != "0" && typeId != null && typeId != "")
        {
            mrmodel = mrbll.GetModel(Convert.ToInt64(typeId));
            if (mrmodel != null)
            {
                return mrmodel.MemberRankName;
            }
            else 
            {
                return "";
            }
        }
        else
        {
            return "";
        }
    }

    /// <summary>
    /// 一级菜单下拉框
    /// </summary>
    protected void bing_dd_type()
    {
        try
        {
            ddlMemberRank.Items.Clear();
            DataTable dt = new DataTable();
            if (Request.QueryString["TypeId"] == null || Request.QueryString["TypeId"] == "" || Request.QueryString["TypeId"] == "0")
            {
                ddlMemberRank.Items.Add(new ListItem("所有会员等级", "0,-1"));
                dt = combll.GetComList(0, " id,MemberRankName,Depth ", " MemberRank ", " isdelete=0 and depth=0 and Fid=0 ", " Sort asc,id desc ");
            }
            else
            {
                dt = combll.GetComList(0, " id,MemberRankName,Depth ", " MemberRank ", " isdelete=0 and id=" + Request.QueryString["TypeId"], " Sort asc,id desc ");
            }
            if (dt != null && dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    ListItem li = new ListItem();
                    li.Text = "╋" + dt.Rows[i]["MemberRankName"].ToString();
                    li.Value = dt.Rows[i]["id"].ToString() + "," + dt.Rows[i]["Depth"].ToString();
                    ddlMemberRank.Items.Add(li);
                    BindChild(dt.Rows[i]["id"].ToString(), Convert.ToInt32(dt.Rows[i]["Depth"].ToString()) + 1);
                }
            }
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    /// <summary>
    /// 绑定子下拉框
    /// </summary>
    /// <param name="fatherid"></param>
    /// <param name="depth"></param>
    protected void BindChild(string fatherid, int depth)
    {
        try
        {
            DataTable dt = combll.GetComList(0, " id,MemberRankName,Depth ", " MemberRank ", " isdelete=0 and Depth=" + depth + " and Fid=" + fatherid + " ", " Sort asc,id desc ");
            if (dt != null && dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    string separator = "├──";
                    if (depth > 1)
                    {
                        for (int j = 2; j <= depth; j++)
                        {
                            separator += "──";
                        }
                    }
                    ListItem li = new ListItem();
                    li.Text = separator + dt.Rows[i]["MemberRankName"].ToString();
                    li.Value = dt.Rows[i]["id"].ToString() + "," + dt.Rows[i]["Depth"].ToString();
                    ddlMemberRank.Items.Add(li);
                    BindChild(dt.Rows[i]["id"].ToString(), Convert.ToInt32(dt.Rows[i]["Depth"].ToString()) + 1);
                }
            }
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    /// <summary>
    /// 查询
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnquery_Click(object sender, EventArgs e)
    {
        string url = Request.Url.ToString();
        url = url.Substring(url.LastIndexOf('/') + 1);
        url = GetSubStr(numstr, url);
        string membername = this.txtMemberName.Text.Trim();
        string memberrankId = this.ddlMemberRank.SelectedValue;
        getIds(this.ddlMemberRank.SelectedValue.Split(new char[] { ',' })[0]);
        if (url.IndexOf('?') > -1)
        {
            Response.Redirect(url + "&membername=" + membername + "&memberrankId=" + memberrankId + "&Ids=" + Ids);
        }
        else
        {
            Response.Redirect(url + "?membername=" + membername + "&memberrankId=" + memberrankId + "&Ids=" + Ids);
        }
    }

    /// <summary>
    /// 获取Ids
    /// </summary>
    /// <param name="fid"></param>
    private void getIds(string fid)
    {
        DataTable dt11 = combll.GetComList(0, " id", "MemberRank", "Fid=" + fid, "");
        if (dt11.Rows.Count > 0)
        {
            for (int i = 0; i < dt11.Rows.Count; i++)
            {
                Ids += dt11.Rows[i][0].ToString() + ",";
                getIds(dt11.Rows[i][0].ToString());
            }
        }
    }

    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btndel_Click(object sender, EventArgs e)
    {
        try
        {
            if (hidBatchDelId.Value.Trim() != "")
            {
                if (bll.DeleteList(hidBatchDelId.Value))
                {
                    //Response.Write("<script type='text/javascript'>alert('批量删除成功！')</script>");
                    //BindDate();
                    string strUrl = "Member_Manage.aspx";
                    if (Session["urlLink"] != null)
                    {
                        strUrl = Session["urlLink"].ToString();
                        Session["urlLink"] = null;
                    }
                    publicHandle.ShowMessage(this.Page, "批量删除成功", strUrl);
                }
                else
                {
                    publicHandle.ShowMessage(this.Page, "批量删除失败！");
                }
            }
        }
        catch (Exception ex)
        {
            publicHandle.ShowMessage(this, ex.Message);
        }
    }

    /// <summary>
    /// 触发活动表的ItemCommand事件
    /// </summary>
    protected void rptMember_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        try
        {
            if (e.CommandName == "Del")
            {
                JY.BLL.Member bll = new JY.BLL.Member();
                JY.Model.Member model = bll.GetModel(Convert.ToInt32(e.CommandArgument.ToString()));
                model.IsDelete = true;

                bll.Update(model);
            }
            this.BindDate();
        }
        catch (Exception er)
        {
            publicHandle.ShowMessage(this, er.Message);
        }
    }
}
