﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;
using System.Text;

public partial class Member_Update : PasePage
{
    JY.BLL.Member bll = new JY.BLL.Member();
    JY.Model.Member model = new JY.Model.Member();
    JY.BLL.ComDataList combll = new ComDataList();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            bindDdlMemberRank();
            initMember();            
        }
    }

    /// <summary>
    /// 绑定下拉框
    /// </summary>
    private void bindDdlMemberRank()
    {
        JY.BLL.MemberRank bll = new JY.BLL.MemberRank();
        ddlMemberRank.DataSource = bll.GetList(" isdelete=0 ").Tables[0];
        ddlMemberRank.DataTextField = "MemberRankName";
        ddlMemberRank.DataValueField = "id";
        ddlMemberRank.DataBind();
    }

    /// <summary>
    /// 绑定数据
    /// </summary>
    protected void initMember()
    {
        model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
        JY.BLL.MemberRank mrbll = new JY.BLL.MemberRank();
        JY.Model.MemberRank mrmodel = new JY.Model.MemberRank();
        mrmodel = mrbll.GetModel(Convert.ToInt64(model.MemberRankId.ToString()));
        this.ddlMemberRank.SelectedValue = mrmodel.ID.ToString() + "," + mrmodel.Depth.ToString();
        this.txtMemberName.Text = model.MemberName;
        this.txtPassword.Text = model.Password;
        this.txtEmail.Text = model.Email;
        this.txtPhone.Text = model.Phone;
        this.txtQQ.Text = model.QQ;
        this.txtAddress.Text = model.Address;
    }

    /// <summary>
    /// 提交事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void tijiao_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
            model.MemberName = this.txtMemberName.Text.Trim();
            model.MemberRankId = Convert.ToInt32(this.ddlMemberRank.SelectedValue.Split(new char[] { ',' })[0]);
            model.Password = this.txtPassword.Text.Trim();
            model.Email = this.txtEmail.Text.Trim();
            model.Phone = this.txtPhone.Text.Trim();
            model.QQ = this.txtQQ.Text.Trim();
            model.Address = this.txtAddress.Text.Trim();
            model.CreateDate = Convert.ToDateTime(DateTime.Now.ToString());
            model.IsDelete = false;
            
            if (bll.Update(model))
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，会员信息修改成功！", "Member_Manage.aspx");
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "对不起，会员信息修改失败！");
            }
        }
        catch (Exception ex)
        {
            publicHandle.ShowMessage(this, ex.Message);
        }
    }
 
    /// <summary>
    /// 取消事件
    /// </summary>
    public void btnReturn_Click(object sender, EventArgs e)
    {
        Response.Redirect("Member_Manage.aspx");
    }
}