﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;
using System.Text;

public partial class OrderForm_Add : PasePage
{
    JY.BLL.OrderForm bll = new JY.BLL.OrderForm();
    JY.Model.OrderForm model = new JY.Model.OrderForm();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
        }
    }

    /// <summary>
    /// 提交事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void tijiao_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            model.OrderFormNo = txtOrderFormNo.Text.Trim();
            model.ProductTotalPrice = Convert.ToDecimal(txtProductTotalPrice.Text.Trim());
            model.Purchaser = txtPurchaser.Text.Trim();
            model.Consignee = txtConsignee.Text.Trim();
            model.LiveAddress = txtLiveAddress.Text.Trim();
            model.ZipCode = txtZipCode.Text.Trim();
            model.Phone = txtPhone.Text.Trim();
            model.Remark = txtRemark.Text.Trim();
            model.CreatDate = DateTime.Now;
            model.IsDelete = false;
            
            if (bll.Add(model) > 0)
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，订单添加成功！", "OrderForm_Manage.aspx");
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "对不起，订单添加失败！", "OrderForm_Manage.aspx");
            }
        }
        catch (Exception er)
        {
            publicHandle.ShowMessage(this, er.Message);
        }
    }

    /// <summary>
    /// 取消事件
    /// </summary>
    public void btnReturn_Click(object sender, EventArgs e)
    {
        Response.Redirect("OrderForm_Manage.aspx.aspx");
    }
}

