﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;
using System.Text;

public partial class OrderForm_Update : PasePage
{
    JY.BLL.OrderForm bll = new JY.BLL.OrderForm();
    JY.Model.OrderForm model = new JY.Model.OrderForm();
    JY.BLL.ComDataList combll = new ComDataList();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            bindOrderForm();
        }
    }

    /// <summary>
    /// 绑定数据
    /// </summary>
    protected void bindOrderForm()
    {
        model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
        lblOrderFormNo.Text = model.OrderFormNo;
        txtPurchaser.Text = model.Purchaser;
        txtConsignee.Text = model.Consignee;
        txtLiveAddress.Text = model.LiveAddress;
        txtZipCode.Text = model.ZipCode;
        txtPhone.Text = model.Phone;
        txtProductTotalPrice.Text = model.ProductTotalPrice.ToString();
        txtRemark.Text = model.Remark;

        bindOrderFormDetail(model.ID);
    }

    /// <summary>
    /// 提交事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void tijiao_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
            model.Purchaser = txtPurchaser.Text.Trim();
            model.Consignee = txtConsignee.Text.Trim();
            model.LiveAddress = txtLiveAddress.Text.Trim();
            model.ZipCode = txtZipCode.Text.Trim();
            model.Phone = txtPhone.Text.Trim();
            model.ProductTotalPrice = Convert.ToDecimal(txtProductTotalPrice.Text.Trim());
            model.Remark = txtRemark.Text.Trim();
            if (bll.Update(model))
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，订单信息修改成功！", "OrderForm_Manage.aspx");
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "对不起，订单信息修改失败！");
            }
        }
        catch (Exception ex)
        {
            publicHandle.ShowMessage(this, ex.Message);
        }
    }

    /// <summary>
    /// 绑定订单明细
    /// </summary>
    /// <param name="OrderFormID"></param>
    private void bindOrderFormDetail(long OrderFormID)
    {
        JY.BLL.OrderFormDetail bll = new JY.BLL.OrderFormDetail();

        rptOrderFormDetail.DataSource = bll.GetList(" IsDelete=0  and OrderFormID="+ Request.QueryString["ID"] + " order by id desc ");
        rptOrderFormDetail.DataBind();
    }

    /// <summary>
    /// 获取图片
    /// </summary>
    /// <param name="productID"></param>
    /// <returns></returns>
    protected string getProductPic(long productID)
    {
        JY.BLL.Product bll = new JY.BLL.Product();
        JY.Model.Product model = bll.GetModel(productID);

        return model.ProductPic;
    }
}