﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;
using System.Text;

public partial class Product_Update : PasePage
{
    JY.BLL.Product bll = new JY.BLL.Product();
    JY.Model.Product model = new JY.Model.Product();
    JY.BLL.ComDataList combll = new ComDataList();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.txtSort.Attributes["number_type"] = "int";
            bing_dd_type();
            bindddlBrand();
            initProduct();
        }
    }

    /// <summary>
    /// 一级菜单下拉框
    /// </summary>
    protected void bing_dd_type()
    {
        try
        {
            ddlProductType.Items.Clear();
            DataTable dt = new DataTable();
            if (Request.QueryString["TypeId"] == null || Request.QueryString["TypeId"] == "" || Request.QueryString["TypeId"] == "0")
            {
                //ddlAdType.Items.Add(new ListItem("一级父类", "0,-1"));
                dt = combll.GetComList(0, " id,TypeName,Depth ", " ProductType ", " isdelete=0 and depth=0 and Fid=0 ", " Sort asc,id desc ");
            }
            else
            {
                dt = combll.GetComList(0, " id,TypeName,Depth ", " ProductType ", " isdelete=0 and id=" + Request.QueryString["TypeId"], " Sort asc,id desc ");
            }
            if (dt != null && dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    ListItem li = new ListItem();
                    li.Text = "╋" + dt.Rows[i]["TypeName"].ToString();
                    li.Value = dt.Rows[i]["id"].ToString() + "," + dt.Rows[i]["Depth"].ToString();
                    ddlProductType.Items.Add(li);
                    BindChild(dt.Rows[i]["id"].ToString(), Convert.ToInt32(dt.Rows[i]["Depth"].ToString()) + 1);
                }
            }
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    /// <summary>
    /// 帮顶子下拉框
    /// </summary>
    /// <param name="fatherid"></param>
    /// <param name="depth"></param>
    protected void BindChild(string fatherid, int depth)
    {
        try
        {
            DataTable dt = combll.GetComList(0, " id,TypeName,Depth ", " ProductType ", " isdelete=0 and Depth=" + depth + " and Fid=" + fatherid + " ", " Sort asc,id desc ");
            if (dt != null && dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    string separator = "├──";
                    if (depth > 1)
                    {
                        for (int j = 2; j <= depth; j++)
                        {
                            separator += "──";
                        }
                    }
                    ListItem li = new ListItem();
                    li.Text = separator + dt.Rows[i]["TypeName"].ToString();
                    li.Value = dt.Rows[i]["id"].ToString() + "," + dt.Rows[i]["Depth"].ToString();
                    ddlProductType.Items.Add(li);
                    BindChild(dt.Rows[i]["id"].ToString(), Convert.ToInt32(dt.Rows[i]["Depth"].ToString()) + 1);
                }
            }
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    /// <summary>
    /// 绑定数据
    /// </summary>
    protected void initProduct()
    {
        model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
        JY.BLL.ProductType ptbll = new JY.BLL.ProductType();
        JY.Model.ProductType ptmodel = new JY.Model.ProductType();
        JY.BLL.Brand brbll = new JY.BLL.Brand();
        JY.Model.Brand brmodel = new JY.Model.Brand();
        ptmodel = ptbll.GetModel(Convert.ToInt32(model.ProductTypeId.ToString()));
        this.ddlProductType.SelectedValue = ptmodel.ID.ToString() + "," + ptmodel.Depth.ToString();
        this.txtProductName.Text = model.ProductName;
        this.hid.Value = model.ProductPic;
        this.txtDescription.Value = model.Description.ToString();

        this.ddlBrand.SelectedValue = brmodel.ID.ToString();
        this.txtSort.Text = model.Sort.ToString();
        this.txtSpec.Text = model.Spec;
        this.txtMarketPrice.Text = model.MarketPrice.ToString();
        this.txtWebsitePrice.Text = model.WebsitePrice.ToString();
    }

    /// <summary>
    /// 绑定下拉框
    /// </summary>
    private void bindddlBrand()
    {
        JY.BLL.Brand bll = new JY.BLL.Brand();
        ddlBrand.DataSource = bll.GetList(" isdelete=0 ").Tables[0];
        ddlBrand.DataTextField = "BrandName";
        ddlBrand.DataValueField = "ID";
        ddlBrand.DataBind();
    }

    /// <summary>
    /// 保存图片
    /// </summary>
    public void btnUpPic_Click(object sender, EventArgs e)
    {

        if (file1.PostedFile != null)
        {
            if (file1.PostedFile.ContentLength > 2097152)
            {
                publicHandle.ShowMessage(this.Page, "提示：图片不能大于2M！");
                return;
            }
            else
            {
                hid.Value = upPhoto(file1);
                Response.Write("<script>alert('上传成功！');</script>");
            }
        }
    }

    /// <summary>
    /// 返回文件名称
    /// </summary>
    protected string upPhoto(FileUpload file)
    {
        if (file.PostedFile != null)
        {
            if (file.PostedFile.ContentLength > 2097152)
            {
                publicHandle.ShowMessage(this.Page, "提示：图片不能大于2M！");
                return "";
            }
            else
            {
                string filename;//文件名字
                string hz;
                string newname;
                filename = file.FileName;
                //取后缀
                int pos = filename.IndexOf(".");
                hz = filename.Substring((pos + 1)).ToLower();
                //newname = System.Guid.NewGuid().ToString("N") + "." + hz;
                newname = sjname() + "." + hz;
                //保存图片
                string pathurl;
                pathurl = Server.MapPath("~") + "\\Admin\\Upfile\\" + newname;
                string kb = file1.FileContent.Length.ToString();
                file.PostedFile.SaveAs(pathurl);
                return newname;
            }
        }
        else
        {
            return "";
        }
    }
    // 下载于www.51aspx.com
    /// <summary>
    /// 产生一个随机名称，以免图片名重复时将覆盖文件原有文件
    /// </summary>
    public string sjname()
    {
        string sj = null;
        sj = DateTime.Now.Year.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Day.ToString() + DateTime.Now.TimeOfDay.Hours.ToString() + DateTime.Now.TimeOfDay.Minutes.ToString() + DateTime.Now.TimeOfDay.Milliseconds.ToString();
        return sj;
    }

    /// <summary>
    /// 提交事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void tijiao_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
            model.ProductName = this.txtProductName.Text.Trim();
            model.ProductTypeId = Convert.ToInt32(this.ddlProductType.SelectedValue.Split(new char[] { ',' })[0]);
            model.ProductPic = this.hid.Value;
            model.Description = this.txtDescription.Value;
            model.Brand = Convert.ToInt32(ddlBrand.SelectedValue);
            model.Sort = Convert.ToInt32(this.txtSort.Text.Trim());
            model.Spec = this.txtSpec.Text.Trim();
            model.MarketPrice = Convert.ToDecimal(this.txtMarketPrice.Text.Trim());
            model.WebsitePrice = Convert.ToDecimal(this.txtWebsitePrice.Text.Trim());
            model.CreateDate = DateTime.Now;
            model.IsDelete = false;
            if (bll.Update(model))
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，商品修改成功！", "Product_Manage.aspx");
            }
            else 
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，商品修改失败！", "Product_Manage.aspx");
            }
        }
        catch (Exception ex)
        {
            publicHandle.ShowMessage(this, ex.Message);
        }
    }

    /// <summary>
    /// 取消事件
    /// </summary>
    public void btnReturn_Click(object sender, EventArgs e)
    {
        Response.Redirect("Product_Manage.aspx");
    }
}