﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;

public partial class Review_Manage : PasePage
{
    JY.BLL.Review bll = new JY.BLL.Review();
    JY.Model.Review model = new JY.Model.Review();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BindData();
        }
    }

    private int GetInt(object obj, int defaultValue)
    {
        if (obj != null)
        {
            try
            {
                defaultValue = Convert.ToInt32(obj);
            }
            catch
            {
            }
        }
        return defaultValue;
    }

    /// <summary>
    /// 获取列表数据
    /// </summary>
    private void BindData()
    {
        int pageIndex = GetInt(Request.QueryString["Page"], 1);
        Pagination.Pagination _page = new Pagination.Pagination();

        _page.ItemUnit = "个号码";
        _page.ImagesPath = "~/Images/ui_form/";
        _page.Sequence = pageIndex;
        _page.PageSize = pager.PageSize;
        _page.TableName = "  Review ";
        _page.SearchField = " * ";

        _page.SearchSentence = " and Review.Isdelete=0 ";

        if (Request.QueryString["ProductId"] != null && Request.QueryString["ProductId"] != "")
        {
            _page.SearchSentence += " and ProductId=" + Request.QueryString["ProductId"];
            txtProductId.Text = Request.QueryString["ProductId"];
        }

        if (Request.QueryString["ReviewName"] != null && Request.QueryString["ReviewName"] != "")
        {
            _page.SearchSentence += " and ReviewName=" + Request.QueryString["ReviewName"];
            txtReviewName.Text = Request.QueryString["ReviewName"];
        }

        _page.SortSentence = " Order By Review.Id desc ";
        _page.Primarykey = " Review.Id ";
        DataTable dt = _page.GetDataTable();

        rptReview.DataSource = dt;
        rptReview.DataBind();

        pager.RecordCount = _page.RecordCount;
        //显示记录信息   [ 共1508条 第1页 共151页 ]
        pager.CustomInfoHTML = "<span>共有&nbsp;<b>" + pager.RecordCount.ToString() + "</b>&nbsp;条记录，";
        pager.CustomInfoHTML += " 当前第&nbsp;<font color=\"red\"><b>" + pageIndex.ToString() + "</b></font>&nbsp;页，";
        pager.CustomInfoHTML += " 共&nbsp;<b>" + pager.PageCount.ToString() + "</b>&nbsp;页</span>";

    }

    /// <summary>
    /// 查询
    /// </summary>
    protected void btnquery_Click(object sender, EventArgs e)
    {
        string strUrl = "Review_Manage.aspx?1=1";

        if (txtProductId.Text.Trim() != "")
        {
            strUrl += "&ReviewName=" + Server.UrlEncode(txtProductId.Text.Trim());
        }
        if (txtReviewName.Text.Trim() != "")
        {
            strUrl += "&ReviewName=" + Server.UrlEncode(txtReviewName.Text.Trim());
        }
        Response.Redirect(strUrl);
    }

    /// <summary>
    /// 触发活动表的ItemCommand事件
    /// </summary>
    protected void rptReview_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        try
        {
            if (e.CommandName == "Del")
            {
                JY.BLL.Review bll = new JY.BLL.Review();
                JY.Model.Review model = bll.GetModel(Convert.ToInt32(e.CommandArgument.ToString()));
                model.IsDelete = true;

                bll.Update(model);
            }
            this.BindData();
        }
        catch (Exception er)
        {
            publicHandle.ShowMessage(this, er.Message);
        }
    }

    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btndel_Click(object sender, EventArgs e)
    {
        try
        {
            if (hidBatchDelId.Value.Trim() != "")
            {
                if (bll.DeleteList(hidBatchDelId.Value))
                {
                    //Response.Write("<script type='text/javascript'>alert('批量删除成功！')</script>");
                    //BindDate();
                    string strUrl = "Review_Manage.aspx";
                    if (Session["urlLink"] != null)
                    {
                        strUrl = Session["urlLink"].ToString();
                        Session["urlLink"] = null;
                    }
                    publicHandle.ShowMessage(this.Page, "批量删除成功", strUrl);
                }
                else
                {
                    publicHandle.ShowMessage(this.Page, "批量删除失败！");
                }
            }
        }
        catch (Exception ex)
        {
            publicHandle.ShowMessage(this, ex.Message);
        }
    }
}
