﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using JY.Model;
using JY.BLL;
using Maticsoft.DBUtility;
using System.Text;

public partial class Review_Update : PasePage
{
    JY.BLL.Review bll = new JY.BLL.Review();
    JY.Model.Review model = new JY.Model.Review();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            initReview();
        }
    }

    /// <summary>
    /// 绑定数据
    /// </summary>
    protected void initReview()
    {
        if (Request.QueryString["id"] != null && Request.QueryString["id"] != "")
        {
            JY.BLL.Review bll = new JY.BLL.Review();
            JY.Model.Review model = bll.GetModel(Convert.ToInt32(Request.QueryString["id"]));

            txtProductId.Text = model.ProductId.ToString();
            txtReviewContent.Value = model.ReviewContent;
            txtReplyContent.Value = model.ReplyContent;
            txtReviewName.Text = model.ReviewName;
        }
    }

    /// <summary>
    /// 提交事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void tijiao_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
            model.ProductId = Convert.ToInt32(txtProductId.Text.Trim());
            model.ReviewContent = txtReviewContent.Value;
            model.ReplyContent = txtReplyContent.Value;
            model.ReviewName = txtReviewName.Text.Trim();
            model.ReviewDate = DateTime.Now;
            model.IsDelete = false;
            
            if (bll.Update(model))
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，评论修改成功！", "Review_Manage.aspx");
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，评论修改失败！", "Review_Manage.aspx");
            }
        }
        catch (Exception ex)
        {
            publicHandle.ShowMessage(this, ex.Message);
        }
    }
 
    /// <summary>
    /// 取消事件
    /// </summary>
    public void btnReturn_Click(object sender, EventArgs e)
    {
        Response.Redirect("Review_Manage.aspx");
    }
}