﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class UserInfo_Add : PasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            bindddlUserType();
        }
    }

    /// <summary>
    /// 绑定下拉框
    /// </summary>
    private void bindddlUserType()
    {
        JY.BLL.UserType bll = new JY.BLL.UserType();
        ddlUserType.DataSource = bll.GetList(" isdelete=0 ").Tables[0];
        ddlUserType.DataTextField = "UserTypeName";
        ddlUserType.DataValueField = "ID";
        ddlUserType.DataBind();
    }

    /// <summary>
    /// 用户信息添加事件
    /// </summary>
    public void btnAdd_Click(object sender, EventArgs e)
    {
        JY.BLL.UserInfo bll = new JY.BLL.UserInfo();
        JY.Model.UserInfo model = new JY.Model.UserInfo();

        model.UserName = txtUserName.Text.Trim();
        model.Password = txtPassword.Text.Trim();
        model.UserType =Convert.ToInt32(ddlUserType.SelectedValue);
        model.Remark = txtRemark.Text.Trim();
        model.IsDelete = false;

        if (bll.Add(model) > 0)
        {
            publicHandle.ShowMessage(this.Page, "恭喜您，用户信息添加成功！", "UserInfo_Manage.aspx");
        }
        else
        {
            publicHandle.ShowMessage(this.Page, "对不起，用户信息添加失败！");
        }
    }
    
    /// <summary>
    /// 取消事件
    /// </summary>
    public void btnReturn_Click(object sender, EventArgs e)
    {
        Response.Redirect("UserInfo_Manage.aspx");
    }
}
