﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class UserInfo_Manage : PasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BindData();
        }
    }

    private int GetInt(object obj, int defaultValue)
    {
        if (obj != null)
        {
            try
            {
                defaultValue = Convert.ToInt32(obj);
            }
            catch
            {
            }
        }
        return defaultValue;
    }

    /// <summary>
    /// 获取列表数据
    /// </summary>
    private void BindData()
    {
        int pageIndex = GetInt(Request.QueryString["Page"], 1);
        Pagination.Pagination _page = new Pagination.Pagination();

        _page.ItemUnit = "个号码";
        _page.ImagesPath = "~/Images/ui_form/";
        _page.Sequence = pageIndex;
        _page.PageSize = pager.PageSize;
        _page.TableName = "  UserInfo ";
        _page.SearchField = " * ";

        _page.SearchSentence = " and UserInfo.Isdelete=0 ";



        _page.SortSentence = " Order By UserInfo.Id desc ";
        _page.Primarykey = " UserInfo.Id ";
        DataTable dt = _page.GetDataTable();

        rptUserInfo.DataSource = dt;
        rptUserInfo.DataBind();

        pager.RecordCount = _page.RecordCount;
        //显示记录信息   [ 共1508条 第1页 共151页 ]
        pager.CustomInfoHTML = "<span>共有&nbsp;<b>" + pager.RecordCount.ToString() + "</b>&nbsp;条记录，";
        pager.CustomInfoHTML += " 当前第&nbsp;<font color=\"red\"><b>" + pageIndex.ToString() + "</b></font>&nbsp;页，";
        pager.CustomInfoHTML += " 共&nbsp;<b>" + pager.PageCount.ToString() + "</b>&nbsp;页</span>";

    }

    /// <summary>
    /// 查询
    /// </summary>
    protected void btnquery_Click(object sender, EventArgs e)
    {
        string strUrl = "UserInfo_List.aspx?1=1";
        
        if (txtKeyword.Text.Trim() != "")
        {
            strUrl += "&keyWord=" + Server.UrlEncode(txtKeyword.Text.Trim());
        }
        Response.Redirect(strUrl);
    }

    /// <summary>
    /// 根据用户类型的ID获取用户类型的名称
    /// </summary>
    protected string getUserTypeName(int ID)
    {
        string strUserTypeName = "";
        JY.BLL.UserType bll = new JY.BLL.UserType();
        JY.Model.UserType model = bll.GetModel(ID);
        if (model != null)
        {
            strUserTypeName = model.UserTypeName;
        }
        return strUserTypeName;
    }

    /// <summary>
    /// 触发活动表的ItemCommand事件
    /// </summary>
    protected void rptUserInfo_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        try
        {
            if (e.CommandName == "Del")
            {
                JY.BLL.UserInfo bll = new JY.BLL.UserInfo();
                JY.Model.UserInfo model = bll.GetModel(Convert.ToInt32(e.CommandArgument.ToString()));
                model.IsDelete = true;

                bll.Update(model);
            }
            this.BindData();
        }
        catch (Exception er)
        {
            publicHandle.ShowMessage(this, er.Message);
        }
    }
}
