﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class UserInfo_Update : PasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        bindddlUserType();
        if (!IsPostBack)
        {
            if (Request.QueryString["id"] != null && Request.QueryString["id"] != "")
            {
                JY.BLL.UserInfo bll = new JY.BLL.UserInfo();
                JY.Model.UserInfo model = bll.GetModel(Convert.ToInt32(Request.QueryString["id"]));

                txtUserName.Text = model.UserName;
                txtPassword.Text = model.Password;
                ddlUserType.SelectedValue = model.UserType.ToString();
                txtRemark.Text = model.Remark;
            }
        }
    }

    /// <summary>
    /// 绑定下拉框
    /// </summary>
    private void bindddlUserType()
    {
        JY.BLL.UserType bll = new JY.BLL.UserType();
        ddlUserType.DataSource = bll.GetList(" isdelete=0 ").Tables[0];
        ddlUserType.DataTextField = "UserTypeName";
        ddlUserType.DataValueField = "ID";
        ddlUserType.DataBind();
    }

    /// <summary>
    /// 用户信息修改事件
    /// </summary>
    public void btnUpdate_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["id"] != null && Request.QueryString["id"] != "")
        {
            JY.BLL.UserInfo bll = new JY.BLL.UserInfo();
            JY.Model.UserInfo model = bll.GetModel(Convert.ToInt32(Request.QueryString["id"]));

            model.UserName = txtUserName.Text.Trim();
            model.Password = txtPassword.Text.Trim();
            model.UserType = Convert.ToInt32(ddlUserType.SelectedValue);
            model.Remark = txtRemark.Text.Trim();

            if (bll.Update(model))
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，用户信息修改成功！", "UserInfo_Manage.aspx");
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "对不起，用户信息修改失败！");
            }
        }
    }
    
    /// <summary>
    /// 取消事件
    /// </summary>
    public void btnReturn_Click(object sender, EventArgs e)
    {
        Response.Redirect("UserInfo_Manage.aspx");
    }
}
