﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class Information : System.Web.UI.Page
{
    protected string strTypeName = "";

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request.QueryString["InformationTypeId"] != null && Request.QueryString["InformationTypeId"] != "")
            {
                JY.BLL.InformationType bll = new JY.BLL.InformationType();
                JY.Model.InformationType model = bll.GetModel(Convert.ToInt64(Request.QueryString["InformationTypeId"]));
                strTypeName = model.TypeName;
            }

            BindData();
        }
    }

    protected int GetInt(object obj, int defaultValue)
    {
        if (obj != null)
        {
            try
            {
                defaultValue = Convert.ToInt32(obj);
            }
            catch
            {
            }
        }
        return defaultValue;
    }

    /// <summary>
    /// 获取资讯分类ID及所有子类ID
    /// </summary>
    /// <param name="ProductTypeId"></param>
    /// <returns></returns>
    private string getInformationTypeIds(long InformationTypeId)
    {
        string strInformationTypes = "";

        JY.BLL.InformationType bll = new JY.BLL.InformationType();
        DataTable dt = bll.GetList(" isdelete=0 and fid=" + InformationTypeId).Tables[0];

        if (dt.Rows.Count > 0)
        {
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                strInformationTypes += dt.Rows[i]["id"].ToString() + ",";

                strInformationTypes += getInformationTypeIds(Convert.ToInt64(dt.Rows[i]["id"]));
            }
        }

        return strInformationTypes;
    }

    /// <summary>
    /// 获取列表数据
    /// </summary>
    private void BindData()
    {
        int pageIndex = GetInt(Request.QueryString["Page"], 1);
        Pagination.Pagination _page = new Pagination.Pagination();

        _page.ItemUnit = "个号码";
        _page.ImagesPath = "~/Images/ui_form/";
        _page.Sequence = pageIndex;
        _page.PageSize = pager.PageSize;
        _page.TableName = "  Information ";
        _page.SearchField = " * ";

        _page.SearchSentence = " and Information.Isdelete=0 ";

        if (Request.QueryString["InformationTypeId"] != null && Request.QueryString["InformationTypeId"] != "")
        {
            _page.SearchSentence += " and InformationTypeId in (" + getInformationTypeIds(Convert.ToInt64(Request.QueryString["InformationTypeId"])) + Request.QueryString["InformationTypeId"] + ")";
        }

        _page.SortSentence = " Order By Information.Id desc ";
        _page.Primarykey = " Information.Id ";
        DataTable dt = _page.GetDataTable();

        rptInformation.DataSource = dt;
        rptInformation.DataBind();

        pager.RecordCount = _page.RecordCount;
        //显示记录信息   [ 共1508条 第1页 共151页 ]
        pager.CustomInfoHTML = "<span>共有&nbsp;<b>" + pager.RecordCount.ToString() + "</b>&nbsp;条记录，";
        pager.CustomInfoHTML += " 当前第&nbsp;<font color=\"red\"><b>" + pageIndex.ToString() + "</b></font>&nbsp;页，";
        pager.CustomInfoHTML += "共&nbsp;<b>" + pager.PageCount.ToString() + "</b>&nbsp;页</span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    }

    /// <summary>
    /// 获取资讯类型名称
    /// </summary>
    /// <param name="infomationTypeID"></param>
    /// <returns></returns>
    protected string getInformationTypeName(long infomationTypeID)
    {
        JY.BLL.InformationType bll = new JY.BLL.InformationType();
        JY.Model.InformationType model = bll.GetModel(infomationTypeID);

        return model.TypeName;
    }
}
