﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class Address : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            getAddress();
        }
    }

    /// <summary>
    /// 获取收货地址信息
    /// </summary>
    //private void getAddress()
    //{
    //    if (Session["MemberID"] != null)
    //    {
    //        JY.BLL.ReceiptAddress bll = new JY.BLL.ReceiptAddress();
    //        DataSet ds = bll.GetListByPage(" IsDelete=0 and MemberId=" + Session["MemberID"].ToString(), " ", 0, 5);

    //        rptAddress.DataSource = ds.Tables[0];
    //        rptAddress.DataBind();
    //    }       
    //}

    protected int GetInt(object obj, int defaultValue)
    {
        if (obj != null)
        {
            try
            {
                defaultValue = Convert.ToInt32(obj);
            }
            catch
            {
            }
        }
        return defaultValue;
    }

    /// <summary>
    /// 获取收货地址信息
    /// </summary>
    private void getAddress()
    {
        int pageIndex = GetInt(Request.QueryString["Page"], 1);
        Pagination.Pagination _page = new Pagination.Pagination();

        _page.ItemUnit = "个号码";
        _page.ImagesPath = "~/Images/ui_form/";
        _page.Sequence = pageIndex;
        _page.PageSize = pager.PageSize;
        _page.TableName = "  ReceiptAddress ";
        _page.SearchField = " * ";

        _page.SearchSentence = " and ReceiptAddress.Isdelete=0 ";

        if (Session["MemberID"] != null)
        {
            _page.SearchSentence += " and MemberId=" + Session["MemberID"].ToString();
        }

        _page.SortSentence = " Order By ReceiptAddress.Id desc ";
        _page.Primarykey = " ReceiptAddress.Id ";
        DataTable dt = _page.GetDataTable();

        rptAddress.DataSource = dt;
        rptAddress.DataBind();

        pager.RecordCount = _page.RecordCount;
        //显示记录信息   [ 共1508条 第1页 共151页 ]
        pager.CustomInfoHTML = "<span>共有&nbsp;<b>" + pager.RecordCount.ToString() + "</b>&nbsp;条记录，";
        pager.CustomInfoHTML += " 当前第&nbsp;<font color=\"red\"><b>" + pageIndex.ToString() + "</b></font>&nbsp;页，";
        pager.CustomInfoHTML += "共&nbsp;<b>" + pager.PageCount.ToString() + "</b>&nbsp;页</span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    }

    /// <summary>
    /// 删除功能
    /// </summary>
    /// <param name="source"></param>
    /// <param name="e"></param>
    protected void rptAddress_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        if (e.CommandName == "Del")
        {
            long addressID = Convert.ToInt64(e.CommandArgument);
            JY.BLL.ReceiptAddress bll = new JY.BLL.ReceiptAddress();
            JY.Model.ReceiptAddress model = bll.GetModel(addressID);
            model.IsDelete = true;

            if (bll.Update(model))
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，收货地址删除成功！", "Address.aspx");
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "对不起，收货地址删除失败！", "Address.aspx");
            }
        }
    }
}
