﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class AddressUpdate : System.Web.UI.Page
{
    JY.BLL.ReceiptAddress bll = new JY.BLL.ReceiptAddress();
    JY.Model.ReceiptAddress model = new JY.Model.ReceiptAddress();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack) 
        {
            initAddress();
        }
    }

    ///<summary>
    ///绑定数据
    ///</summary>>
    private void initAddress() 
    {
        model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
        this.txtConsignee.Text = model.Consignee;
        this.txtLiveAddress.Text = model.LiveAdderss;
        this.txtPhone.Text = model.Phone;
        this.txtZipCode.Text = model.ZipCode;
    }

    /// <summary>
    /// 收货地址修改
    /// </summary>
    public void tijiao_Click(object sender, EventArgs e)
    {
        try
        {
            model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
            model.Consignee = this.txtConsignee.Text.Trim();
            model.LiveAdderss = this.txtLiveAddress.Text.Trim();
            model.Phone = this.txtPhone.Text.Trim();
            model.ZipCode = this.txtZipCode.Text.Trim();


            if (bll.Update(model))
            {
                publicHandle.ShowMessage(this.Page, "恭喜您， 修改收货地址成功！", "Address.aspx");
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "对不起，修改收货地址失败！");
            }
        }
        catch (Exception er)
        {
            publicHandle.ShowMessage(this, er.Message);
        }
    }
}
