﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class Collection : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            getCollection();
        }
    }

    /// <summary>
    /// 获取收藏信息
    /// </summary>
    //private void getCollection()
    //{
    //    if (Session["MemberID"] != null)
    //    {
    //        JY.BLL.Collection bll = new JY.BLL.Collection();
    //        DataSet ds = bll.GetListByPage(" IsDelete=0 and MemberId=" + Session["MemberID"].ToString(), " ", 0, 10);

    //        rptCollection.DataSource = ds.Tables[0];
    //        rptCollection.DataBind();
    //    }
    //}

    protected int GetInt(object obj, int defaultValue)
    {
        if (obj != null)
        {
            try
            {
                defaultValue = Convert.ToInt32(obj);
            }
            catch
            {
            }
        }
        return defaultValue;
    }

    /// <summary>
    /// 获取收藏信息
    /// </summary>
    private void getCollection()
    {
        int pageIndex = GetInt(Request.QueryString["Page"], 1);
        Pagination.Pagination _page = new Pagination.Pagination();

        _page.ItemUnit = "个号码";
        _page.ImagesPath = "~/Images/ui_form/";
        _page.Sequence = pageIndex;
        _page.PageSize = pager.PageSize;
        _page.TableName = "  Collection ";
        _page.SearchField = " * ";

        _page.SearchSentence = " and Collection.Isdelete=0 ";

        if (Session["MemberID"] != null)
        {
            _page.SearchSentence += " and MemberId=" + Session["MemberID"].ToString();
        }

        _page.SortSentence = " Order By Collection.Id desc ";
        _page.Primarykey = " Collection.Id ";
        DataTable dt = _page.GetDataTable();

        rptCollection.DataSource = dt;
        rptCollection.DataBind();

        pager.RecordCount = _page.RecordCount;
        //显示记录信息   [ 共1508条 第1页 共151页 ]
        pager.CustomInfoHTML = "<span>共有&nbsp;<b>" + pager.RecordCount.ToString() + "</b>&nbsp;条记录，";
        pager.CustomInfoHTML += " 当前第&nbsp;<font color=\"red\"><b>" + pageIndex.ToString() + "</b></font>&nbsp;页，";
        pager.CustomInfoHTML += "共&nbsp;<b>" + pager.PageCount.ToString() + "</b>&nbsp;页</span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    }

    /// <summary>
    /// 删除功能
    /// </summary>
    /// <param name="source"></param>
    /// <param name="e"></param>
    protected void rptCollection_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        if (e.CommandName == "Del")
        {
            long collectionID = Convert.ToInt64(e.CommandArgument);
            JY.BLL.Collection bll = new JY.BLL.Collection();
            JY.Model.Collection model = bll.GetModel(collectionID);
            model.IsDelete = true;

            if (bll.Update(model))
            {
                getCollection();
                publicHandle.ShowMessage(this.Page, "恭喜您，商品收藏记录删除成功！");
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "对不起，商品收藏记录删除失败！");
            }
        }
    }

    protected string getProductNo(long productID)
    {
        JY.BLL.Product bll = new JY.BLL.Product();
        JY.Model.Product model = bll.GetModel(productID);

        return model.ProductNo;
    }

     protected string getProductPic(long productID)
    {
        JY.BLL.Product bll = new JY.BLL.Product();
        JY.Model.Product model = bll.GetModel(productID);

        return model.ProductPic;
    }

    
}
