﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class MemberInfoUpdate : System.Web.UI.Page
{
    JY.BLL.Member bll = new JY.BLL.Member();
    JY.Model.Member model = new JY.Model.Member();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack) 
        {
            initMember();
        }
    }

    /// <summary>
    /// 绑定数据
    /// </summary>
    protected void initMember()
    {
        if (Session["MemberID"] != null)
        {

            model = bll.GetModel(Convert.ToInt64(Session["MemberID"]));
            this.txtMemberName.Text = model.MemberName;
            this.txtEmail.Text = model.Email;
            this.txtPhone.Text = model.Phone;
            this.txtQQ.Text = model.QQ;
            this.txtAddress.Text = model.Address;
        }
    }

    /// <summary>
    /// 提交事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void tijiao_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            if (Session["MemberID"] != null)
            {
                model = bll.GetModel(Convert.ToInt64(Session["MemberID"]));              
                model.Email = this.txtEmail.Text.Trim();
                model.Phone = this.txtPhone.Text.Trim();
                model.QQ = this.txtQQ.Text.Trim();
                model.Address = this.txtAddress.Text.Trim();
             

                if (bll.Update(model))
                {
                    publicHandle.ShowMessage(this.Page, "恭喜您，基本信息修改成功！", "MemberInfo.aspx");
                }
                else
                {
                    publicHandle.ShowMessage(this.Page, "恭喜您，基本信息修改失败！", "MemberInfoUpdate.aspx");
                }
            }
        }
        catch (Exception ex)
        {
            publicHandle.ShowMessage(this, ex.Message);
        }
    }
}
