﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class Review : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            getReview();
        }
    }

    /// <summary>
    /// 获取评论信息
    /// </summary>
    //private void getReview()
    //{
    //    if (Session["MemberID"] != null)
    //    {
    //        JY.BLL.Review bll = new JY.BLL.Review();
    //        DataSet ds = bll.GetListByPage(" IsDelete=0 and MemberId=" + Session["MemberID"].ToString(), " ", 0, 10);

    //        rptReview.DataSource = ds.Tables[0];
    //        rptReview.DataBind();
    //    }
    //}

    protected int GetInt(object obj, int defaultValue)
    {
        if (obj != null)
        {
            try
            {
                defaultValue = Convert.ToInt32(obj);
            }
            catch
            {
            }
        }
        return defaultValue;
    }

    /// <summary>
    /// 获取评论信息
    /// </summary>
    private void getReview()
    {
        int pageIndex = GetInt(Request.QueryString["Page"], 1);
        Pagination.Pagination _page = new Pagination.Pagination();

        _page.ItemUnit = "个号码";
        _page.ImagesPath = "~/Images/ui_form/";
        _page.Sequence = pageIndex;
        _page.PageSize = pager.PageSize;
        _page.TableName = "  Review ";
        _page.SearchField = " * ";

        _page.SearchSentence = " and Review.Isdelete=0 ";

        if (Session["MemberID"] != null)
        {
            _page.SearchSentence += " and MemberId=" + Session["MemberID"].ToString();
        }

        _page.SortSentence = " Order By Review.Id desc ";
        _page.Primarykey = " Review.Id ";
        DataTable dt = _page.GetDataTable();

        rptReview.DataSource = dt;
        rptReview.DataBind();

        pager.RecordCount = _page.RecordCount;
        //显示记录信息   [ 共1508条 第1页 共151页 ]
        pager.CustomInfoHTML = "<span>共有&nbsp;<b>" + pager.RecordCount.ToString() + "</b>&nbsp;条记录，";
        pager.CustomInfoHTML += " 当前第&nbsp;<font color=\"red\"><b>" + pageIndex.ToString() + "</b></font>&nbsp;页，";
        pager.CustomInfoHTML += "共&nbsp;<b>" + pager.PageCount.ToString() + "</b>&nbsp;页</span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    }

    /// <summary>
    /// 删除功能
    /// </summary>
    /// <param name="source"></param>
    /// <param name="e"></param>
    protected void rptReview_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        if (e.CommandName == "Del")
        {
            long reviewID = Convert.ToInt64(e.CommandArgument);
            JY.BLL.Review bll = new JY.BLL.Review();
            JY.Model.Review model = bll.GetModel(reviewID);
            model.IsDelete = true;

            if (bll.Update(model))
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，评论删除成功！", "Review.aspx");
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "对不起，评论删除失败！", "Review.aspx");
            }
        }
    }
}
