﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class Order : System.Web.UI.Page
{
    BuyShopPing bp = new BuyShopPing();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack) 
        {
            bindrblAddress();
            bindCart();
            
        }
    }

    /// <summary>
    /// 绑定收货地址
    /// </summary>
    private void bindrblAddress()
    {
        if (Session["MemberID"] != null)
        {
            JY.BLL.ReceiptAddress bll = new JY.BLL.ReceiptAddress();
            rblAddress.DataSource = bll.GetList(" isdelete=0 and MemberId=" + Session["MemberID"].ToString() + " order by id desc");
            rblAddress.DataTextField = "AddressInfo";
            rblAddress.DataValueField = "ID";
            rblAddress.DataBind();

        }
 
    }

    /// <summary>
    /// 绑定购物车
    /// </summary>
    private void bindCart()
    {        
        decimal sum = 0.0M;

        if (Session["myCartTable"] != null)
        {
            rptShopPingCar.DataSource = (DataTable)Session["myCartTable"];
            rptShopPingCar.DataBind();
        }

        litSunMoney.Text = bp.GetCaculatorSum().ToString("￥0.00");
    }

    /// <summary>
    /// 确认订单
    /// </summary>
    protected void tijiao_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            if (Session["MemberID"] != null)
            {
                JY.BLL.OrderForm bll = new JY.BLL.OrderForm();
                JY.Model.OrderForm model = new JY.Model.OrderForm();

                model.OrderFormNo = sjname();
                model.MemberId = Convert.ToInt64(Session["MemberID"]);
                model.Purchaser = Session["MemberName"].ToString();
                model.Consignee = this.txtConsignee.Text.Trim();
                model.LiveAddress = this.txtLiveAddress.Text.Trim();
                model.Phone = this.txtPhone.Text.Trim();
                model.ZipCode = this.txtZipCode.Text.Trim();
                model.CreatDate = Convert.ToDateTime(DateTime.Now.ToString());
                model.ProductTotalPrice = Convert.ToDecimal(bp.GetCaculatorSum());
                model.Remark = txtRemark.Text.Trim();
                model.IsDelete = false;


                long OrderID = bll.Add(model);
                if (OrderID > 0)
                {
                    JY.BLL.OrderFormDetail OfdBll = new JY.BLL.OrderFormDetail();
                    JY.Model.OrderFormDetail OfdModel = new JY.Model.OrderFormDetail();

                    if (Session["myCartTable"] != null)
                    {
                        DataTable dt = (DataTable)Session["myCartTable"];
                        DataRow dr = dt.NewRow();

                        for (int i = 0; i < dt.Rows.Count; i++)
                        {
                            dr = dt.Rows[i];
                            OfdModel.OrderFormID = OrderID;
                            OfdModel.OrderFormNo = model.OrderFormNo;
                            OfdModel.ProductID = Convert.ToInt32(dr["ProductID"]);
                            OfdModel.ProductNo = dr["ProductNo"].ToString();
                            OfdModel.ProductName = dr["ProductName"].ToString();
                            OfdModel.Spec = dr["Spec"].ToString();
                            OfdModel.Price = Convert.ToDecimal(dr["WebsitePrice"].ToString());
                            OfdModel.WebsitePrice = Convert.ToDecimal(dr["WebsitePrice"].ToString());
                            OfdModel.Number = Convert.ToInt32(dr["ProductNum"].ToString());
                            OfdModel.TotalPrice = Convert.ToDecimal(dr["ProductTotal"].ToString());
                            OfdModel.IsDelete = false;

                            if (OfdBll.Add(OfdModel) > 0)
                            {
                                //DataTable nowTable2 = (DataTable)Session["myCartTable"];
                                //nowTable2.Rows.Clear();
                                //Session["myCartTable"] = nowTable2;
                                Session["myCartTable"] = null;
                            }
                        }
                    }


                    if (cbAddress.Checked)
                    {
                        JY.BLL.ReceiptAddress bllRA = new JY.BLL.ReceiptAddress();
                        JY.Model.ReceiptAddress modelRA = new JY.Model.ReceiptAddress();

                        DataTable dt = bllRA.GetList(" isdelete=0 and MemberId=" + Session["MemberID"].ToString() + " and Consignee='" + txtConsignee.Text.Trim() + "' and LiveAdderss='" + txtLiveAddress.Text.Trim() + "' and Phone='" + txtPhone.Text.Trim() + "' and ZipCode='" + txtZipCode.Text.Trim() + "'").Tables[0];

                        if (dt.Rows.Count <= 0)
                        {
                            modelRA.Consignee = txtConsignee.Text.Trim();
                            modelRA.CreateDate = DateTime.Now;
                            modelRA.IsDelete = false;
                            modelRA.LiveAdderss = txtLiveAddress.Text.Trim();
                            modelRA.MemberId = Convert.ToInt32(Session["MemberID"]);
                            modelRA.Phone = txtPhone.Text.Trim();
                            modelRA.ZipCode = txtZipCode.Text.Trim();
                            bllRA.Add(modelRA);
                        }
                    }

                    publicHandle.ShowMessage(this.Page, "恭喜您，订单提交成功！", "OrderInfo.aspx?OrderFormNo=" + model.OrderFormNo);
                }
                else
                {
                    publicHandle.ShowMessage(this.Page, "对不起，订单提交失败！");
                }
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "对不起，您没有登录，请登录后再提交订单！", "Login.aspx?url="+ Request.RawUrl);
            }
        }
        catch (Exception er)
        {
            publicHandle.ShowMessage(this, er.Message);
        }
    }

    /// <summary>
    /// 产生一个随机名称，以免图片名重复时将覆盖文件原有文件
    /// </summary>
    public string sjname()
    {
        string sj = null;
        sj = DateTime.Now.Year.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Day.ToString() + DateTime.Now.TimeOfDay.Hours.ToString() + DateTime.Now.TimeOfDay.Minutes.ToString() + DateTime.Now.TimeOfDay.Milliseconds.ToString() + new Random().Next(1000, 9999);
        return sj;
    }


    /// <summary>
    /// 选取收货地址并绑定
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void rblAddress_SelectedIndexChanged(object sender, EventArgs e)
    {       
        JY.BLL.ReceiptAddress bll = new JY.BLL.ReceiptAddress();
        JY.Model.ReceiptAddress model = bll.GetModel(Convert.ToInt64(rblAddress.SelectedValue));

        txtConsignee.Text = model.Consignee;
        txtLiveAddress.Text = model.LiveAdderss;
        txtPhone.Text = model.Phone;
        txtZipCode.Text = model.ZipCode;

        cbAddress.Checked = false;
    }
}
