﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class Productdetail : System.Web.UI.Page
{
    protected string strProductName = "";
    protected string strProductPic = "";
    protected string strMarketPrice = "";
    protected string strWebsitePrice = "";
    protected string strBrand = "";
    protected string strDescription = "";
    
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            JY.BLL.Product bll = new JY.BLL.Product();
            JY.Model.Product model = bll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));

            strProductName = model.ProductName;
            strProductPic = model.ProductPic;
            strMarketPrice = model.MarketPrice.ToString();
            strWebsitePrice = model.WebsitePrice.ToString();
            strDescription = model.Description;

            JY.BLL.Brand brandBll = new JY.BLL.Brand();
            JY.Model.Brand brandModel = brandBll.GetModel(Convert.ToInt64(Request.QueryString["ID"]));
            strBrand = brandModel.BrandName;

            getProductrelated(Convert.ToInt64(model.ProductTypeId));


        }
        catch
        {
        }


        if (!IsPostBack)
        {           
        }

        BindReviewData();
    }

    /// <summary>
    /// 获取相关产品
    /// </summary>
    private void getProductrelated(long productTypeID)
    {       

        JY.BLL.Product bll = new JY.BLL.Product();

        rptProductrelated.DataSource = bll.GetList(3, " IsDelete=0 and ProductTypeId=" + productTypeID +" and ID<>" + Request.QueryString["ID"], " ID DESC").Tables[0];
        rptProductrelated.DataBind();
    }

    protected int GetInt(object obj, int defaultValue)
    {
        if (obj != null)
        {
            try
            {
                defaultValue = Convert.ToInt32(obj);
            }
            catch
            {
            }
        }
        return defaultValue;
    }

    ///<summary>
    ///绑定评论内容的数据
    ///</summary> 
    private void BindReviewData()
    {
        int pageIndex = GetInt(Request.QueryString["Page"], 1);
        Pagination.Pagination _page = new Pagination.Pagination();

        _page.ItemUnit = "个号码";
        _page.ImagesPath = "~/Images/ui_form/";
        _page.Sequence = pageIndex;
        _page.PageSize = pager.PageSize;
        _page.TableName = "  Review ";
        _page.SearchField = " * ";

        _page.SearchSentence = " and Isdelete=0 and ProductId=" + Request.QueryString["ID"];

        //if (Request.QueryString["InformationTypeId"] != null && Request.QueryString["InformationTypeId"] != "")
        //{
        //    _page.SearchSentence += " and InformationTypeId in (" + getInformationTypeIds(Convert.ToInt64(Request.QueryString["InformationTypeId"])) + Request.QueryString["InformationTypeId"] + ")";
        //}

        _page.SortSentence = " Order By Review.Id desc ";
        _page.Primarykey = " Review.Id ";
        DataTable dt = _page.GetDataTable();

        rptReview.DataSource = dt;
        rptReview.DataBind();

        pager.RecordCount = _page.RecordCount;
        //显示记录信息   [ 共1508条 第1页 共151页 ]
        pager.CustomInfoHTML = "<span>共有&nbsp;<b>" + pager.RecordCount.ToString() + "</b>&nbsp;条记录，";
        pager.CustomInfoHTML += " 当前第&nbsp;<font color=\"red\"><b>" + pageIndex.ToString() + "</b></font>&nbsp;页，";
        pager.CustomInfoHTML += "共&nbsp;<b>" + pager.PageCount.ToString() + "</b>&nbsp;页</span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    }
    
    
    /// <summary>
    /// 评论
    /// </summary>
    public void tijiao_Click(object sender, EventArgs e)
    {
        JY.BLL.Review rebll = new JY.BLL.Review();
        JY.Model.Review remodel = new JY.Model.Review();
        
        try
        {
            if (Session["MemberID"] != null)
            {
                remodel.MemberId = Convert.ToInt64(Session["MemberID"]);
                remodel.ReviewName = Session["MemberName"].ToString();
            }
            else
            {
                remodel.MemberId = 0;
                remodel.ReviewName = "游客";
            }
            remodel.ProductId = Convert.ToInt32(Request.QueryString["ID"]);
            remodel.ProductName = strProductName;
            remodel.ReviewContent = this.txtReviewContent.Text;
            remodel.ReviewDate = Convert.ToDateTime(DateTime.Now.ToString());

            remodel.IsDelete = false;

            if (rebll.Add(remodel) > 0)
            {
                publicHandle.ShowMessage(this.Page, "恭喜您，评论成功！", "Productdetail.aspx?id=" + Request.QueryString["ID"]);
            }
            else
            {
                publicHandle.ShowMessage(this.Page, "对不起，评论失败！", "Productdetail.aspx?id=" + Request.QueryString["ID"]);
            }

        }
        catch (Exception er)
        {
            publicHandle.ShowMessage(this, er.Message);
        }
    }

    /// <summary>
    /// 收藏商品
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCollection_Click(object sender, EventArgs e)
    {
        if (Session["MemberID"] != null)
        {
            JY.BLL.Collection bll = new JY.BLL.Collection();
            JY.Model.Collection model = new JY.Model.Collection();

            DataTable dt = bll.GetList(" MemberId=" + Session["MemberID"].ToString() + " and ProductId=" + Request.QueryString["ID"] + " and isdelete=0").Tables[0];

            if (dt.Rows.Count > 0)   //判断此商品是否被收藏过
            {
                publicHandle.ShowMessage(this.Page, "对不起，您已收藏过此商品，请收藏其它商品！");
            }
            else
            {
                model.MemberId = Convert.ToInt32(Session["MemberID"]);
                model.MemberName = Session["MemberName"].ToString();
                model.ProductId = Convert.ToInt32(Request.QueryString["ID"]);
                model.ProductName = strProductName;
                model.IsDelete = false;
                model.CollectionDate = DateTime.Now;

                if (bll.Add(model) > 0)
                {
                    publicHandle.ShowMessage(this.Page, "恭喜您，商品收藏成功！");
                }
            }
        }
        else
        {
            publicHandle.ShowMessage(this.Page, "对不起，您没有登录，请登录后再收藏商品！","Login.aspx?url=" + Request.RawUrl);
        }
    }
}
