﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class Products : System.Web.UI.Page
{
    protected string strTypeName = "";
    protected string strProductName = "";
    protected string strProductPic = "";
    protected string strDescription = "";
    protected string strMarketPrice = "";
    protected string strWebsitePrice = "";

    string Ids = "";
    JY.BLL.ComDataList combll = new JY.BLL.ComDataList();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request.QueryString["ProductTypeId"] != null && Request.QueryString["ProductTypeId"] != "")
            {
                JY.BLL.ProductType bllpt = new JY.BLL.ProductType();
                JY.Model.ProductType modelpt = bllpt.GetModel(Convert.ToInt64(Request.QueryString["ProductTypeId"]));
                strTypeName =  "<b>产品分类：</b>" + modelpt.TypeName;
            }
            else if (Request.QueryString["keyword"] != null && Request.QueryString["keyword"] != "")
            {
                  strTypeName = Server.UrlDecode(Request.QueryString["keyword"])  + " 系列产品";
            }
            

            BindData();

        }
    }

    protected int GetInt(object obj, int defaultValue)
    {
        if (obj != null)
        {
            try
            {
                defaultValue = Convert.ToInt32(obj);
            }
            catch
            {
            }
        }
        return defaultValue;
    }

 
    /// <summary>
    /// 获取产品分类ID及所有子类ID
    /// </summary>
    /// <param name="ProductTypeId"></param>
    /// <returns></returns>
    private string getProductTypeIds(long ProductTypeId)
    {
        string strProductTypes = "";

        JY.BLL.ProductType bllpt = new JY.BLL.ProductType();
        DataTable dt = bllpt.GetList(" isdelete=0 and fid=" + ProductTypeId).Tables[0];

        if (dt.Rows.Count > 0)
        {            
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                strProductTypes += dt.Rows[i]["id"].ToString() + ",";

                strProductTypes += getProductTypeIds(Convert.ToInt64(dt.Rows[i]["id"]));              
            }

            //strProductTypes = strProductTypes.Substring(0, strProductTypes.Length - 1);
        }
                
        return  strProductTypes;
    }

    /// <summary>
    /// 获取列表数据
    /// </summary>
    private void BindData()
    {
        int pageIndex = GetInt(Request.QueryString["Page"], 1);
        Pagination.Pagination _page = new Pagination.Pagination();

        _page.ItemUnit = "个号码";
        _page.ImagesPath = "~/Images/ui_form/";
        _page.Sequence = pageIndex;
        _page.PageSize = pager.PageSize;
        _page.TableName = "  Product ";
        _page.SearchField = " * ";

        _page.SearchSentence = " and Product.Isdelete=0 ";

        if (Request.QueryString["ProductTypeId"] != null && Request.QueryString["ProductTypeId"] != "")
        {
            _page.SearchSentence += " and ProductTypeId in (" + getProductTypeIds(Convert.ToInt64(Request.QueryString["ProductTypeId"])) + Request.QueryString["ProductTypeId"] + ")";
        }

        if (Request.QueryString["keyword"] != null && Request.QueryString["keyword"] != "")
        {
            _page.SearchSentence += " and productName like '%" + Server.UrlDecode(Request.QueryString["keyword"]) + "%' ";
        }

        

        _page.SortSentence = " Order By Product.Id desc ";
        _page.Primarykey = " Product.Id ";
        DataTable dt = _page.GetDataTable();

        rptProduct.DataSource = dt;
        rptProduct.DataBind();

        pager.RecordCount = _page.RecordCount;
        //显示记录信息   [ 共1508条 第1页 共151页 ]
        pager.CustomInfoHTML = "<span>共有&nbsp;<b>" + pager.RecordCount.ToString() + "</b>&nbsp;条记录，";
        pager.CustomInfoHTML += " 当前第&nbsp;<font color=\"red\"><b>" + pageIndex.ToString() + "</b></font>&nbsp;页，";
        pager.CustomInfoHTML += "共&nbsp;<b>" + pager.PageCount.ToString() + "</b>&nbsp;页</span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    }
}
