﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

using JY.Model;

public partial class Shoppingcart : System.Web.UI.Page
{
    public string Money = "0.0";   
    public int size = 35;
    public int Size
    {
        get { return size; }
        set { size = value; }
    }

    public string url = "";

    BuyShopPing bp = new BuyShopPing();

    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            if (Request.QueryString["mode"] != "view")
            {
                int pid = Utility.StringHelper.GetInt(Request.QueryString["ProductID"]);
                int num = Utility.StringHelper.GetInt(Request.QueryString["num"]);

                //string strSize = Server.UrlDecode(Request.QueryString["Size"]);
                //string strColor = Server.UrlDecode(Request.QueryString["Color"]);
                //string strColorID = getColorID(strColor);

                if (pid > 0)
                {
                    bp.UpdateShoppingCart();
                }

                if (Request.QueryString["flag"] == "Clear")
                {
                    if (Session["myCartTable"] != null)
                    {
                        DataTable nowTable2 = (DataTable)Session["myCartTable"];
                        nowTable2.Rows.Clear();
                        Session["myCartTable"] = nowTable2;
                    }
                }
            }
            else
            {
                if (!string.IsNullOrEmpty(Request.QueryString["Erroinfo"]))
                {
                    publicHandle.ShowMessage(this.Page, Request.QueryString["Erroinfo"].ToString());
                }
            }
           
            bindCart();

        }
    }       

    /// <summary>
    /// 绑定购物车
    /// </summary>
    private void bindCart()
    {
        decimal sum = 0.0M;

        if (Session["myCartTable"] != null)
        {
            rptShopPingCar.DataSource = (DataTable)Session["myCartTable"];
            rptShopPingCar.DataBind();
        }

        litSunMoney.Text = bp.GetCaculatorSum().ToString("￥0.00");
    }
    /// <summary>
    /// 操作购物车
    /// </summary>
    /// <param name="source"></param>
    /// <param name="e"></param>

    protected void rptShopPingCar_OnItemCommand(object source, RepeaterCommandEventArgs e)
    {
        string command = e.CommandName;
        string Erroinfo = "";
        TextBox txt = e.Item.FindControl("txtProductNum") as TextBox;
        switch (command)
        {
            case "update":
                if (Convert.ToInt32(txt.Text) <= 0)
                {
                    Erroinfo = "请输入1以上有效数字";
                }               
                else
                {
                    bp.UpdateShoppingCar(Convert.ToInt32(e.CommandArgument.ToString()), Convert.ToInt32(txt.Text));
                }
                break;
            case "Del":
                bp.RemoveShoppingCar(Convert.ToInt32(e.CommandArgument.ToString()));
                break;
            default:
                break;
        }

        Response.Redirect("Shoppingcart.aspx?mode=view&Erroinfo=" + Erroinfo);
    }

    /// <summary>
    /// 结账
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnBuy_Click(object sender, EventArgs e)
    {
        BuyShopPing buy = new BuyShopPing();

        if (buy.GetCaculatorSum() > 0)
        {
            if (Session["MemberID"] != null)
            {               
                 Response.Redirect("Order.aspx");               
            }
            else
            {
                Response.Redirect("Login.aspx?url=" + Server.UrlEncode(Request.RawUrl.ToString()));
            }
        }
        else
        {
            ScriptManager.RegisterStartupScript(this.Page, this.GetType(), "Click", "alert('对不起，您没有购买商品，不能结算！')", true);
        }

        // Response.Write("werwerwer");
    }

}
