﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class WebControl_Left : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            getProductType();
            getProductHot();
        }
    }

    /// <summary>
    /// 获取产品类型
    /// </summary>
    private void getProductType()
    {
        JY.BLL.ProductType ptbll = new JY.BLL.ProductType();
        DataSet ds = ptbll.GetListByPage(" IsDelete=0 and fid=0", " sort ", 0, 6);

        rptProductType.DataSource = ds.Tables[0];
        rptProductType.DataBind();
    }

    /// <summary>
    /// 获取产品子类型
    /// </summary>
    protected void rptProductType_ItemDataBound(object obj, RepeaterItemEventArgs e)
    {
        try
        {
            JY.BLL.ProductType bll = new JY.BLL.ProductType();

            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                DataRowView row = (DataRowView)e.Item.DataItem;
                long typeId = Convert.ToInt32(row["Id"].ToString());
                DataSet ds = bll.GetListByPage(" IsDelete=0 and fid=" + typeId, " sort ", 0, 15);


                ((Repeater)e.Item.FindControl("rptProductChildType")).DataSource = ds.Tables[0];
                ((Repeater)e.Item.FindControl("rptProductChildType")).DataBind();
            }
        }
        catch (Exception ex)
        {
        }
    }

    /// <summary>
    /// 获取热销产品
    /// </summary>
    private void getProductHot()
    {
        JY.BLL.Product prbll = new JY.BLL.Product();
        DataSet ds = prbll.GetListByPage(" IsDelete=0", " sort", 0, 4);

        rptProductHot.DataSource = ds.Tables[0];
        rptProductHot.DataBind();
    }
}
