﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class MemberCenter_Top : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {      
        if (!IsPostBack)
        {
            if (Session["MemberID"] == null)
            {
                publicHandle.ShowMessage(this.Page, "对不起，您没有登录，或登录时间过长，请重新登录！", "../Login.aspx");
            }

            getProductType();
            getInformationType();


            if (Request.QueryString["keyword"] != null && Request.QueryString["keyword"] != "")
            {
                txtKeyword.Text = Server.UrlDecode(Request.QueryString["keyword"]);              
            }

        }
    }

    /// <summary>
    /// 获取产品类型
    /// </summary>
    private void getProductType()
    {
        JY.BLL.ProductType ptbll = new JY.BLL.ProductType();
        DataSet ds = ptbll.GetListByPage(" IsDelete=0 and fid=0", " sort ", 0, 10);

        rptProductType.DataSource = ds.Tables[0];
        rptProductType.DataBind();
    }

    /// <summary>
    /// 获取产品子类型
    /// </summary>
    protected void rptProductType_ItemDataBound(object obj, RepeaterItemEventArgs e)
    {
        try
        {
            JY.BLL.ProductType bll = new JY.BLL.ProductType();

            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                DataRowView row = (DataRowView)e.Item.DataItem;
                long typeId = Convert.ToInt32(row["Id"].ToString());
                DataSet ds = bll.GetListByPage(" IsDelete=0 and fid=" + typeId, " sort ", 0, 15);


                ((Repeater)e.Item.FindControl("rptProductChildType")).DataSource = ds.Tables[0];
                ((Repeater)e.Item.FindControl("rptProductChildType")).DataBind();
            }
        }
        catch (Exception ex)
        {
        }
    }

    /// <summary>
    /// 获取资讯类型
    /// </summary>
    private void getInformationType()
    {
        JY.BLL.InformationType itbll = new JY.BLL.InformationType();
        DataSet ds = itbll.GetListByPage(" IsDelete=0 and fid=0", " sort ", 0, 10);

        rptInformationType.DataSource = ds.Tables[0];
        rptInformationType.DataBind();
    }

    /// <summary>
    /// 获取资讯子类型
    /// </summary>
    protected void rptInformationType_ItemDataBound(object obj, RepeaterItemEventArgs e)
    {
        try
        {
            JY.BLL.InformationType bll = new JY.BLL.InformationType();

            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                DataRowView row = (DataRowView)e.Item.DataItem;
                long typeId = Convert.ToInt32(row["Id"].ToString());
                DataSet ds = bll.GetListByPage(" IsDelete=0 and fid=" + typeId, " sort ", 0, 15);


                ((Repeater)e.Item.FindControl("rptInformationChildType")).DataSource = ds.Tables[0];
                ((Repeater)e.Item.FindControl("rptInformationChildType")).DataBind();
            }
        }
        catch (Exception ex)
        {
        }
    }


    protected void btnSearch_OnClick(object sender, EventArgs e)
    {       
        if (txtKeyword.Text.Trim() != "")
        {
            string strUrl = "../Products.aspx";
            strUrl += "?keyword=" + Server.UrlEncode(txtKeyword.Text.Trim());

            Response.Redirect(strUrl);
        }       

    }

    protected void lbnTuo_Click(object sender, EventArgs e)
    {
        Session["MemberID"] = null;
        Session["MemberName"] = null;
        Session["MemberRankId"] = null;

        publicHandle.ShowMessage(this.Page, "安全退出成功！", "../index.aspx");
    }
}
