﻿//-----------------------------------------------------------
// 文件名称: Web25175_School.calendar.v1.1.js
// 页面名称: Web25175_School.calendar.v1.1
//　
// 描    述: 日历
// 版　　本: 1.1
// 兼容情况: IE6+,Chrome,Mozilla, Netscape, Firefox,Maxthon3+,
// 创建标识: Add By 吴希 2011-10-26
//---------------------------------------------
//------------------------------------------------------------------------------------------
// 2012/08/02 Id$WuXi 更新日志： 1、uiCalendar_Setup  图标定位在元素背景中
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
// 2012/06/21 Id$WuXi 更新日志： 1、uiCalendar_Position 游览器定位 滚动也能定位
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
// 2012/06/13 Id$WuXi 更新日志： 1、uiCalendar_Position 游览器定位
//------------------------------------------------------------------------------------------
var w_d = new Date();
var w_d2 = new Date();
var w_monthname = new Array("1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月");
var w_dayname = new Array("日", "一", "二", "三", "四", "五", "六");
var w_StartOfWeek = 0; // 默认星期日开头

//设置默认位置
//周结束的日子（Staurday，星期日）

var weekend_pos = new Array(6, 0);

var w_min_year = 1960;
var w_max_year = 2099;

var w_args = "yyyy-mm-dd";

var w_linkedInputText; //对象

//-----------------------------------------------------------
// 名    称:  uiCalendar_ChangeMonth
// 描    述:  切换月
//-----------------------------------------------------------
function uiCalendar_ChangeMonth(id) {
    var box = uiGet(id);
    var mm = box.options[box.selectedIndex].value;
    w_d.setMonth(mm);
    uiGetCalendar_Month(0);
}

//-----------------------------------------------------------
// 名    称:  uiCalendar_ChangeYear
// 描    述:  切换年
//-----------------------------------------------------------
function uiCalendar_ChangeYear(id) {
    var box = uiGet(id);
    var yy = box.options[box.selectedIndex].value;
    w_d.setFullYear(yy);
    uiGetCalendar_Year(0);
}

//-----------------------------------------------------------
// 名    称:  uiCalendar_GetWeek
// 描    述:  获取星期
//-----------------------------------------------------------
function uiCalendar_GetWeek(year, month, day) {

    month += 1; // 1-12 月
    var a = Math.floor((14 - (month)) / 12);
    var y = year + 4800 - a;
    var m = (month) + (12 * a) - 3;

    /*公历*/
    var jd = day + Math.floor(((153 * m) + 2) / 5) + (365 * y) + Math.floor(y / 4) - Math.floor(y / 100) + Math.floor(y / 400) - 32045;

    /*儒略历*/
    /*var jd = (day + 1) + Math.round(((153 * m) + 2) / 5) + (365 + y) + Math.round(y / 4) - 32083;*/

    //根据JD 获取 weeknumber
    var d4 = (jd + 31741 - (jd % 7)) % 146097 % 36524 % 1461;
    var L = Math.floor(d4 / 1460);
    var d1 = ((d4 - L) % 365) + L;
    NumberOfWeek = Math.floor(d1 / 7) + 1;
    return NumberOfWeek;
}
//-----------------------------------------------------------
// 名    称:  uiGetCalendar_DayNumber
// 描    述:  获取天数字串
//-----------------------------------------------------------
function uiGetCalendar_DayNumber(d) {
    var dd = new Date(d);
    var temp = new Date(d);

    // 重置数据阵列
    for (i = 0; i < 6; i++) {
        for (j = 0; j < 7; j++) {
            uiGet("w_c" + i + "" + j).innerHTML = "";
            uiGet("w_c" + i + "" + j).className = "day_out";
        }
    }

    // 设定每月的第一天
    dd.setDate(1);

    // 填写数据数组
    i = 0;
    j = 0;

    //前一个月的天
    j = dd.getDay() - w_StartOfWeek;
    if (j < 0) j = 7 + j;

    if (j > 0) {
        temp.setDate(dd.getDate() - 1);
        for (k = j - 1; k >= 0; k--) {
            uiGet("w_c" + i + "" + k).innerHTML = temp.getDate();
            if ((weekend_pos[0] == k) || (weekend_pos[1] == k)) uiGet("w_c" + i + "" + k).className = "weekends_out";
            else uiGet("w_c" + i + "" + k).className = "day_out";

            temp.setDate(temp.getDate() - 1);
        }
    }

    var week = -1;
    var iStartWeek = -1;
    var iEndWeek = -1;
    var weekEl;
    var dayval;

    do {
        //获取位置，根据StartOfWeek
        j = dd.getDay() - w_StartOfWeek;
        if (j < 0) j = 7 + j;

        if (iStartWeek == -1) iStartWeek = j;
        iEndWeek = j;

        dayval = dd.getDate();

        // 获取周数
        if (week < 0) week = uiCalendar_GetWeek(w_d.getFullYear(), w_d.getMonth(), dayval);

        uiGet("w_c" + i + "" + j).innerHTML = dayval;

        // 设置天的样式
        if ((weekend_pos[0] == j) || (weekend_pos[1] == j)) uiGet("w_c" + i + "" + j).className = "weekends";
        else uiGet("w_c" + i + "" + j).className = "day"; {

            //设置被选中的样式
            if ((w_d2.getDate() == dayval) && (w_d2.getMonth() == w_d.getMonth()) && (w_d2.getFullYear() == w_d.getFullYear()))

            {

                uiGet("w_c" + i + "" + j).className = "Selday";

            }

            // 设置今天的样式
            var today = new Date();
            if ((today.getDate() == dayval) && (today.getMonth() == w_d.getMonth()) && (today.getFullYear() == w_d.getFullYear())) uiGet("w_c" + i + "" + j).className = "today";

        }

        ////////
        // 天 设置事件
        // 仅在所选月份的一天
        var object = uiGet("w_c" + i + "" + j);
        object.onclick = function() {
            uiCalendar_setDate(this);
        }

        if (j == 6) {

            week = -1;
            iStartWeek = -1;
            iEndWeek = -1;
            i++;
        }
        dd.setDate(dd.getDate() + 1);

    } while ( dd . getDate () != 1);

    // 下个月的天
    if ((j < 7)) {
        temp = dd;
        for (k = j + 1; k < 7; k++) {
            uiGet("w_c" + i + "" + k).innerHTML = temp.getDate();
            if ((weekend_pos[0] == k) || (weekend_pos[1] == k)) uiGet("w_c" + i + "" + k).className = "weekends_out";
            else uiGet("w_c" + i + "" + k).className = "day_out";
            temp.setDate(temp.getDate() + 1);
        }
    }
}
//-----------------------------------------------------------
// 名    称: uiGetCalendar_Month、 uiGetCalendar_Year
// 描    述: 输出年月
//-----------------------------------------------------------
function uiGetCalendar_Month(k) {
    var sbl = '';
    w_d.setMonth(w_d.getMonth() + k);
    sbl += '<select class="nav" id="w_sel_month" onchange="uiCalendar_ChangeMonth(\'w_sel_month\')">';
    for (im = 0; im < 12; im++) {
        sbl += '<option value="' + im + '" ' + ((im == w_d.getMonth()) ? 'selected ': '') + '>' + w_monthname[im] + '</option>';
    }
    sbl += '</select>';
    sbl += ' ';
    sbl += '<select class="nav" id="w_sel_year" onchange="uiCalendar_ChangeYear(\'w_sel_year\')">';
    for (im = w_min_year; im <= w_max_year; im++) {
        sbl += '<option value="' + im + '" ' + ((im == w_d.getFullYear()) ? 'selected ': '') + '>' + im + '</option>';
    }
    sbl += '</select>';
    sbl += ' ';
    uiGet('w_month_year').innerHTML = sbl;
    uiGetCalendar_DayNumber(w_d);
}
function uiGetCalendar_Year(k) {
    var sbl = '';
    w_d.setYear(w_d.getFullYear() + k);
    sbl += '<select class="nav" id="w_sel_month" onchange="uiCalendar_ChangeMonth(\'w_sel_month\')">';
    for (im = 0; im < 12; im++) {
        sbl += '<option value="' + im + '" ' + ((im == w_d.getMonth()) ? 'selected ': '') + '>' + w_monthname[im] + '</option>';
    }
    sbl += '</select>';
    sbl += ' ';
    sbl += '<select class="nav" id="w_sel_year" onchange="uiCalendar_ChangeYear(\'w_sel_year\')">';
    for (im = w_min_year; im <= w_max_year; im++) {
        sbl += '<option value="' + im + '" ' + ((im == w_d.getFullYear()) ? 'selected ': '') + '>' + im + '</option>';
    }
    sbl += '</select>';
    sbl += ' ';
    uiGet('w_month_year').innerHTML = sbl;
    uiGetCalendar_DayNumber(w_d);
}
//-----------------------------------------------------------
// 名    称:  uiCalendar_setDate
// 描    述:  点击日历
//-----------------------------------------------------------
function uiCalendar_setDate(obj) {
    var m = "";
    var g = "";
    var mMonth;
    var mDay;

    mMonth = (w_d.getMonth() + 1);
    mDay = obj.innerHTML;

    if (mMonth < 10) m = "0" + mMonth
    else m = mMonth

    if (mDay < 10) g = "0" + mDay
    else g = mDay

    var s = w_d.getFullYear() + "-" + m + "-" + g;

    if (w_args == "yyyy-mm-dd hh:mm:ss") {
        var HH = "";
        var mm = "";
        var ss = "";
        HH = uiGet("w_sel_HH").value < 10 ? "0" + uiGet("w_sel_HH").value: uiGet("w_sel_HH").value;
        mm = uiGet("w_sel_mm").value < 10 ? "0" + uiGet("w_sel_mm").value: uiGet("w_sel_mm").value;
        ss = uiGet("w_sel_ss").value < 10 ? "0" + uiGet("w_sel_ss").value: uiGet("w_sel_ss").value;
        s += " " + HH + ":" + mm + ":" + ss;
    }
    // 设置对象值
    try {
        uiGet(w_linkedInputText).value = s;
        
        var fun= uiGet(w_linkedInputText).getAttribute("onchange");
        if (fun!=null) eval(fun);
        
        uiGet(w_linkedInputText).onchange();
    } catch(e) {}
    uiCalendar_Close();
}
//-----------------------------------------------------------
// 名    称: uiChkDate
// 描    述: yyyy-MM-dd
//-----------------------------------------------------------
function uiChkDate(str) {
    var reg = /^(\d{4})\-(\d{2})\-(\d{2})$/
    var r = str.match(reg);
    if (r == null) return false;
    r[2] = r[2] - 1;
    var d = new Date(r[1], r[2], r[3]);
    if (d.getFullYear() != r[1]) return false;
    if (d.getMonth() != r[2]) return false;
    if (d.getDate() != r[3]) return false;
    w_d = new Date(r[1], r[2], r[3]);
    w_d2 = new Date(r[1], r[2], r[3]);
    return true;
}
//-----------------------------------------------------------
// 名    称: uiChkDateTime
// 描    述: yyyy-MM-dd HH:mm:ss
//-----------------------------------------------------------
function uiChkDateTime(str) {
    var reg = /^(\d{4})\-(\d{2})\-(\d{2}) (\d{2}):(\d{2}):(\d{2})$/;
    var r = str.match(reg);
    if (r == null) return false;
    r[2] = r[2] - 1;
    var d = new Date(r[1], r[2], r[3], r[4], r[5], r[6]);
    if (d.getFullYear() != r[1]) return false;
    if (d.getMonth() != r[2]) return false;
    if (d.getDate() != r[3]) return false;
    if (d.getHours() != r[4]) return false;
    if (d.getMinutes() != r[5]) return false;
    if (d.getSeconds() != r[6]) return false;
    w_d = new Date(r[1], r[2], r[3], r[4], r[5], r[6]);
    w_d2 = new Date(r[1], r[2], r[3], r[4], r[5], r[6]);
    return true;
}
//-----------------------------------------------------------
// 名    称: uiCalendar
// 描    述: 日历控件
//-----------------------------------------------------------
function uiCalendar_Setup(elementId, args) {
    if (uiGet(elementId) != null) {
        var obj = uiGet(elementId);
        with(obj.style) {
            backgroundImage = "url(Images/Calendar.png)",
            backgroundRepeat = "no-repeat",
            backgroundPosition = "right"
        }
        obj.maxLength = args == null ? 10 : args.length;
        obj.onclick = function() {
            args = (args == null ? "yyyy-MM-dd": args);
            return uiCalendar_Show(elementId, args);
        }
    }
}
//-----------------------------------------------------------
// 名    称:  uiCalendar_Show
// 描    述:  点击日历
//-----------------------------------------------------------
function uiCalendar_Show(elementId, args) {
    w_d = new Date();
    if (args != null) {
        w_args = args.toLowerCase() != "yyyy-mm-dd hh:mm:ss" ? "yyyy-mm-dd": "yyyy-mm-dd hh:mm:ss";
        var text = uiGet(elementId);
        if (text.value.trim() != "") {
            switch (args.toLowerCase()) {
            case "yyyy-mm-dd hh:mm:ss":
                if (uiChkDateTime(text.value.trim())) {
                    w_args = "yyyy-mm-dd hh:mm:ss";
                }
                break;
            case "yyyy-mm-dd":
                if (uiChkDate(text.value.trim())) {
                    w_args = "yyyy-mm-dd";
                }
                break;
            }
        }
    }
    InitCalendar();
    w_linkedInputText = elementId;

    uiGetCalendar_Month(0);
    uiGet('uiCalendar').style.visibility = "visible";
    uiCalendar_Position(text);
}
//-----------------------------------------------------------
// 名    称:  uiCalendar_Position
// 描    述:  日历的位置定位
//-----------------------------------------------------------
function uiCalendar_Position(elementT1) {
    var result = uiGetPosition(elementT1);
    var width = 240;
    var left = 0;
    var top = 0;

    var Calendar = uiGetPosition(uiGet('uiCalendar'));
    var ie = new Object();
    ie.y = parseInt(document.documentElement.scrollHeight, 10);
    ie.x = parseInt(document.documentElement.scrollWidth, 10);

    left = result.x + result.width + width;
    top = result.y + result.height + Calendar.height;

    if (left > ie.x) {
        left = ie.x - width - 16;
    } else {
        left = result.x + result.width;
    }
    if (top > ie.y) {
        top = ie.y - Calendar.height;
        left += 20;
    } else {
        top = result.y + result.height;
    }

    uiGet('uiCalendar').style.top = top + "px";
    uiGet('uiCalendar').style.left = left + "px";
}
//-----------------------------------------------------------
// 名    称:  uiCalendar_Close
// 描    述:  关闭日历
//-----------------------------------------------------------
function uiCalendar_Close() {
    if (uiGet('uiCalendar') != null) {
        document.body.removeChild(uiGet('uiCalendar'));
    }
}
//-----------------------------------------------------------
// 名    称:  uiGetCalendar_DayName
// 描    述:  默认输出天
//-----------------------------------------------------------
function uiGetCalendar_DayName() {
    var mDay;
    var sbl = "";
    sbl += '<tr>';
    for (wd = 0; wd < 7; wd++) {
        mDay = wd + w_StartOfWeek;

        if (mDay > 6) mDay = mDay - 7;
        sbl += '<td class="wd">' + w_dayname[mDay] + '</td>';

        // 设置星期结束位置
        if (w_dayname[mDay] == '六') weekend_pos[0] = wd;
        if (w_dayname[mDay] == '日') weekend_pos[1] = wd;

    }
    sbl += '</tr>';
    return sbl;
}
//-----------------------------------------------------------
// 名    称:  InitCalendar
// 描    述:  默认输出日历
//-----------------------------------------------------------
function InitCalendar() {
    uiCalendar_Close();
    var sbl = "";
    var div = document.createElement("div");
    div.id = "uiCalendar";
    div.className = "calendar";
    sbl += '<table class="calendar" >';
    sbl += '<tr><td colspan="8">';
    //列头
    sbl += '<table width="100%" cellpading="0" cellspacing="0">';
    sbl += '<tr class="firstrow">';
    sbl += '<td width="40px"  align="center" ><input type="button" value="&lt;&lt;" onClick="uiGetCalendar_Month(-1);" style="width:20px; height:20px"/><input type="button" value="&lt;" onClick="uiGetCalendar_Year(-1);" style="width:20px; height:20px"/></td>';
    sbl += '<td colspan="4" id="w_month_year" align="center">';
    sbl += '<select id="w_sel_month">';
    for (im = 0; im < 12; im++) {
        sbl += '<option value="' + im + '" ' + ((im == w_d.getMonth()) ? 'selected ': '') + '>' + w_monthname[im] + '</option>';
    }
    sbl += '</select>';
    sbl += ' ';
    sbl += '<select id="w_sel_year">';
    for (im = w_min_year; im <= w_max_year; im++) {
        sbl += '<option value="' + im + '" ' + ((im == w_d.getFullYear()) ? 'selected ': '') + '>' + im + '</option>';
    }
    sbl += '</select>';
    sbl += '</td>';
    sbl += '<td width="40px"  align="center"  ><input type="button" value="&gt;" onClick="uiGetCalendar_Year(1);" style="width:20px; height:20px"/><input type="button" value="&gt;&gt;" onClick="uiGetCalendar_Month(1);" style="width:20px; height:20px"/></td>';
    sbl += '<td align="center"><input type="button" value="×" onClick="uiCalendar_Close()" style="width:20px; height:20px"/></td>';
    sbl += '</tr>';
    sbl += '</table>';

    sbl += '</td></tr>';
    //星期头
    sbl += uiGetCalendar_DayName();
    //天
    for (i = 0; i < 6; i++) {
        sbl += '  <tr>';
        for (j = 0; j < 7; j++) {
            sbl += '<td  class="day_out" id="w_c' + i + j + '">&nbsp;</td>';
        }
        sbl += '  </tr>';
    }

    if (w_args == "yyyy-mm-dd hh:mm:ss") {
        sbl += '  <tr>';
        sbl += ' <td colspan="7">';
        //小时
        sbl += '&nbsp;时：<select id="w_sel_HH">';
        for (im = 0; im <= 23; im++) {
            if (w_d.getHours() == im) {
                sbl += '<option value=' + im + ' selected>' + im + '</option>';
            } else {
                sbl += '<option value=' + im + '>' + im + '</option>';
            }
        }
        sbl += '</select>';
        //分钟
        sbl += '&nbsp;分：<select id="w_sel_mm">';
        for (im = 0; im <= 59; im++) {
            if (w_d.getMinutes() == im) {
                sbl += '<option value=' + im + ' selected>' + im + '</option>';
            } else {
                sbl += '<option value=' + im + '>' + im + '</option>';
            }
        }
        sbl += '</select>';
        //秒
        sbl += '&nbsp;秒：<select id="w_sel_ss">';
        for (im = 0; im <= 59; im++) {
            if (w_d.getSeconds() == im) {
                sbl += '<option value=' + im + ' selected>' + im + '</option>';
            } else {
                sbl += '<option value=' + im + '>' + im + '</option>';
            }
        }
        sbl += '</select>';
        sbl += ' </td>';
        sbl += '  </tr>';
    }
    sbl += '  <tr>';
    sbl += ' <td colspan="7" align="right">';
    sbl += '<input name="button" type="button" value="清空" onclick="uiCalendarClear()" style="width:50px; height:20px"/>';
    sbl += '&nbsp;';
    sbl += '<input name="button2" type="button" value="今天" onclick="uiCalendarToDay()" style="width:50px; height:20px"/>';
    sbl += ' </td>';
    sbl += '  </tr>';
    sbl += '</table>';
    div.innerHTML = sbl;
    document.body.appendChild(div);
}
//-----------------------------------------------------------
// 名    称:  uiCalendarClear
// 描    述:  清空日历
//-----------------------------------------------------------
function uiCalendarClear() {
    var text = uiGet(w_linkedInputText);
    if (text != null) {
        text.value = "";
        uiCalendar_Close();
    }
}
//-----------------------------------------------------------
// 名    称:  uiCalendarToDay
// 描    述:  今天时间
//-----------------------------------------------------------
function uiCalendarToDay() {
    var text = uiGet(w_linkedInputText);
    if (text != null) {
        w_d = new Date();

        var m = "";
        var g = "";
        var mMonth;
        var mDay;

        mMonth = (w_d.getMonth() + 1);
        mDay = w_d.getDate();

        if (mMonth < 10) m = "0" + mMonth
        else m = mMonth

        if (mDay < 10) g = "0" + mDay
        else g = mDay

        var s = w_d.getFullYear() + "-" + m + "-" + g;

        if (w_args == "yyyy-mm-dd hh:mm:ss") {
            var HH = "";
            var mm = "";
            var ss = "";
            HH = w_d.getHours() < 10 ? "0" + w_d.getHours() : w_d.getHours();
            mm = w_d.getMinutes() < 10 ? "0" + w_d.getMinutes() : w_d.getMinutes();
            ss = w_d.getSeconds() < 10 ? "0" + w_d.getSeconds() : w_d.getSeconds();
            s += " " + HH + ":" + mm + ":" + ss;
        }
        // 设置对象值
        try {
            text.value = s;
            var fun= uiGet(w_linkedInputText).getAttribute("onchange");
            if (fun!=null) eval(fun);
            uiGet(w_linkedInputText).onchange();
        } catch(e) {}
        uiCalendar_Close();
    }
}
