﻿//-----------------------------------------------------------
// 文件名称: Web25175_Hotel2.v1.1.js
// 页面名称: Web25175_Hotel2.v1.1
//　
// 描    述: 核心
// 版　　本: 1.1
// 兼容情况: IE6+,Chrome,Mozilla, Netscape, Firefox,Maxthon3+,
// 创建标识: Add By 吴希 2011-10-26
//------------------------------------------------------------------------------------------
// 2013/04/12 Id$WuXi 更新日志： 1、setCookie
//                               2、getCookie
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
// 2013/02/19 Id$WuXi 更新日志： 1、Array.prototype.contains
//                               2、Array.prototype.indexOf
//                               3、Array.prototype.remove
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
// 2012/05/21 Id$WuXi 更新日志： 1、uiChangeDateTime 时间转化yyyy-MM-dd HH:mm:ss
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
// 2012/04/07 Id$WuXi 更新日志： 1、uiScrollLoad 修复兼容、除去时间
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
// 2012/03/29 Id$WuXi 更新日志： 1、uiScrollLoad 图片滚动加载
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
// 2012/03/01 Id$WuXi 更新日志： 1、uiCopyClipboard 复制到剪贴板
//------------------------------------------------------------------------------------------
// 2012/02/11 Id$WuXi 更新日志： 1、uiSetMaskSize 修复无法遮罩全部文档
//------------------------------------------------------------------------------------------
// 2011/12/26 Id$WuXi 更新日志： 1、uiGetIFrameDocument 获取框架文档
//------------------------------------------------------------------------------------------
// 2011/12/23 Id$WuXi 更新日志： 1、uiCloneTable 克隆表
//                               2、uiScrollLeft、uiScrollTop elementT2滚动设置 elementT1 滚动
//                               3、uiOffset elementT2的位置设置做原点 elementT1相对elementT2的位置
//                               4、uiFixTable HTML表格加固列、行
//------------------------------------------------------------------------------------------
// 2011/12/20 Id$WuXi 更新日志： 1、uiWindow 修复无法ie6下有时候无法关闭
//------------------------------------------------------------------------------------------
// 2011/12/10 Id$WuXi 更新日志： 1、uiCreateMask 内植空框架,显示层次9998
//                               2、uiWindow 浮动层，显示层次9999
//------------------------------------------------------------------------------------------
// 2011/12/06 Id$WuXi 更新日志： 1、uiAddFavorite 加入收藏
//                               2、uiSetHomePage 设置首页
//------------------------------------------------------------------------------------------
// 2011/11/30 Id$WuXi 更新日志： 1、uiGetBrowserSize 获取浏览器窗口大小
//                               2、uiGetScrollSize 获取文档滚动高度、宽度
//------------------------------------------------------------------------------------------
var readyfun = new Array();
//-----------------------------------------------------------
// 名    称: uiGet
// 描    述: 获取元素
//-----------------------------------------------------------
function uiGet(elementId) {
    if (document.getElementById) {
        return document.getElementById(elementId);
    } else if (document.all) {
        return document.all[elementId];
    } else return null;
}
//-----------------------------------------------------------
// 名    称: uiGetTag
// 描    述: 获取标签集
//-----------------------------------------------------------
function uiGetTag(element, tagName) {
    if (element && tagName) {
        if (element.getElementsByTagName) {
            return element.getElementsByTagName(tagName);
        }
        if (element.all && element.all.tags) {
            return element.all.tags(tagName);
        }
    }
    return null;
}
//-----------------------------------------------------------
// 名    称: uiIsIE
// 描    述: 判断是否IE
//-----------------------------------------------------------
function uiIsIE() {
//    var nonMSDOMBrowser=(window.navigator.appName.toLowerCase().indexOf('explorer') == -1)
    if (window.ActiveXObject) {
        return true;
    }
    return false;
}
//-----------------------------------------------------------
// 名    称: uiInit
// 描    述: 加载初始化
//-----------------------------------------------------------
function uiInit() {
    document.onreadystatechange = function() {
        if (document.readyState == "complete") {
            for (i = 0; i < readyfun.length; i++) {
                if (typeof(readyfun[i]) == "function") {
                    readyfun[i]();
                }
            }
        }
    }
}; (function() {
    uiInit()
})();
//-----------------------------------------------------------
// 名    称: uiReady
// 描    述: 准备加载
//-----------------------------------------------------------
function uiReady(fun) {
    readyfun.push(fun);
}
//-----------------------------------------------------------
// 名    称: uiGetPosition
// 描    述: 获取元素大小高度位置
//-----------------------------------------------------------
function uiGetPos(element) {
   return uiGetPosition(element);
}
function uiGetPosition(element) {
    var result = new Object();
    result.x = 0;
    result.y = 0;
    result.width = 0;
    result.height = 0;
    if (element.offsetParent) {
        result.x = element.offsetLeft;
        result.y = element.offsetTop;
        var parent = element.offsetParent;
        while (parent) {
            result.x += parent.offsetLeft;
            result.y += parent.offsetTop;
            var parentTagName = parent.tagName.toLowerCase();
            if (parentTagName != "table" && parentTagName != "body" && parentTagName != "html" && parentTagName != "div" && parent.clientTop && parent.clientLeft) {
                result.x += parent.clientLeft;
                result.y += parent.clientTop;
            }
            parent = parent.offsetParent;
        }
    } else if (element.left && element.top) {
        result.x = element.left;
        result.y = element.top;
    } else {
        if (element.x) {
            result.x = element.x;
        }
        if (element.y) {
            result.y = element.y;
        }
    }
    if (element.offsetWidth && element.offsetHeight) {
        result.width = element.offsetWidth;
        result.height = element.offsetHeight;
    } else if (element.style && element.style.pixelWidth && element.style.pixelHeight) {
        result.width = element.style.pixelWidth;
        result.height = element.style.pixelHeight;
    }
    return result;
}
//-----------------------------------------------------------
// 名    称: uiGetBrowserSize
// 描    述: 获取浏览器窗口大小
//-----------------------------------------------------------
function uiGetBrowserSize() {
    var result = new Object();
    result.x = 0;
    result.y = 0;
    //获取窗口宽度
    if (window.innerWidth) result.x = window.innerWidth;
    else if ((document.body) && (document.body.clientWidth)) result.x = document.body.clientWidth;
    //获取窗口高度
    if (window.innerHeight) winHeight = window.innerHeight;
    else if ((document.body) && (document.body.clientHeight)) result.y = document.body.clientHeight;
    //通过深入Document内部对body进行检测，获取窗口大小
    if (document.documentElement && document.documentElement.clientHeight && document.documentElement.clientWidth) {
        result.y = document.documentElement.clientHeight;
        result.x = document.documentElement.clientWidth;
    }
    return result;
}
//-----------------------------------------------------------
// 名    称: uiGetScrollSize
// 描    述: 获取文档滚动高度、宽度
//-----------------------------------------------------------
function uiGetScrollSize() {
    var result = new Object();
    result.x = 0;
    result.y = 0;
    if (!uiIsIE()) {
        result.x = window.pageXOffset;
        result.y = window.pageYOffset;
    } else {
        if (document.documentElement && document.documentElement.scrollLeft) {
            result.x = document.documentElement.scrollLeft;
            result.y = document.documentElement.scrollTop;
        } else if (document.body) {
            result.x = document.body.scrollLeft;
            result.y = document.body.scrollTop;
        }
    }
    return result;
}
//-----------------------------------------------------------
// 名    称: uiInsertAfter
// 描    述: 将一个新元素插入另一个元素前面 
//-----------------------------------------------------------
function uiInsertBefore(elementT1, elementT2) {
    var parent = elementT1.parentNode;
    parent.insertBefore(elementT2, elementT1);
}
//-----------------------------------------------------------
// 名    称: uiInsertAfter
// 描    述: 将一个新元素插入另一个元素后面 
//-----------------------------------------------------------
function uiInsertAfter(elementT1, elementT2) {
    var parent = elementT1.parentNode;
    if (parent.lastChild == elementT1) {
        parent.appendChild(elementT2);
    } else {
        parent.insertBefore(elementT2, elementT1.nextSibling);
    }
}
//-----------------------------------------------------------
// 名    称: uiSetHide
// 描    述: 对元素隐藏
//-----------------------------------------------------------
function uiSetHide(element) {
    element.style.visibility = "hidden";
}
//-----------------------------------------------------------
// 名    称: uiSetTagHide
// 描    述: 对标签隐藏
//-----------------------------------------------------------
function uiSetTagHide(tagName) {
    var control = uiGetTag(document, tagName);
    for (var j = 0; j < control.length; j++) {
        control[j].style.visibility = "hidden";
    }
}
//-----------------------------------------------------------
// 名    称: uiSetShow
// 描    述: 对元素显示
//-----------------------------------------------------------
function uiSetShow(element) {
    element.style.visibility = "visible"
}
//-----------------------------------------------------------
// 名    称: uiSetTagShow
// 描    述: 对标签显示
//-----------------------------------------------------------
function uiSetTagShow(tagName) {
    var control = uiGetTag(document, tagName);
    for (var j = 0; j < control.length; j++) {
        control[j].style.visibility = "visible";
    }
}
//-----------------------------------------------------------
// 名    称: uiCreateMask
// 描    述: 创建遮罩层
//-----------------------------------------------------------
function uiCreateMask() {
    var div = document.createElement("div");
    div.id = "MaskLayer";
    with(div.style) {
        position = 'absolute';
        background = '#F3F2EB';
        left = '0px';
        top = '0px';
        zIndex = 9998;
        if (uiIsIE()) { //IE+
            filter = "Alpha(Opacity=60)";
        } else { //Mozilla, Netscape, Firefox 
            opacity = 0.6;
        }
    }
    var iframe = " <iframe";
    iframe += " id='MaskLayeriframe' frameborder=\"0\"> ";
    iframe += " </iframe>";
    div.innerHTML=iframe;
    document.body.appendChild(div);
}
//-----------------------------------------------------------
// 名    称: uiSetMaskSize
// 描    述: 遮罩层大小
//-----------------------------------------------------------
function uiSetMaskSize(element) {
    var Height = parseInt(document.documentElement.scrollHeight,10);
    var Width = parseInt(document.documentElement.scrollWidth, 10);
    element.style.top = 0 + "px";
    element.style.left = 0 + "px";
    element.style.width = Width + "px";
    element.style.height = Height + "px";
}
//-----------------------------------------------------------
// 名    称: uiSetCenter
// 描    述: 元素居中
//-----------------------------------------------------------
function uiSetCenter(element) {
    var Height = parseInt(document.documentElement.clientHeight, 10) / 2 - parseInt(element.style.height, 10) / 2;
    var Top = parseInt(document.documentElement.scrollTop, 10) + parseInt(document.body.clientTop, 10) + Height;
    var Width = parseInt(document.documentElement.clientWidth, 10) / 2 - parseInt(element.style.width, 10) / 2;
    //顶部自识
    Top = Top < 0 ? 10 : Top;
    element.style.top = Top + "px";
    element.style.left = Width + "px";
    if (parseInt(element.style.left, 10) <= 0) {
        element.style.left = 0 + "px";
    }
}
//-----------------------------------------------------------
// 名    称: uiWindow
// 描    述: 浮动层
//-----------------------------------------------------------
function uiWindow(title, content, src, width, height, elementT1) {
    uiWindow_Close();
    var obj = null;
    var id = "DialogLayer";
    if (uiIsIE()) {
        element = document.createElement("<div name=\"" + id + "\" id=\"" + id + "\"></div>");
    } else {
        element = document.createElement("div");
        element.id = id;
        element.name = id;
    }
    if (src != null) {
        content = " <iframe ";
        content += " name=\"" + id + "iframe" + "\" ";
        content += " id=\"" + id + "iframe" + "\" ";
        content += " src=\"" + src + "\" ";
        content += " height=\"" + height + "\" ";
        content += " width=\"" + (width - 8) + "\" ";
        content += " frameborder=\"0\">";
        content += " </iframe>";
        content += " <div id='IframeMask' style='position:absolute;top:30px; left:4px;height:" + height + "px;width:" + (width - 8) + "px;z-index:100;background-color:#f5fbff'>";
        content += " </div>";
        content += " <div id='IframeLoad' style='position:absolute;top:30px; left:4px;height:" + height + "px;width:" + (width - 8) + "px;z-index:100;background-color:#f5fbff'>";
        content += '<table width="' + (width - 8) + 'px" border="0" cellspacing="0" cellpadding="0" height="' + height + 'px">';
        content += ' <tr>';
        content += '   <td valign="middle">';
        content += '     <table width="100%"  border="0" cellpadding="5" cellspacing="0">';
        content += '        <tr>';
        content += '          <td align="center">';
        content += '<div class="uiWindow_Load"></div>';
        content += '          </td>';
        content += '        </tr>';
        content += '      </table>';
        content += '	</td>';
        content += '  </tr>';
        content += '</table>';
        content += " </div>";
    } else {
        content = "<div  width=\"" + (width - 8) + "\" height=\"" + height + "\">" + content + "</div>"
    }
    //内容构造
    var sbl = "";
    sbl += "<table width=\"" + width + "\" height=\"" + height + "\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
    sbl += "  <tr id=\"DialogTitle\">";
    sbl += "    <td class=\"uiWindow_top_1\"></td>";
    sbl += "    <td class=\"uiWindow_top_2\"><span class=\"uiWindow_title\">" + title + "</span></td>";
    sbl += "    <td class=\"uiWindow_top_3\"><span class=\"uiWindow_close\" onclick=\"uiWindow_Close()\"></span></td>";
    sbl += "  </tr>";
    sbl += "  <tr>";
    sbl += "    <td class=\"uiWindow_left_2\" height=\"" + height + "\"></td>";
    sbl += "    <td class=\"uiWindow_content\" width=\"" + (width - 8) + "\" valign=\"top\">" + content + "</td>";
    sbl += "    <td class=\"uiWindow_right_2\" height=\"" + height + "\"></td>";
    sbl += "  </tr>";
    sbl += "  <tr>";
    sbl += "    <td class=\"uiWindow_bottom_1\"></td>";
    sbl += "    <td class=\"uiWindow_bottom_2\"></td>";
    sbl += "    <td class=\"uiWindow_bottom_3\"></td>";
    sbl += "  </tr>";
    sbl += "</table>"

    element.innerHTML = sbl;
    element.style.backgroundColor = "#ffffff";
    element.style.position = "absolute";
    element.style.width = "" + width + "px";
    element.style.height = "" + height + "px";
    element.style.zIndex = 9999;
    
    uiCreateMask();
    uiSetMaskSize(uiGet("MaskLayer"));
    uiSetMaskSize(uiGet("MaskLayeriframe"));
    document.body.appendChild(element);

    if (uiGet(id + "iframe") != null) {
        var iframe = " <iframe";
        iframe += " height=\"" + height + "px\" ";
        iframe += " width=\"" + (width - 8) + "px\">";
        iframe += " </iframe>";
        uiGet("IframeMask").innerHTML = iframe;
        if (uiIsIE()) {
            uiGet(id + "iframe").onreadystatechange = function() {
                if (uiGet(id + "iframe").readyState == "complete") {
                    uiGet('IframeLoad').style.visibility = 'hidden';
                    uiGet("IframeMask").style.visibility = 'hidden';
                }
            }
        } else {
            uiGet(id + "iframe").onload = function() {
                uiGet('IframeLoad').style.visibility = 'hidden';
                uiGet("IframeMask").style.visibility = 'hidden';
            }
        }
    }
    if (elementT1 != null) {
        var result = uiGetPosition(elementT1);
        element.style.top = result.y + result.height + "px";
        element.style.left = result.x + result.width + "px";
    } else {
        uiSetCenter(element);
    }
    uiSetTagHide("select");
    uiDrag(uiGet("DialogTitle"), uiGet("DialogLayer"), uiGet("DialogLayeriframe"));
    if (elementT1 == null) {
        window.onresize = function() {
            uiSetCenter(uiGet("DialogLayer"));
            uiSetMaskSize(uiGet("MaskLayer"));
            uiSetMaskSize(uiGet("MaskLayeriframe"));
        }
    } else {
        window.onresize = null;
    }
}
//-----------------------------------------------------------
// 名    称: uiWindow_Close
// 描    述: 浮动层关闭
//-----------------------------------------------------------
function uiWindow_Close() {
    var Dialog = uiGet("DialogLayer");
    if (Dialog != null) {
        if (uiGet("DialogLayeriframe") != null) {
            uiGet("DialogLayeriframe").onreadystatechange = null;
        }
        document.body.removeChild(Dialog);
    }
    var Mask = uiGet("MaskLayer");
    if (Mask != null) {
        document.body.removeChild(Mask);
    }
    uiSetTagShow("select");
    window.onresize = null;
}
//-----------------------------------------------------------
// 名    称: uiDrag
// 描    述: 拖动元素
//-----------------------------------------------------------
function uiGetX(element) {
    element = element || window.event;
    return element.pageX ? element.pageX: (element.clientX + document.documentElement.scrollLeft);
}
function uiGetY(element) {
    element = element || window.event;
    return element.pageY ? element.pageY: (element.clientY + document.documentElement.scrollTop);
}
function uiGapsX(element) {
    return ! element.offsetParent ? element.offsetLeft: (element.offsetLeft + uiGapsX(element.offsetParent));
}
function uiGapsY(element) {
    return ! element.offsetParent ? element.offsetTop: (element.offsetTop + uiGapsY(element.offsetParent));
}
function uiDrag(elementT1, elementT2, elementT3) {
    elementT1.onmousedown = function(e1) {
        if (elementT1.setCapture) {
            elementT1.setCapture();
        } else if (window.captureEvents) {
            window.captureEvents(Event.MOUSEMOVE | Event.MOUSEUP);
        }
        var x = uiGetX(e1) - uiGapsX(elementT1);
        var y = uiGetY(e1) - uiGapsY(elementT1);
        document.onmousemove = function(e2) {
            elementT2.style.left = uiGetX(e2) - x + 'px';
            elementT2.style.top = uiGetY(e2) - y + 'px';
            if (parseInt(elementT2.style.top, 10) <= 0) {
                elementT2.style.top = 0 + "px";
            }
            if (parseInt(elementT2.style.left, 10) <= 0) {
                elementT2.style.left = 0 + "px";
            }
        }
        if (elementT3 != null) {
            //uiSetHide(elementT3);
            if (uiGet('IframeMask') != null) {
                with(uiGet('IframeMask').style) {
                    visibility = 'visible';
                    if (uiIsIE()) { //IE+
                        filter = "Alpha(Opacity=60)";
                    } else { //Mozilla, Netscape, Firefox 
                        opacity = 0.6;
                    }
                }
            }
            if (uiGet('IframeLoad') != null) {
                with(uiGet('IframeLoad').style) {
                    visibility = 'visible';
                    if (uiIsIE()) { //IE+
                        filter = "Alpha(Opacity=60)";
                    } else { //Mozilla, Netscape, Firefox 
                        opacity = 0.6;
                    }
                }
            }
        }
    }
    elementT1.onmouseup = function() {
        if (elementT1.releaseCapture) {
            elementT1.releaseCapture();
        } else if (window.captureEvents) {
            window.captureEvents(Event.MOUSEMOVE | Event.MOUSEUP);
        }
        document.onmousedown = null;
        document.onmousemove = null;
        document.onmouseup = null;
        if (elementT3 != null) {
            //uiSetShow(elementT3);
            if (uiGet('IframeMask') != null) {
                with(uiGet('IframeMask').style) {
                    visibility = 'hidden';
                }
            }
            if (uiGet('IframeLoad') != null) {
                with(uiGet('IframeLoad').style) {
                    visibility = 'hidden';
                }
            }
        }
    }
}
//-----------------------------------------------------------
// 名    称: CloneTable
// 描    述: 克隆表
//-----------------------------------------------------------
function uiCloneTable(elementT1) {
    var table = document.createElement("table");
    table = elementT1.cloneNode(true);
    return table;
}
//-----------------------------------------------------------
// 名    称: uiScrollLeft、uiScrollTop
// 描    述: elementT2滚动设置 elementT1 滚动
//-----------------------------------------------------------
function uiScrollLeft(elementT1, elementT2) {
    elementT1.scrollLeft = elementT2.scrollLeft;
}
function uiScrollTop(elementT1, elementT2) {
    elementT1.scrollTop = elementT2.scrollTop;
}
//-----------------------------------------------------------
// 名    称: uiOffset
// 描    述: elementT2的位置设置做原点 elementT1相对elementT2的位置
//-----------------------------------------------------------
function uiOffset(elementT1, elementT2) {
    var T1 = uiGetPosition(elementT1);
    var T2 = uiGetPosition(elementT2);

    elementT1.style.top = T2.y  + "px";
    elementT1.style.left = T2.x + "px";
}
//-----------------------------------------------------------
// 名    称: uiFixTable
// 描    述: HTML表格加固列、行
//-----------------------------------------------------------
function uiFixTable(TableID, FixColumnNumber, FixRowNumber, otherheight, height, width) {
    var obj = uiGet(TableID);
    if (obj == null) {
        return;
    }
    var tableLayout = uiGet(TableID + "_tableLayout");
    if (tableLayout == null) {
        if (height == null) {
            height = uiGetBrowserSize().y - uiGetPosition(obj).y - otherheight;
        }
        if (width == null) {
            width = uiGetBrowserSize().x - uiGetPosition(obj).x;
        }
        tableLayout = document.createElement("div");
        tableLayout.id = TableID + "_tableLayout";
        tableLayout.style.overflow = "hidden";
        tableLayout.style.height = height + "px";
        tableLayout.style.width = width + "px";

        var table = '<div id="' + TableID + '_tableFix"></div>';
        table += '<div id="' + TableID + '_tableHead"></div>';
        table += '<div id="' + TableID + '_tableColumn"></div>';
        table += '<div id="' + TableID + '_tableData"></div>';

        tableLayout.innerHTML = table;

        if (uiGet(TableID) != null) {
            uiInsertAfter(uiGet(TableID), tableLayout);
        }

        var tableFixClone = uiCloneTable(obj);
        tableFixClone.id = TableID + "_tableFixClone";
        tableFixClone.style.margin = "0px";
        uiGet(TableID + "_tableFix").appendChild(tableFixClone);

        var tableHeadClone = uiCloneTable(obj);
        tableHeadClone.id = TableID + "_tableHeadClone";
        tableHeadClone.style.margin = "0px";
        uiGet(TableID + "_tableHead").appendChild(tableHeadClone);

        var tableColumnClone = uiCloneTable(obj);
        tableColumnClone.id = TableID + "_tableColumnClone";
        tableColumnClone.style.margin = "0px";
        uiGet(TableID + "_tableColumn").appendChild(tableColumnClone);

        uiGet(TableID + "_tableData").appendChild(obj);
        obj.style.margin = "0px";

        if (true) {
            if (true) {
                var checkboxs = tableFixClone.getElementsByTagName("input");
                for (i = 0; i < checkboxs.length; i++) {
                    if (checkboxs[i].getAttribute("type") == "checkbox") {
                        if (checkboxs[i].id != null) {
                            checkboxs[i].id = tableFixClone.id + "_checkbox" + i;
                        }
                    }
                }
            }
            if (true) {
                var checkboxs = tableHeadClone.getElementsByTagName("input");
                for (i = 0; i < checkboxs.length; i++) {
                    if (checkboxs[i].getAttribute("type") == "checkbox") {
                        checkboxs[i].id = tableHeadClone.id + "_checkbox" + i;
                    }
                }
            }
            if (true) {
                var checkboxs = obj.getElementsByTagName("input");
                for (i = 0; i < checkboxs.length; i++) {
                    if (checkboxs[i].getAttribute("type") == "checkbox") {
                        checkboxs[i].id = obj.id + "_checkbox" + i;
                    }
                }
            }
            if (true) {
                try {
                    var tableFix = uiGet(TableID + "_tableFix");
                    tableFix.style.overflow = 'hidden';
                    tableFix.style.position = 'absolute';
                    tableFix.style.zIndex = 50;
                    tableFix.style.backgroundColor = 'Silver';

                    var tableHead = uiGet(TableID + "_tableHead");
                    tableHead.style.overflow = 'hidden';
                    tableHead.style.position = 'absolute';
                    tableHead.style.width = width - 17 + "px";
                    tableHead.style.zIndex = 45;
                    tableHead.style.backgroundColor = 'Silver';

                    var tableColumn = uiGet(TableID + "_tableColumn");
                    tableColumn.style.overflow = 'hidden';
                    tableColumn.style.position = 'absolute';
                    tableColumn.style.height = height - 17 + "px";
                    tableColumn.style.zIndex = 40;
                    tableColumn.style.backgroundColor = 'Silver';

                    var tableData = uiGet(TableID + "_tableData");
                    tableData.style.overflow = 'scroll';
                    tableData.style.position = 'absolute';
                    tableData.style.width = width + "px";
                    tableData.style.height = height + "px";
                    tableData.style.zIndex = 35;
                } catch(e) {}
            }
            if (true) {
                var HeadHeight = 0;
                //重新定位 高度 tableFix、tableHead
                if (true) {
                    HeadHeight = 0;
                    for (i = 0; i < FixRowNumber; i++) {
                        HeadHeight += uiGetPosition(obj.rows[i]).height;
                    }
                    uiGet(TableID + "_tableFix").style.height = HeadHeight + "px";
                    uiGet(TableID + "_tableHead").style.height = HeadHeight + "px";
                }
                //重新定位 宽度 tableColumn
                var ColumnsWidth = 0;
                if (true) {
                    ColumnsWidth = 0;
                    for (i = 0; i < FixColumnNumber; i++) {
                        ColumnsWidth += uiGetPosition(obj.rows[0].cells[i]).width;
                    }
                    uiGet(TableID + "_tableColumn").style.width = ColumnsWidth + "px";
                    uiGet(TableID + "_tableFix").style.width = ColumnsWidth + "px";
                }
            }
            uiGet(TableID + "_tableData").onscroll = function() {
                uiScrollLeft(uiGet(TableID + "_tableHead"), uiGet(TableID + "_tableData"));
                uiScrollTop(uiGet(TableID + "_tableColumn"), uiGet(TableID + "_tableData"));
            }

            //重新定位 滚动条 tableFix、tableHead
            if (true) {
                if (uiGetPosition(uiGet(TableID + "_tableHead")).width > uiGetPosition(uiGet(TableID + "_tableFixClone")).width) {
                    uiGet(TableID + "_tableHead").style.width = uiGetPosition(uiGet(TableID + "_tableFixClone")).width + "px";
                    uiGet(TableID + "_tableData").style.width = uiGetPosition(uiGet(TableID + "_tableFixClone")).width + 17 + "px";
                }
                if (uiGetPosition(uiGet(TableID + "_tableColumn")).height > uiGetPosition(uiGet(TableID + "_tableColumnClone")).height) {
                    uiGet(TableID + "_tableColumn").style.height = uiGetPosition(uiGet(TableID + "_tableColumnClone")).height + "px";
                    uiGet(TableID + "_tableData").style.height = uiGetPosition(uiGet(TableID + "_tableColumnClone")).height + 17 + "px";
                }
            }
            //重新定位 高度 tableFix、tableHead
            if (true) {
                var HeadHeight = 0;
                for (i = 0; i < FixRowNumber; i++) {
                    HeadHeight += uiGetPosition(obj.rows[i]).height;
                }
                uiGet(TableID + "_tableFix").style.height = HeadHeight + "px";
                uiGet(TableID + "_tableHead").style.height = HeadHeight + "px";
            }
            //重新定位 宽度 tableColumn
            if (true) {
                var ColumnsWidth = 0;
                for (i = 0; i < FixColumnNumber; i++) {
                    ColumnsWidth += uiGetPosition(obj.rows[0].cells[i]).width;
                }
                uiGet(TableID + "_tableColumn").style.width = ColumnsWidth + "px";
            }
            if (true) {
                uiOffset(uiGet(TableID + "_tableFix"), uiGet(TableID + "_tableLayout"));
                uiOffset(uiGet(TableID + "_tableHead"), uiGet(TableID + "_tableLayout"));
                uiOffset(uiGet(TableID + "_tableColumn"), uiGet(TableID + "_tableLayout"));
                uiOffset(uiGet(TableID + "_tableData"), uiGet(TableID + "_tableLayout"));
            }
        }
    } else {
        if (height == null) {
            height = uiGetBrowserSize().y - uiGetPosition(tableLayout).y - otherheight;
        }
        if (width == null) {
            width = uiGetBrowserSize().x - uiGetPosition(tableLayout).x;
        }
        tableLayout.style.height = height + "px";
        tableLayout.style.width = width + "px";
        if (true) {
            try {

                if (uiGetPosition(uiGet(TableID + "_tableHead")).width > uiGetPosition(uiGet(TableID + "_tableFixClone")).width) {
                    uiGet(TableID + "_tableHead").style.width = uiGetPosition(uiGet(TableID + "_tableFixClone")).width + "px";
                    uiGet(TableID + "_tableData").style.width = uiGetPosition(uiGet(TableID + "_tableFixClone")).width + 17 + "px";
                } else {
                    uiGet(TableID + "_tableHead").style.width = width - 17 + "px";
                    uiGet(TableID + "_tableData").style.width = width + "px";
                }

                if (uiGetPosition(uiGet(TableID + "_tableColumn")).height > uiGetPosition(uiGet(TableID + "_tableColumnClone")).height) {
                    uiGet(TableID + "_tableColumn").style.height = uiGetPosition(uiGet(TableID + "_tableColumnClone")).height + "px";
                    uiGet(TableID + "_tableData").style.height = uiGetPosition(uiGet(TableID + "_tableColumnClone")).height + 17 + "px";
                } else {
                    uiGet(TableID + "_tableColumn").style.height = height - 17 + "px";
                    uiGet(TableID + "_tableData").style.height = height + "px";
                }

                if (true) {
                    uiOffset(uiGet(TableID + "_tableFix"), uiGet(TableID + "_tableLayout"));
                    uiOffset(uiGet(TableID + "_tableHead"), uiGet(TableID + "_tableLayout"));
                    uiOffset(uiGet(TableID + "_tableColumn"), uiGet(TableID + "_tableLayout"));
                    uiOffset(uiGet(TableID + "_tableData"), uiGet(TableID + "_tableLayout"));
                }

            } catch(e) {}
        }
    }
    //偏移计算
    var moveVal = 0;
    if (false) {
        uiGet(TableID + "_tableFix").style.left = moveVal + "px";
        uiGet(TableID + "_tableFix").style.width = uiGetPosition(uiGet(TableID + "_tableFix")).width - moveVal + "px";
        uiGet(TableID + "_tableFixClone").style.marginLeft = -moveVal + "px";

        uiGet(TableID + "_tableHead").style.left = moveVal + "px";
        uiGet(TableID + "_tableHead").style.width = uiGetPosition(uiGet(TableID + "_tableHead")).width - moveVal + "px";
        uiGet(TableID + "_tableHeadClone").style.marginLeft = -moveVal + "px";

        uiGet(TableID + "_tableColumn").style.left = moveVal + "px";
        uiGet(TableID + "_tableColumn").style.width = uiGetPosition(uiGet(TableID + "_tableColumn")).width - moveVal + "px";
        uiGet(TableID + "_tableColumnClone").style.marginLeft = -moveVal + "px";
    }
}
//-----------------------------------------------------------
// 名    称: uiGetIFrameDocument
// 描    述: 获取框架文档
//-----------------------------------------------------------
function uiGetIFrameDocument(element) {
    var doc = null;
    if (element.contentDocument) { // For NS6
        doc = element.contentDocument;
    } else if (element.contentWindow) { // For IE5.5 and IE6
        doc = element.contentWindow.document;
    } else if (element.document) { // For IE5
        doc = element.document;
    } else {
        return null;
    }
    return doc;
}
//-----------------------------------------------------------
// 名    称: doPostBack
// 描    述: 访问控件事件
//-----------------------------------------------------------
function uidoPostBack(eventTarget, eventArgument) {
    try {
        //alert(eventTarget + eventArgument);
        if (eventTarget == "btnBind" && eventArgument != null && eventArgument != "null" && (eventArgument.toLowerCase().indexOf("kd=") > -1 || eventArgument.toLowerCase().indexOf("jd=") > -1)) {
            if (confirm("确认要打印吗？")) {
            } else {
                eventTarget = "rptbtn";
                eventArgument = "";
            }
        }
        
            var theform;
            if (window.navigator.appName.toLowerCase().indexOf("netscape") > -1) {
                theform = document.forms[0];
            } else {
                theform = document.forms[0];
            }


                var obj_eventtarget = uiGet("__EVENTTARGET");
                if (obj_eventtarget == null) {
                    var eventTarget_ = null;
                    if (uiIsIE()) {
                        eventTarget_ = document.createElement("<input type='hidden' name='__EVENTTARGET' id='__EVENTTARGET>");
                    } else {
                        eventTarget_ = document.createElement("input");
                        eventTarget_.type = "hidden";
                        eventTarget_.id = "__EVENTTARGET";
                        eventTarget_.name = "__EVENTTARGET";
                    }
                    eventTarget_.value = eventTarget.split("$").join(":");
                    theform.appendChild(eventTarget_);
                } else {
                    obj_eventtarget.value = eventTarget.split("$").join(":");
                }
                var obj_eventargument = uiGet("__EVENTARGUMENT");
                if (obj_eventargument == null) {
                    var eventArgument_ = null;
                    if (uiIsIE()) {
                        eventArgument_ = document.createElement("<input type='hidden' name='__EVENTARGUMENT' id='__EVENTARGUMENT'>");
                    } else {
                        eventArgument_ = document.createElement("input");
                        eventArgument_.type = "hidden";
                        eventArgument_.id = "__EVENTARGUMENT";
                        eventArgument_.name = "__EVENTARGUMENT";
                    }
                    eventArgument_.value = eventArgument;
                    theform.appendChild(eventArgument_);
                } else {
                    obj_eventargument.value = eventArgument;
                }
                if ((typeof (theform.onsubmit) == "function")) {
                    if (theform.onsubmit() != false) {
                        theform.submit();
                    }
                } else {
                    theform.submit();
                }

    } catch(e) {
        window.alert(e);
    }
}
//-----------------------------------------------------------
// 名    称: Messagebox
// 描    述: 对话框
//-----------------------------------------------------------
function uiMessagebox(content, fun, index) {
    var sbl = "";
    sbl += "<div style=\"padding:10px;font-size:12px;padding-bottom:5px;\">";
    if (index == null) {
        sbl += "<div class='uiMessagebox_1'>" + content + "</div>";
    } else {
        sbl += "<div class='uiMessagebox_" + index + "'>" + content + "</div>";
    }
    sbl += "</div>";
    if (typeof(fun) == "function") {
        sbl += "<hr />";
        sbl += "<div style=\"text-align:right;padding-right:15px;\">";
        sbl += "<input id='uiMessagebox_Ok' type=\"button\" value=\"确定\"/>";
        sbl += "<input id='uiMessagebox_No' type=\"button\" value=\"取消\"  onclick=\"uiWindow_Close()\"/>";
        sbl += "</div>";
    } else {
        sbl += "<hr />";
        sbl += "<div style=\"text-align:right;padding-right:15px;\">";
        sbl += "<input id='uiMessagebox_Ok' type=\"button\" value=\"确定\"  onclick=\"uiWindow_Close()\"/>";
        sbl += "</div>";
    }
    uiWindow("提示", sbl, null, 300, 100);
    if (typeof(fun) == "function") {
        uiGet("uiMessagebox_Ok").onclick = fun;
    }
}
//-----------------------------------------------------------
// 名    称: uiScrollLoad
// 描    述: 图片滚动加载
//-----------------------------------------------------------
var uiScrollLoad = (function(options) {
    var defaults = (arguments.length == 0) ? {
        src: 'xSrc',
        time: 300
    }: {
        src: options.src || 'xSrc',
        time: options.time || 300
    };
    var camelize = function(s) {
        return s.replace(/-(\w)/g,
        function(strMatch, p1) {
            return p1.toUpperCase();
        });
    };
    this.getStyle = function(element, property) {
        if (arguments.length != 2) return false;
        var value = element.style[camelize(property)];
        if (!value) {
            if (document.defaultView && document.defaultView.getComputedStyle) {
                var css = document.defaultView.getComputedStyle(element, null);
                value = css ? css.getPropertyValue(property) : null;
            } else if (element.currentStyle) {
                value = element.currentStyle[camelize(property)];
            }
        }
        return value == 'auto' ? '': value;
    };
    var _init = function() {
        var offsetPage = window.pageYOffset ? window.pageYOffset: window.document.documentElement.scrollTop,
        offsetWindow = offsetPage + Number(window.innerHeight ? window.innerHeight: document.documentElement.clientHeight),
        docImg = uiGetTag(document,"img"),
        _len = docImg.length;
        if (!_len) return false;
        for (var i = 0; i < _len; i++) {
            var attrSrc = docImg[i].getAttribute(defaults.src),
            o = docImg[i],
            tag = o.nodeName.toLowerCase();
            if (o) {
                postPage = o.getBoundingClientRect().top + window.document.documentElement.scrollTop + window.document.body.scrollTop;
                postWindow = postPage + Number(this.getStyle(o, 'height').replace('px', ''));
                if ((postPage > offsetPage && postPage < offsetWindow) || (postWindow > offsetPage && postWindow < offsetWindow)) {
                    if (tag === "img" && attrSrc !== null) {
                        o.setAttribute("src", attrSrc);
                    }
                    o = null;
                }
            }
        };
        window.onscroll = function() {
            //setTimeout(function() {
                _init();
           // },
            //defaults.time);
        }
    };
    return _init();
});
//-----------------------------------------------------------
// 文    件: UnlyWu.ajax.v1.0.js
// 名    称: Ajax
// 描    述: 异步通信
//-----------------------------------------------------------
function uiGetRequest() {
    if (window.XMLHttpRequest) {
        return new XMLHttpRequest();
    } else {
        if (window.XMLHttpRequestProgID) {
            return new ActiveXObject(window.XMLHttpRequestProgID);
        } else {
            var progIDs = ["Msxml2.XMLHTTP.6.0", "Msxml2.XMLHTTP.5.0", "Msxml2.XMLHTTP.4.0", "MSXML2.XMLHTTP.3.0", "MSXML2.XMLHTTP", "Microsoft.XMLHTTP"];
            for (var i = 0; i < progIDs.length; ++i) {
                var progID = progIDs[i];
                try {
                    var x = new ActiveXObject(progID);
                    window.XMLHttpRequestProgID = progID;
                    return x;
                } catch(e) {}
            }
        }
    }
    return null;
}
function uiAjax(url, method, args, callback) {
    switch (method.toUpperCase()) {
    case "GET":
        uiAjaxGet(url, callback);
        break;
    case "POST":
        uiAjaxPost(url, args, callback);
        break;
    }
}
function uiAjaxGet(url, callback) {
    var req = uiGetRequest();
    req.open("GET", url, true);
    req.setRequestHeader("Accept-Encoding", "gzip, deflate");
    if (typeof(callback) == "function") {
        req.onreadystatechange = function() {
            if (req.readyState != 4) {
                return;
            }
            result = req.responseText;
            callback(result);
            req = null;
        }
    }
    req.send("");
}
function uiAjaxPost(url, args, callback) {
    var req = uiGetRequest();
    req.open("POST", url, true);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
    req.setRequestHeader("Accept-Encoding", "gzip, deflate");
    if (typeof(callback) == "function") {
        req.onreadystatechange = function() {
            if (req.readyState != 4) {
                return;
            }
            result = req.responseText;
            callback(result);
            req = null;
        }
    }
    req.send(args);
}
function uiAjaxSubmit(url, callback) {
    var args = "";
    var form = null;
    if (window.navigator.appName.toLowerCase().indexOf("netscape") > -1) {
        form = document.forms[0];
    } else {
        form = document.forms[0];
    }
    if (form != null) {
        for (var elementIndex = 0; elementIndex < form.length; ++elementIndex) {
            var element = form.elements[elementIndex];
            if (element.name) {
                var elementValue = null;
                if (element.nodeName.toUpperCase() == "INPUT") {
                    var inputType = element.getAttribute("type").toUpperCase();
                    if (inputType == "TEXT" || inputType == "PASSWORD" || inputType == "HIDDEN") {
                        elementValue = element.value;
                    } else if (inputType == "CHECKBOX" || inputType == "RADIO") {
                        if (element.checked) {
                            elementValue = element.value;
                        }
                    } else if (inputType == "FILE") {}
                } else if (element.nodeName.toUpperCase() == "SELECT") {
                    if (element.multiple) {
                        elementValue = [];
                        for (var i = 0; i < element.length; ++i) {
                            if (element.options[i].selected) {
                                elementValue.push(element.options[i].value);
                            }
                        }
                    } else if (element.length == 0) {
                        elementValue = null;
                    } else {
                        elementValue = element.value;
                    }
                } else if (element.nodeName.toUpperCase() == "TEXTAREA") {
                    elementValue = element.value;
                }
                if (elementValue instanceof Array) {
                    for (var i = 0; i < elementValue.length; ++i) {
                        args += "&" + element.name + "=" + uiUriEncode(elementValue[i]);
                    }
                } else if (elementValue != null) {
                    args += "&" + element.name + "=" + uiUriEncode(elementValue);
                }
            }
        }
    }
    if (args.length > 0) {
        args = args.substring(1);
        uiAjaxPost(url, args, callback);
    }
}
function uiUriEncode(s) {
    if (typeof encodeURIComponent == "function") {
        // 兼容 IE 5.5+ and Netscape 6+ and Mozilla
        return encodeURIComponent(s);
    } else {
        // 兼容 Netscape 4 and IE 4 and IE 5.0
        return uiencodeURIComponentNew(s);
    }
}
function uiencodeURIComponentNew(s) {
    var okURIchars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-";
    var s = uiUtf8(s);
    var c;
    var enc = "";
    for (var i = 0; i < s.length; i++) {
        if (okURIchars.indexOf(s.charAt(i)) == -1) enc += "%" + uiToHex(s.charCodeAt(i));
        else enc += s.charAt(i);
    }
    return enc;
}
function uiUtf8(wide) {
    var c, s;
    var enc = "";
    var i = 0;
    while (i < wide.length) {
        c = wide.charCodeAt(i++);
        // handle UTF-16 surrogates
        if (c >= 0xDC00 && c < 0xE000) continue;
        if (c >= 0xD800 && c < 0xDC00) {
            if (i >= wide.length) continue;
            s = wide.charCodeAt(i++);
            if (s < 0xDC00 || c >= 0xDE00) continue;
            c = ((c - 0xD800) << 10) + (s - 0xDC00) + 0x10000;
        }
        // 输出值
        if (c < 0x80) enc += String.fromCharCode(c);
        else if (c < 0x800) enc += String.fromCharCode(0xC0 + (c >> 6), 0x80 + (c & 0x3F));
        else if (c < 0x10000) enc += String.fromCharCode(0xE0 + (c >> 12), 0x80 + (c >> 6 & 0x3F), 0x80 + (c & 0x3F));
        else enc += String.fromCharCode(0xF0 + (c >> 18), 0x80 + (c >> 12 & 0x3F), 0x80 + (c >> 6 & 0x3F), 0x80 + (c & 0x3F));
    }
    return enc;
}
function uiToHex(n) {
    var hexchars = "0123456789ABCDEF";
    return hexchars.charAt(n >> 4) + hexchars.charAt(n & 0xF);
}
//-----------------------------------------------------------
// 文    件:UnlyWu.autocomplete.v1.0.js
// 名    称: AutoComplete
// 描    述: 自动完成提示
// 使用方式:
//
// <asp:TextBox ID="txt" runat="server" onkeyup='AutoComplete(event,this)'></asp:TextBox>
// function AutoComplete(event, obj) {
//      var value = escape(obj.value);
//      var url = "ServarPage.aspx?itemno=" + value + "&type=autocomplete";
//      uiAutoComplete(event, obj, url);
// }
//-----------------------------------------------------------
function uiAutoComplete(event, obj, url) {
    uiAutoComplete_Close();
    var keyCode = event.keyCode ? event.keyCode: event.which ? event.which: event.charCode;
    if (obj.value.trim() == "" || keyCode == 27 || keyCode == 13) {
        return;
    }
    if (keyCode == 38 || keyCode == 40) {} else {
        uiAjax(url + "&t=" + new Date() + "&control=" + obj.id, "get", "",
        function(e) {
            if (e.trim() == "") {
                uiAutoComplete_Close();
            } else {
                if (uiGet("Complete") != null) {
                    var div = uiGet("Complete");
                    var Width = obj.offsetWidth;
                    var Position = uiGetPosition(obj);
                    var Top = Position.y + obj.offsetHeight;
                    var styleStr = "";
                    styleStr = "left:" + Position.x + "px;";
                    styleStr += "top:" + Top + "px;position:absolute;width:" + Width + "px;";
                    div.style.cssText = styleStr;
                    div.innerHTML = e;
                } else {
                    var div = document.createElement("div");
                    div.id = "Complete";
                    div.className = "Complete";
                    var Width = obj.offsetWidth;
                    var Position = uiGetPosition(obj);
                    var Top = Position.y + obj.offsetHeight;
                    var styleStr = "";
                    styleStr = "left:" + Position.x + "px;";
                    styleStr += "top:" + Top + "px;position:absolute;width:" + Width + "px;";
                    div.style.cssText = styleStr;
                    div.innerHTML = e;
                    document.body.appendChild(div);
                }
            }
        })
    }
}
function uiAutoComplete_Close() {
    var div = uiGet("Complete");
    if (div != null) {
        document.body.removeChild(div)
    }
}
//-----------------------------------------------------------
// 名    称: uiSetRadioButtonListValue
// 描    述: 设置单选列表　RadioButtonList 值
//-----------------------------------------------------------
function uiSetRadioButtonListValue(name, val) {
    var obj = uiGetTag(document, "input");
    var arr = new Array();
    for (var i = 0; i < obj.length; i++) {
        if (obj[i].name == name && obj[i].type == "radio") {
            arr.push(new Array(obj[i].id));
        }
    }
    for (var i = 0; i < arr.length; i++) {
        if (uiGet(arr[i]).value == val) {
            uiGet(arr[i]).checked = "checked";
        }
    }
}
//-----------------------------------------------------------
// 名    称: uiSetDropDownListValue
// 描    述: 设置下拉列表　DropDownList 值
//-----------------------------------------------------------
function uiSetDropDownListValue(id, val) {
    var obj = uiGet(id);
    for (var i = 0; i < obj.options.length; i++) {
        if (obj.options[i].value == val) {
            obj.options[i].selected = "selected";
        }
    }
}
//-----------------------------------------------------------
// 名    称: uiChangeDate
// 描    述: 时间转化 yyyy-MM-dd
//-----------------------------------------------------------
function uiChangeDate(date) {
    try {
        var myDate = new Date(date);
        return myDate.getFullYear() + "-" + myDate.getMonth() + "-" + myDate.getDate();
    } catch(e) {
        return "";
    }
}
//-----------------------------------------------------------
// 名    称: uiChangeDateTime
// 描    述: 时间转化 yyyy-MM-dd HH:mm:ss
//-----------------------------------------------------------
function uiChangeDateTime(date) {
    try {
        var myDate = new Date(date);
        return myDate.getFullYear() + "-" + myDate.getMonth() + "-" + myDate.getDate() + " " + myDate.getHours() + ":" + myDate.getMinutes() + ":" + myDate.getSeconds();
    } catch(e) {
        return "";
    }
}
//-----------------------------------------------------------
// 名    称: uiMergeRowSpan
// 描    述: 合并相同行
//-----------------------------------------------------------
function uiMergeRowSpan(obj, row, col) {
    var lastValue = "";
    var value = "";
    var pos = 1;
    for (var i = row; i < obj.rows.length; i++) {
        value = obj.rows[i].cells[col].innerText;
        if (lastValue == value) {
            obj.rows[i].deleteCell(col);
            obj.rows[i - pos].cells[col].rowSpan = obj.rows[i - pos].cells[col].rowSpan + 1;
            pos++;
        } else {
            lastValue = value;
            pos = 1;
        }
    }
}
//-----------------------------------------------------------
// 名    称: uiAges
// 描    述: 根据日期获取年龄
//-----------------------------------------------------------
function uiAges(str) {
    var r = str.match(/^(\d{1,4})(-|\/)(\d{1,2})\2(\d{1,2})$/);
    if (r == null) return false;
    var d = new Date(r[1], r[3] - 1, r[4]);
    if (d.getFullYear() == r[1] && (d.getMonth() + 1) == r[3] && d.getDate() == r[4]) {
        var Y = new Date().getFullYear();
        return ((Y - r[1]));
    }
    return "";
}
//-----------------------------------------------------------
// 名    称: uiInitRequiredFieldValidator,uiInitRegularExpressionValidator
// 描    述: 安装验证控件空、自定义验证css，
//-----------------------------------------------------------
uiReady(function() {
    uiInitRequiredFieldValidator();
    uiInitRegularExpressionValidator();
});
function uiInitRequiredFieldValidator() {
    var span = uiGetTag(document, "span");
    var arr = new Array();
    for (var i = 0; i < span.length; i++) {
        if (span[i].id.indexOf("RequiredFieldValidator") != -1) {
            arr.push(new Array(span[i].id));
        }
    }
    for (var i = 0; i < arr.length; i++) {
        if (uiGet(arr[i])) {
            uiGet(arr[i]).className = "RequiredFieldValidator";
        }
    }
}
function uiInitRegularExpressionValidator() {
    var span = uiGetTag(document, "span");
    var arr = new Array();
    for (var i = 0; i < span.length; i++) {
        if (span[i].id.indexOf("RegularExpressionValidator") != -1) {
            arr.push(new Array(span[i].id));
        }
    }
    for (var i = 0; i < arr.length; i++) {
        if (uiGet(arr[i])) {
            uiGet(arr[i]).className = "RegularExpressionValidator";
        }
    }
}
//-----------------------------------------------------------
// 名    称: uiAddFavorite
// 描    述: 加入收藏
//-----------------------------------------------------------
function uiAddFavorite(url, title) {
    if (! (url && title)) {
        url = document.URL;
        title = document.title;
    }
    if (document.all) {
        window.external.addFavorite(url, title);
    } else if (window.sidebar) {
        window.sidebar.addPanel(title, url, "");
    }
}
//-----------------------------------------------------------
// 名    称: uiSetHomePage
// 描    述: 设置首页
//-----------------------------------------------------------
function uiSetHomePage(url) {
    if (!url) {
        url = document.URL;
    }
    if (document.all) {
        document.body.style.behavior = 'url(#default#homepage)';
        document.body.setHomePage(url);
    } else if (window.sidebar) {
        if (window.netscape) {
            try {
                netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
            } catch(e) {
                alert("此操作被浏览器拒绝！请在浏览器地址栏输入“about:config”并回车然后将[signed.applets.codebase_principal_support]的值设置为'true',双击即可。");
            }
        }
        var prefs = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefBranch);
        prefs.setCharPref('browser.startup.homepage', url);
    }
}
//-----------------------------------------------------------
// 名    称: uiCopyClipboard
// 描    述: 复制到剪贴板
//-----------------------------------------------------------
uiCopyClipboard = function(txt) {
    if (window.clipboardData) {
        window.clipboardData.clearData();
        window.clipboardData.setData("Text", txt);
    } else if (navigator.userAgent.indexOf("Opera") != -1) {
        window.location = txt;
    } else if (window.netscape) {
        try {
            netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
        } catch(e) {
            alert("您的firefox安全限制限制您进行剪贴板操作，请打开'about:config'将signed.applets.codebase_principal_support'设置为true'之后重试。");
            return false;
        }
        var clip = Components.classes['@mozilla.org/widget/clipboard;1'].createInstance(Components.interfaces.nsIClipboard);
        if (!clip) return;
        var trans = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);
        if (!trans) return;
        trans.addDataFlavor('text/unicode');
        var str = new Object();
        var len = new Object();
        var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
        var copytext = txt;
        str.data = copytext;
        trans.setTransferData("text/unicode", str, copytext.length * 2);
        var clipid = Components.interfaces.nsIClipboard;
        if (!clip) return false;
        clip.setData(trans, null, clipid.kGlobalClipboard);
    }
}
//-----------------------------------------------------------
// 名    称: setCookie
// 描    述: 添加cookie
//-----------------------------------------------------------
function setCookie(name, value, expiredays) {
    var exdate = new Date();
    exdate.setDate(exdate.getDate() + expiredays);

    var cookie_ret = name + "=" + escape(value) + ((expiredays == null) ? "": ";expires=" + exdate.toGMTString());
    document.cookie = cookie_ret;
}
//-----------------------------------------------------------
// 名    称: getCookie
// 描    述: 获取cookie
//-----------------------------------------------------------
function getCookie(name) {
    var len = document.cookie.length;
    if (len > 0) {
        var cookie_ret = document.cookie;
        var start = cookie_ret.indexOf(name + "=");
        if (start != -1) {
            start = start + name.length + 1;
            var end = cookie_ret.indexOf(";", start);
            if (end == -1) end = len;
            return unescape(cookie_ret.substring(start, end));
        }
    }
    return null;
}
//-----------------------------------------------------------
// 名    称: String.prototype
// 描    述: 扩展字符库
//-----------------------------------------------------------
String.prototype.trim = function() {
    if (this == null) return null;
    return this.replace(/(^\s*)|(\s*$)/g, "");
}
String.prototype.isNumber = function() {
    if (this == null) return null;
    var patrn = /^\d+$/; //正数字
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
String.prototype.isInteger = function() {
    if (this == null) return null;
    var patrn = /^[-\+]?\d+$/; //正负数字
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
String.prototype.isDouble = function() {
    if (this == null) return null;
    var patrn = /^[-\+]?\d+(\.\d+)?$/; //正负小点数字
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
String.prototype.isEnglish = function() {
    if (this == null) return null;
    var patrn = /^[A-Za-z]+$/; //英文
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
String.prototype.isChinese = function() {
    if (this == null) return null;
    var patrn = /^[\u0391-\uFFE5]+$/; //中文
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
String.prototype.isEmail = function() {
    if (this == null) return null;
    var patrn = /^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/; //邮箱
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
String.prototype.isEmpty = function() {
    if (this == null) return null;
    var patrn = /.+/; //是否为空
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
String.prototype.isIdCard = function() {
    if (this == null) return null;
    var patrn = /^\d{15}(\d{2}[A-Za-z0-9])?$/; //身份证
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
String.prototype.isTel = function() {
    if (this == null) return null;
    var patrn = /((\d{11})|^((\d{7,8})|(\d{4}|\d{3})-(\d{7,8})|(\d{4}|\d{3})-(\d{7,8})-(\d{4}|\d{3}|\d{2}|\d{1})|(\d{7,8})-(\d{4}|\d{3}|\d{2}|\d{1}))$)/; //电话
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
//-----------------------------------------------------------
// 名    称: Function.prototype
// 描    述: 扩展函数库
//-----------------------------------------------------------
Function.prototype.trim = function() {
    if (this == null) return null;
    return this.replace(/(^\s*)|(\s*$)/g, "");
}
Function.prototype.isNumber = function() {
    if (this == null) return null;
    var patrn = /^\d+$/; //正数字
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
Function.prototype.isInteger = function() {
    if (this == null) return null;
    var patrn = /^[-\+]?\d+$/; //正负数字
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
Function.prototype.isDouble = function() {
    if (this == null) return null;
    var patrn = /^[-\+]?\d+(\.\d+)?$/; //正负小点数字
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
Function.prototype.isEnglish = function() {
    if (this == null) return null;
    var patrn = /^[A-Za-z]+$/; //英文
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
Function.prototype.isChinese = function() {
    if (this == null) return null;
    var patrn = /^[\u0391-\uFFE5]+$/; //中文
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
Function.prototype.isEmail = function() {
    if (this == null) return null;
    var patrn = /^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/; //邮箱
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
Function.prototype.isEmpty = function() {
    if (this == null) return null;
    var patrn = /.+/; //是否为空
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
Function.prototype.isIdCard = function() {
    if (this == null) return null;
    var patrn = /^\d{15}(\d{2}[A-Za-z0-9])?$/; //身份证
    if (!patrn.test(this)) {
        return false;
    }
    return true;
}
Function.prototype.isTel = function() {
    if (this == null) return null;
    var patrn = /((\d{11})|^((\d{7,8})|(\d{4}|\d{3})-(\d{7,8})|(\d{4}|\d{3})-(\d{7,8})-(\d{4}|\d{3}|\d{2}|\d{1})|(\d{7,8})-(\d{4}|\d{3}|\d{2}|\d{1}))$)/; //电话
    if (!patrn.test(this)) {
        return false;
    }
}

//-----------------------------------------------------------
// 名    称: Array.prototype
// 描    述: 扩展数组
//-----------------------------------------------------------
Array.prototype.S = String.fromCharCode(2);
Array.prototype.contains = function(e) {
    var r = new RegExp(this.S + e + this.S);
    return (r.test(this.S + this.join(this.S) + this.S));
}
Array.prototype.indexOf = function(val) {
    for (var i = 0; i < this.length; i++) {
        if (this[i] == val) return i;
    }
    return - 1;
};
Array.prototype.remove = function(val) {
    var index = this.indexOf(val);
    if (index > -1) {
        this.splice(index, 1);
    }
};
