﻿<%@ Page Language="C#" MasterPageFile="~/Admin/Admin.Master" AutoEventWireup="true" CodeBehind="SetProductSubject.aspx.cs" Inherits="Hidistro.UI.Web.Admin.SetProductSubject" %>
<%@ Register TagPrefix="Hi" Namespace="Hidistro.UI.Common.Controls" Assembly="Hidistro.UI.Common.Controls" %>
<%@ Register TagPrefix="Hi" Namespace="Hidistro.UI.ControlPanel.Utility" Assembly="Hidistro.UI.ControlPanel.Utility" %>
<%@ Register TagPrefix="Hi" Namespace="Hidistro.UI.Common.Validator" Assembly="Hidistro.UI.Common.Validator" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
<%@ Import Namespace="Hidistro.Core" %>
<asp:Content ID="Content1" ContentPlaceHolderID="headHolder" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="contentHolder" runat="server">
 <div class="areacolumn clearfix">
		<div class="columnleft clearfix">
                  <ul>
                        <li><asp:HyperLink runat="server" ID="hLinkSubjects"><span>商品栏目</span></asp:HyperLink></li>
                  </ul>
    </div>
      <div class="columnright">
          <div class="title title_height">
            <em><img src="../images/01.gif" width="32" height="32" /></em>
            <h1>设置商品栏目</h1>
            <span>对前台首页“Common_GoodsList_Default”商品展示标签参数的相关设置</span>
          </div>
      <div class="formitem validator2">
        <ul>
          <li><span class="formitemtitle Pw_100">栏目名称：<em >*</em></span>
            <asp:TextBox ID="txtSubjectName" runat="server" CssClass="forminput" />
            <p id="txtSubjectNameTip" runat="server">用于在前台商品栏目版块显示的名称,不能为空，限制在30个字符以内</p>
          </li>
          <li><span class="formitemtitle Pw_100">栏目图片：</span>
                <asp:FileUpload ID="fileUpload" runat="server" CssClass="forminput" />           
               <asp:Button ID="btnUpoad" runat="server" Text="上传" CssClass="submit_queding" />     
          </li>
              <li> <span class="formitemtitle Pw_100"></span>
           <table width="300" border="0" cellspacing="0">
                  <tr>
                    <td valign="middle" style="padding-top:10px;"><Hi:HiImage ID="imgLogo" runat="server" Width="180" Height="40" />&nbsp;<Hi:ImageLinkButton ID="btnDeleteLogo"  runat="server" Text="删除" IsShow="true" /></td>
                  </tr>
                  <tr><td align="left"></td></tr>
                </table>
           </li>
          <li> <span class="formitemtitle Pw_100">关联标签：</span>
                 <asp:ListBox ID="radProductTags" runat="server" ></asp:ListBox>
             </li>
           
             <li> <span class="formitemtitle Pw_100">关联店铺分类：</span>
                <Hi:ProductCategoriesListBox runat="server" ID="listProductCategories" SelectionMode="Multiple" />
                       </li>
             <p>限制栏目版块只显示选中分类下的商品（可以按“ctrl”或“shift”选择多个分类），所有或不选表示不限制</p>
             
              <li> <span class="formitemtitle Pw_100">关联品牌分类：</span>
                <Hi:BrandCategoriesDropDownList runat="server" ID="dropBrandCategories"  />
                       </li>
             <p>限制栏目版块只显示选中品牌下的商品</p>
             <li> <span class="formitemtitle Pw_100">关联类型属性：</span>
               <Hi:ProductTypeDownList runat="server" ID="dropProductType" NullToDisplay="--请选择--" />
             </li>
             <li id="attributeRow" ><span class="formitemtitle Pw_100"></span>
	            <div class="attributeContent" id="attributeContent"></div>
                <Hi:TrimTextBox runat="server" ID="txtAttributes" TextMode="MultiLine" style="display:none;"></Hi:TrimTextBox>
             </li>
             <li><span class="formitemtitle Pw_100">价格区间：</span>
             <span class="float"><table width="200" border="0" cellspacing="0">
                          <tr>
                            <td width="45">
                                <asp:TextBox runat="server" ID="txtMinPrice" CssClass="forminput" Width="100" />
                            </td>
                            <td width="55" align="center"><strong>-</strong></td>
                            <td width="48">
                               <asp:TextBox runat="server" ID="txtMaxPrice" CssClass="forminput" Width="100" />
                            </td>
                          </tr>                          
                        </table>
                    </span>
            <p>限制栏目版块只显示价格区间内的商品，不填表示不限制</p>
          </li>
          <li><span class="formitemtitle Pw_100">关键字：</span>
            <asp:TextBox ID="txtKeywords" runat="server" CssClass="forminput" />
            <p>限制栏目版块只显示符合输入关键字的商品，不填表示不限制，输入多个关键字用空格隔开</p>
          </li>
          <li><span class="formitemtitle Pw_100">显示数量：<em >*</em></span>
            <asp:TextBox ID="txtMaxNum" runat="server" CssClass="forminput" />
            <p>限制栏目版块商品的显示数量</p>
          </li>
          <li><span class="formitemtitle Pw_100">销售排行数量：</span>
            <asp:TextBox ID="txtSaleContMaxNum" runat="server" CssClass="forminput" />
            <p>限制栏目版块显示销售排行商品的显示数量</p>
          </li>
      </ul>
      <ul class="btn Pa_100">
        <asp:Button ID="btnSaveSubject" runat="server" OnClientClick="return loadAttributes();" Text="保 存"  CssClass="submit_DAqueding" />
        </ul>
      </div>

      </div>
  </div>
  <div class="databottom"></div>
<div class="bottomarea testArea">
  <!--顶部logo区域-->
  </div>

</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="validateHolder" runat="server">
<script type="text/javascript" language="javascript">
    function InitValidators() {
        initValid(new InputValidator('ctl00_contentHolder_txtSubjectName', 1, 30, false, null, '商品栏目名称不能为空,长度在1-30之间'));
        initValid(new InputValidator('ctl00_contentHolder_txtMaxNum', 1, 10, false, null, '显示商品数据不能为空,长度在1-10之间'));
        appendValid(new NumberRangeValidator('ctl00_contentHolder_txtMaxNum', 0, 1000, '前台一个商品栏目的商品显示数据控制在1000以内'));
    }
    function reset() {
        $("#attributeContent").empty();
        var currentTypeId = $("#ctl00_contentHolder_dropProductType").val();
        var postUrl = "SetProductSubject.aspx?isCallback=true&action=getPrepareData&TypeId=" + currentTypeId;

        $.ajax({
            url: postUrl,
            type: 'GET', dataType: 'json', timeout: 10000,
            async: false,
            success: function(resultData) {
                var hasAttribute = (resultData.HasAttribute == "True");

                if(hasAttribute)
                    prepareAttributes(resultData.Attributes);
               
            }
        });
    }
    function restoreState() {
        if ($("#ctl00_contentHolder_txtAttributes").val().length > 0) {
        // 属性值回发状态维护
        var selectedAttributes = $($("#ctl00_contentHolder_txtAttributes").val()).find("item");

        $.each(selectedAttributes, function(itemIndex, itemNode) {
            var attributeId = $(itemNode).attr("attributeId");
            var attributeControl = $("#attribute" + attributeId);
            if ($(attributeControl).length > 0) $(attributeControl).val($(itemNode).attr("valueId"));          
        });
    }

    }
    $(document).ready(function() {
        InitValidators();  
        reset();
        restoreState();
        $("#ctl00_contentHolder_dropProductType").bind("change", function() { reset(); })
    });
    
    function prepareAttributes(attributes) {
        if (attributes == null || attributes == undefined || attributes.length == 0)
            return;

        var ulTag = $("<ul><\/ul>");
        $("#attributeContent").append(ulTag);

        $.each(attributes, function(i, attribute) {
            var liTag = $(String.format("<li class=\"attributeItem\" attributeId=\"{0}\" usageMode=\"{1}\"><\/li>", attribute.AttributeId, attribute.UsageMode));
            var titleSpan = $(String.format("<span class=\"formitemtitle5\">{0}：<\/span>", attribute.Name));

            liTag.append(titleSpan);

            var selectTag = $(String.format("<select size=\"4\" id=\"attribute{0}\" class=\"formselect input162\"><\/select>", attribute.AttributeId));
            selectTag.append($("<option value=\"\">--\u8BF7\u9009\u62E9--<\/option>"));

            if (attribute.AttributeValues.length > 0) {
                $.each(attribute.AttributeValues, function(vIndex, attributeValue) {
                    selectTag.append($(String.format("<option value=\"{0}\">{1}<\/option>", attributeValue.ValueId, attributeValue.ValueStr)));
                });
            }
            liTag.append(selectTag);     

            ulTag.append(liTag);
        });

        attributeRow.style.display = "";
    }
    
    function loadAttributes() {
        if (!PageIsValid())
            return false;
        
        var attributesXml = "<xml><attributes>";

        $.each($(".attributeItem"), function(i, att) {
            var attributeId = $(att).attr("attributeId");
            if( $("#attribute" + attributeId).val() != null &&  $("#attribute" + attributeId).val() != "")
                attributesXml += String.format("<item attributeId=\"{0}\" valueId=\"{1}\"><\/item>", attributeId, $("#attribute" + attributeId).val());
        });

        attributesXml += "<\/attributes><\/xml>";
        $("#ctl00_contentHolder_txtAttributes").val(attributesXml);
        return true;
    }
</script>
</asp:Content>
