﻿<%@ Control Language="C#" %>
<%@ Import Namespace="Hidistro.Core" %>
<%@ Register TagPrefix="Hi" Namespace="Hidistro.UI.Common.Controls" Assembly="Hidistro.UI.Common.Controls" %>
<%@ Register TagPrefix="UI" Namespace="ASPNET.WebControls" Assembly="ASPNET.WebControls" %>
        <UI:Grid runat="server" ID="gridMessageList" Width="100%" AllowSorting="true" GridLines="None" DataKeyNames="MessageId"
                    SortOrder="Desc"  AutoGenerateColumns="false" HeaderStyle-CssClass="diplayth1">
            <Columns>
                <UI:CheckBoxColumn HeaderStyle-CssClass="firstcell" ItemStyle-Width="5%" />
                <asp:TemplateField HeaderText="标题" ItemStyle-Width="15%">
                      <ItemTemplate> <%# Eval("Title")%></ItemTemplate>
                </asp:TemplateField>                                                 
                <asp:TemplateField HeaderText="发件人" ItemStyle-Width="10%">
                      <ItemTemplate>管理员</ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="时间" ItemStyle-Width="20%">
                      <ItemTemplate><Hi:FormatedTimeLabel ID="litDateTime" Time='<%# Eval("Date")%>' runat="server" />
                      </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="已读" SortExpression="IsRead" ItemStyle-Width="5%">
                      <ItemTemplate>
                              <asp:Label ID="Label1" runat="server" Text='<%# Eval("IsRead").ToString()=="False"? "否":"是" %>'></asp:Label>
                      </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="内容" ItemStyle-Width="35%" >
                      <ItemTemplate><%# Eval("Content")%> </ItemTemplate>
                </asp:TemplateField>     
                <asp:TemplateField HeaderText="操作" ItemStyle-Width="10%" SortExpression="PublishDate">
                      <itemtemplate><a href='<%# Globals.ApplicationPath+(string.Format("/User/ReplyReceivedMessage.aspx?MessageId={0}", Eval("MessageId")))%> ' class="SmallCommonTextButton" target="_blank">回复</a>
                      </itemtemplate>
                </asp:TemplateField>
              </Columns>

                    <RowStyle CssClass="grdrow" ForeColor="#333333" />
                    <SelectedRowStyle BackColor="#FFCC66" Font-Bold="True" ForeColor="Navy" />
                    <AlternatingRowStyle BackColor="White" />
                </UI:Grid>