﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="Web._Default" %>

<%@ Import Namespace="Web.Helpers" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>管理面板</title>
    <link rel="stylesheet" type="text/css" href="Images/style.css" />
    <link rel="stylesheet" type="text/css" href="Scripts/themes/default/easyui.css" />
    <link rel="stylesheet" type="text/css" href="Scripts/themes/icon.css" />
    <script type="text/javascript" src="Scripts/jquery-1.7.1.min.js"></script>
    <script type="text/javascript" src="Scripts/jquery.easyui.min.js"></script>
    <script type="text/javascript" src="Scripts/easyui-lang-zh_CN.js"></script>
    <script type="text/javascript" src="Scripts/jquery.validate.min.js"></script>
    <script type="text/javascript" src="Scripts/jquery.blockUI.js"></script>
    <script type="text/javascript" src="Scripts/common.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#main').tabs({
                onBeforeClose: function (title, index) {
                    var target = this;
                    var tab = $(target).tabs('getTab', title);
                    var id = $(tab).children().first().attr("id");
                    removeDialog(id);
                }
            });
            $(".leftmenu li a").click(function () {
                var title = $(this).text();
                var url = $(this).attr("href");
                if ($('#main').tabs('exists', title)) {
                    $('#main').tabs('select', title);
                }
                else {
                    $('#main').tabs('add', {
                        title: title,
                        href: url,
                        //content: '<iframe scrolling="yes" frameborder="0"  src="' + url + '" style="width:100%;height:100%;"></iframe>',
                        closable: true,
                        closed: true,
                       cache: true//,
//                        tools: [{
//                            iconCls: 'icon-mini-refresh',
//                            handler: function () {
//                                var tab = $('#main').tabs('getSelected');
//                                var id = $(tab).children().first().attr("id");
//                                removeDialog(id);
//                                //$('#main').tabs('update', {
//                                //    tab: tab,
//                                //    options: {
//                                //        title: title,
//                                //        href: url
//                                //    }
//                                //});
//                                //tab.panel('refresh');
//                                //alert('refresh');  
//                            }
//                        }]
                    });
                }
                return false;
            });

        });
        function removeDialog(id) {
            $(".easyui-dialog").each(function () {
                if ($(this).attr("id").indexOf(id) > -1) {
                    var father = $(this).parent();
                    var shadow = $(father).next();
                    var mask = $(shadow).next();
                    $(father).remove();
                    $(shadow).remove();
                    $(mask).remove();
                }
            });
        }
    </script>
</head>
<body class="easyui-layout">
    <div region="north" split="true" style="height: 80px; padding: 5px;">
        <h2 style="color: #0099FF;">
            领域订单管理系统</h2>
        <div style="color: #0099FF;">
            当前版本：<%=ver %> 官方网站：http://www.lyapp.com
        </div>
    </div>
    <div region="west" title="管理菜单" split="true" style="width: 200px; padding: 1px; overflow: hidden;">
        <div class="easyui-accordion">
            <%if (FormServices.IsUserInLevel(user, 1))
              { %>
            <div title="订单管理">
                <ul class="leftmenu">
                    <%if (FormServices.IsUserInLevel(user, 14))
                      { %>
                    <li><a href="ManageNewOrder.aspx">新订单</a></li>
                    <%} %>
                    <%if (FormServices.IsUserInLevel(user, 14))
                      { %>
                    <li><a href="ManagePendingShipOrder.aspx">待发货订单</a></li>
                    <%} %>
                    <%if (FormServices.IsUserInLevel(user, 14))
                      { %>
                    <li><a href="ManageShipedOrder.aspx">已发货订单</a></li>
                    <%} %>
                    <%if (FormServices.IsUserInLevel(user, 14))
                      { %>
                    <li><a href="ManageSuccessOrder.aspx">已签收订单</a></li>
                    <%} %>
                    <%if (FormServices.IsUserInLevel(user, 14))
                      { %>
                    <li><a href="ManageErrorOrder.aspx">无效订单</a></li>
                    <%} %>
                </ul>
            </div>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 2))
              { %>
            <div title="成员管理">
                <ul class="leftmenu">
                    <%if (FormServices.IsUserInLevel(user, 15))
                      { %>
                    <li><a href="ManageUser.aspx">用户管理</a></li>
                    <%} %>
                    <%if (FormServices.IsUserInLevel(user, 16))
                      { %>
                    <li><a href="ManageRoles.aspx">用户组管理</a></li>
                    <%} %>
                </ul>
            </div>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 3))
              { %>
            <div title="个人设置">
                <ul class="leftmenu">
                    <li><a href="ManageProfile.aspx">修改密码</a></li>
                </ul>
            </div>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 4))
              { %>
            <div title="系统设置">
                <ul class="leftmenu">
                    <%if (FormServices.IsUserInLevel(user, 25))
                      { %>
                    <li><a href="ManageConfig.aspx">注册系统</a></li>
                    <%} %>
                    <%if (FormServices.IsUserInLevel(user, 23))
                      { %>
                    <li><a href="ManageExpress.aspx">快递管理</a></li>
                    <%} %>
                    <%if (FormServices.IsUserInLevel(user, 24))
                      { %>
                    <li><a href="ManageAdCodes.aspx">广告码管理</a></li>
                    <%} %>
                </ul>
            </div>
            <%} %>
        </div>
    </div>
    <div region="center" style="overflow: hidden;">
        <div id="main" class="easyui-tabs" fit="true" border="false">
            <div title="登录信息" style="padding: 20px; overflow: hidden;">
                <div style="margin: 20px;">
                    <table class="tbl" style="width: 100%" cellpadding="10" cellspacing="0">
                        <colgroup>
                            <col style="width: 20%" />
                            <col style="width: 80%" />
                        </colgroup>
                        <tr>
                            <td class="filed">
                                登录名：
                            </td>
                            <td>
                                <%=user.Username %>
                            </td>
                        </tr>
                        <tr>
                            <td class="filed">
                                所属用户组：
                            </td>
                            <td>
                                <%=roles%>
                            </td>
                        </tr>
                        <tr>
                            <td class="filed">
                                姓名：
                            </td>
                            <td>
                                <%=user.Name %>
                            </td>
                        </tr>
                        <tr>
                            <td class="filed">
                                电话：
                            </td>
                            <td>
                                <%=user.Phone %>
                            </td>
                        </tr>
                        <tr>
                            <td class="filed">
                                QQ：
                            </td>
                            <td>
                                <%=user.QQ %>
                            </td>
                        </tr>
                        <tr>
                            <td class="filed">
                                上次登录：
                            </td>
                            <td>
                                <%=string.Format("{0:yyyy-MM-dd HH:mm:ss}",user.LastLoginTime) %>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" style="text-align: center">
                                <a href="Logout.ashx">退出登录</a>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
