﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Login.aspx.cs" Inherits="Web.Login" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>系统登录</title>
    <link rel="stylesheet" type="text/css" href="Images/style.css" />
    <link rel="stylesheet" type="text/css" href="Scripts/themes/default/easyui.css" />
    <link rel="stylesheet" type="text/css" href="Scripts/themes/icon.css" />
    <script type="text/javascript" src="Scripts/jquery-1.7.1.min.js"></script>
    <script type="text/javascript" src="Scripts/jquery.easyui.min.js"></script>
    <script type="text/javascript" src="Scripts/easyui-lang-zh_CN.js"></script>
    <script type="text/javascript" src="Scripts/jquery.validate.min.js"></script>
    <script type="text/javascript" src="Scripts/common.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $("#loginForm").validate({
                submitHandler: function() {
                    $.ajax({
                        type: "post",
                        url: "DoLogin.ashx",
                        cache: false,
                        data: $("#loginForm").serialize(),
                        dataType: "json",
                        beforeSend: function() {
                            $("#loading").show();
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                        },
                        complete: function() {
                            $("#loading").hide();
                        },
                        success: function(data) {
                            if (!data.IsError) {
                                location.href = "Default.aspx";
                            }
                            else {
                                $.messager.alert('出错拉！', data.ErrMsg, 'error');
                            }
                        }
                    });
                    return false;
                },
                rules: {
                    Username: {
                        required: true
                    },
                    Password: {
                        required: true
                    },
                    Vcode: {
                        required: true
                    }
                },
                messages: {
                    Username: {
                        required: "*"
                    },
                    Password: {
                        required: "*"
                    },
                    Vcode: {
                        required: "*"
                    }
                }
            });

        });
    </script>

</head>
<body>
    <div id="Loginmain">
        <div class="panle">
            <form id="loginForm">
            <h3>
                领域订单管理系统</h3>
            <ul>
                <li><span class="txt">用户名:&nbsp;</span>
                    <input type="text" name="Username" />
                </li>
                <li><span class="txt">密码:&nbsp;</span>
                    <input type="password" name="Password" />
                </li>
                <li><span class="txt">验证码:&nbsp;</span>
                    <input type="text" name="Vcode" style="width: 50px;" /><img style="vertical-align: middle;"
                        src="ChkCode.aspx" alt="点击刷新验证码" onclick="this.src='ChkCode.aspx?'+Math.random();void(0);" />
                </li>
                <li style="padding-left: 10px;">
                    <input type="submit" value="登录" /><img src="Images/Loading.gif" id="loading" style="display: none"
                        alt="loading" />
                </li>
            </ul>
            </form>
            <p>Powered by <a href="http://www.lyapp.com" target="_blank">领域工作室</a></p>
        </div>
    </div>
</body>
</html>
