﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ManageAdCodes.aspx.cs"
    Inherits="Web.ManageAdCodes" %>

<%@ Import Namespace="Web.Helpers" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
</head>
<body>
    <%if (user != null)
      {%>
    <%if (FormServices.IsUserInLevel(user, 24))
      {%>
    <script type="text/javascript">
        $(function () {
            $("#manageAdCodes .grid").datagrid({
                url: "AdCodesMethod.ashx?do=get",
                columns: [[
                 { field: 'ID', title: 'ID', width: 50 },
                 { field: 'Code', title: '广告码', width: 200 },
                 { field: 'Description', title: '描述', width: 400 }
                ]],
                onLoadError: function () {
                    $.messager.alert('Warning', '加载数据失败');
                },
                loadFilter: function (data) {
                    if (data.IsError) {
                        $.messager.alert('Warning', data.ErrMsg);
                        return {
                            total: 0,
                            rows: []
                        };
                    } else {
                        return data;
                    }
                },
                pagination: true,
                pageSize: 10,
                singleSelect: true,
                toolbar: "#manageAdCodes .toolbar"
            });
        });
        function newAdCodes() {
            $('#manageAdCodes-dialog form').form('clear');
            $("#manageAdCodes-dialog form input[name='Code']").prop("readonly", false);
            $("#manageAdCodes-dialog form span[name='BulidCode']").show();
            $('#manageAdCodes-dialog').dialog('open').dialog('setTitle', '添加广告码');
        }
        function editAdCodes() {
            var row = $('#manageAdCodes .grid').datagrid('getSelected');
            if (row) {
                $('#manageAdCodes-dialog form').form('clear');
                $("#manageAdCodes-dialog form input[name='ID']").val(row.ID);
                $("#manageAdCodes-dialog form input[name='Code']").val(row.Code).prop("readonly", true);
                $("#manageAdCodes-dialog form span[name='BulidCode']").hide();
                $("#manageAdCodes-dialog form textarea[name='Description']").val(row.Description);
                $('#manageAdCodes-dialog').dialog('open').dialog('setTitle', '编辑广告码');
            }
        }
        function saveAdCodes() {
            $('#manageAdCodes-dialog form').form('submit', {
                onSubmit: function () {
                    if ($(this).form('validate')) {
                        $.ajax({
                            type: "post",
                            url: "AdCodesMethod.ashx?do=save",
                            cache: false,
                            data: $("#manageAdCodes-dialog form").serialize(),
                            beforeSend: function () {
                                mask($("#manageAdCodes-dialog"));
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                            },
                            complete: function () {
                                unmask($("#manageAdCodes-dialog"));
                            },
                            success: function (data) {
                                if (data.IsError) {
                                    $.messager.alert('出错拉！', data.ErrMsg, 'error');
                                }
                                else {
                                    $('#manageAdCodes-dialog').dialog('close');
                                    $('#manageAdCodes .grid').datagrid('reload');
                                }
                            }
                        });
                    }
                    return false;
                }
            });
        }
        function removeAdCodes() {
            var row = $('#manageAdCodes .grid').datagrid('getSelected');
            if (row) {
                $.messager.confirm('Confirm', '确认要删除这个广告码？', function (r) {
                    if (r) {
                        $.ajax({
                            type: "post",
                            url: "AdCodesMethod.ashx?do=del",
                            cache: false,
                            data: { ID: row.ID },
                            beforeSend: function () {
                                $('#manageAdCodes .grid').datagrid('loading');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                            },
                            success: function (data) {
                                if (data.IsError) {
                                    $.messager.alert('出错拉！', data.ErrMsg, 'error');
                                }
                                $('#manageAdCodes .grid').datagrid('reload');
                            }
                        });
                    }
                });
            }
        }
        function doSearch() {
            var keyword = $("#manageAdCodes .toolbar input[name='keyword']").val();
            var queryParams = $('#manageAdCodes .grid').datagrid('options').queryParams;
            queryParams.keyword = keyword;
            $('#manageAdCodes .grid').datagrid('reload');
        }
        function bulidCode() {
            $.get("AdCodesMethod.ashx?do=bulid&time=" + Math.random(), function (data) {
                $("#manageAdCodes-dialog form input[name='Code']").val(data.Data);
            });
        }
    </script>
    <div id="manageAdCodes">
        <div style="padding: 20px;">
            <table class="grid" title="广告码管理">
            </table>
        </div>
        <div class="toolbar">
            <%if (FormServices.IsUserInLevel(user, 23))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-add" plain="true" onclick="newAdCodes()">
                添加广告码</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 23))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-edit" plain="true" onclick="editAdCodes()">
                编辑广告码</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 23))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-remove" plain="true" onclick="removeAdCodes()">
                删除广告码</a>
            <%} %>
            <input type="text" name="keyword" /><a href="#" class="easyui-linkbutton" iconcls="icon-search"
                plain="true" onclick="doSearch()">搜索</a>
        </div>
        <div id="manageAdCodes-dialog" class="easyui-dialog" modal="true" style="width: 600px; height: 300px;
            padding: 10px 20px" closed="true" buttons="#manageAdCodes .dialog-buttons">
            <form method="post">
            <table class="tbl" style="width: 100%" cellpadding="10" cellspacing="0">
                <colgroup>
                    <col style="width: 25%" />
                    <col style="width: 75%" />
                </colgroup>
                <tr>
                    <td class="filed">
                        广告码：
                    </td>
                    <td>
                        <input type="hidden" name="ID" />
                        <input type="text" name="Code" class="easyui-validatebox" required="true" />
                        <span name="BulidCode">
                            <button type="button" onclick="bulidCode()">
                                随机生成</button></span>
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        描述：
                    </td>
                    <td>
                        <textarea name="Description"></textarea>
                    </td>
                </tr>
            </table>
            </form>
        </div>
        <div class="dialog-buttons">
            <a href="#" class="easyui-linkbutton" iconcls="icon-ok" onclick="saveAdCodes()">保存</a>
            <a href="#" class="easyui-linkbutton" iconcls="icon-cancel" onclick="javascript:$('#manageAdCodes-dialog').dialog('close')">
                取消</a>
        </div>
    </div>
    <%}
      else
      {%>
    无权操作
    <%}
    %>
    <%}
      else
      {%>
    登录超时，请重新登录！
    <%}
    %>
</body>
</html>
