﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ManageExpress.aspx.cs"
    Inherits="Web.ManageExpress" %>

<%@ Import Namespace="Web.Helpers" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
</head>
<body>
    <%if (user != null)
      {%>
    <%if (FormServices.IsUserInLevel(user, 23))
      {%>
    <script type="text/javascript">
        $(function () {
            $("#manageExpress .grid").datagrid({
                url: "ExpressMethod.ashx?do=get",
                columns: [[
                 { field: 'ID', title: 'ID', width: 50 },
                 { field: 'Name', title: '快递公司', width: 200 },
                 { field: 'SiteUrl', title: '官方网站', width: 400 },
                 { field: 'ExpCode', title: '查询编码', width: 100 },
                 { field: 'OrderBy', title: '排序', width: 50 }
                ]],
                onLoadError: function () {
                    $.messager.alert('Warning', '加载数据失败');
                },
                loadFilter: function (data) {
                    if (data.IsError) {
                        $.messager.alert('Warning', data.ErrMsg);
                        return {
                            total: 0,
                            rows: []
                        };
                    } else {
                        return data;
                    }
                },
                singleSelect: true,
                toolbar: "#manageExpress .toolbar"
            });
        });
        function newExpress() {
            $('#manageExpress-dialog form').form('clear');
            $("#manageExpress-dialog form input[name='OrderBy']").val(0);
            $("#manageExpress-dialog form input[name='IsAuto']").val(true);
            $('#manageExpress-dialog').dialog('open').dialog('setTitle', '添加快递');
        }
        function editExpress() {
            var row = $('#manageExpress .grid').datagrid('getSelected');
            if (row) {
                $('#manageExpress-dialog form').form('clear');
                $("#manageExpress-dialog form input[name='ID']").val(row.ID);
                $("#manageExpress-dialog form input[name='Name']").val(row.Name);
                $("#manageExpress-dialog form input[name='SiteUrl']").val(row.SiteUrl);
                $("#manageExpress-dialog form input[name='OrderBy']").val(row.OrderBy);
                $("#manageExpress-dialog form input[name='ExpCode']").val(row.ExpCode);
                $("#manageExpress-dialog form input[name='IsAuto']").val(row.IsAuto);
                $('#manageExpress-dialog').dialog('open').dialog('setTitle', '编辑快递');
            }
        }
        function saveExpress() {
            $('#manageExpress-dialog form').form('submit', {
                onSubmit: function () {
                    if ($(this).form('validate')) {
                        $.ajax({
                            type: "post",
                            url: "ExpressMethod.ashx?do=save",
                            cache: false,
                            data: $("#manageExpress-dialog form").serialize(),
                            beforeSend: function () {
                                mask($("#manageExpress-dialog"));
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                            },
                            complete: function () {
                                unmask($("#manageExpress-dialog"));
                            },
                            success: function (data) {
                                if (data.IsError) {
                                    $.messager.alert('出错拉！', data.ErrMsg, 'error');
                                }
                                else {
                                    $('#manageExpress-dialog').dialog('close');
                                    $('#manageExpress .grid').datagrid('reload');
                                }
                            }
                        });
                    }
                    return false;
                }
            });
        }
        function removeExpress() {
            var row = $('#manageExpress .grid').datagrid('getSelected');
            if (row) {
                $.messager.confirm('Confirm', '确认要删除此快递？', function (r) {
                    if (r) {
                        $.ajax({
                            type: "post",
                            url: "ExpressMethod.ashx?do=del",
                            cache: false,
                            data: { ID: row.ID },
                            beforeSend: function () {
                                $('#manageExpress .grid').datagrid('loading');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                            },
                            success: function (data) {
                                if (data.IsError) {
                                    $.messager.alert('出错拉！', data.ErrMsg, 'error');
                                }
                                $('#manageExpress .grid').datagrid('reload');
                            }
                        });
                    }
                });
            }
        }
    </script>
    <div id="manageExpress">
        <div style="padding: 20px;">
            <table class="grid" title="快递公司管理">
            </table>
        </div>
        <div class="toolbar">
            <%if (FormServices.IsUserInLevel(user, 23))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-add" plain="true" onclick="newExpress()">
                添加快递</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 23))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-edit" plain="true" onclick="editExpress()">
                编辑快递</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 23))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-remove" plain="true" onclick="removeExpress()">
                删除快递</a>
            <%} %>
        </div>
        <div id="manageExpress-dialog" class="easyui-dialog" modal="true" style="width: 500px; height: 400px;
            padding: 10px 20px" closed="true" buttons="#manageExpress .dialog-buttons">
            <form method="post">
            <table class="tbl" style="width: 100%" cellpadding="10" cellspacing="0">
                <colgroup>
                    <col style="width: 25%" />
                    <col style="width: 75%" />
                </colgroup>
                <tr>
                    <td class="filed">
                        快递名称：
                    </td>
                    <td>
                        <input type="hidden" name="ID" />
                        <input type="text" name="Name" class="easyui-validatebox" required="true" />
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        官方网站：
                    </td>
                    <td>
                        <input type="text" name="SiteUrl" class="easyui-validatebox" required="true" validtype="url" />
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        查询编码：
                    </td>
                    <td>
                        <input type="text" name="ExpCode" class="easyui-validatebox" />(查询的编码,如果没有不能跟踪订单信息)
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        排序：
                    </td>
                    <td>
                        <input type="text" name="OrderBy" class="easyui-validatebox" validtype="num" required="true"
                            value="0" />(越大越靠前)
                        <input type="hidden" name="IsAuto" value="True" />
                    </td>
                </tr>
            </table>
            </form>
        </div>
        <div class="dialog-buttons">
            <a href="#" class="easyui-linkbutton" iconcls="icon-ok" onclick="saveExpress()">保存</a>
            <a href="#" class="easyui-linkbutton" iconcls="icon-cancel" onclick="javascript:$('#manageExpress-dialog').dialog('close')">
                取消</a>
        </div>
    </div>
    <%}
      else
      {%>
    无权操作
    <%}
    %>
    <%}
      else
      {%>
    登录超时，请重新登录！
    <%}
    %>
</body>
</html>
