﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ManageNewOrder.aspx.cs"
    Inherits="Web.ManageNewOrder" %>

<%@ Import Namespace="Web.Helpers" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
</head>
<body>
    <%if (user != null)
      {%>
    <%if (FormServices.IsUserInLevel(user, 14))
      {%>

    <script type="text/javascript">
        $(function() {
            $("#manageNewOrder .grid").datagrid({
                url: "NewOrderMethod.ashx?do=get",
                columns: [[
                 { field: 'Status', title: '状态', width: 50, formatter: function(value, rec) { return "<span style='color:blue'>新订单</span>" } },
                 { field: 'OrderID', title: '订单号', width: 120, height: 50 },
                 { field: 'Product', title: '产品', width: 300 },
                 { field: 'Name', title: '客户姓名', width: 100 },
                 { field: 'Phone', title: '电话', width: 100 },
                 { field: 'Address', title: '送货地址', width: 200 },
                 { field: 'ZipCode', title: '邮编', width: 50 },
                 { field: 'Note', title: '备注', width: 200 },
                 { field: 'AdCode', title: '广告码', width: 50 },
                 { field: 'CreateTime', title: '提交时间', width: 150, formatter: function(value, rec) { return FormatDateTime(value) } }
                ]],
                onLoadError: function() {
                    $.messager.alert('Warning', '加载数据失败');
                },
                loadFilter: function (data) {
                    if (data.IsError) {
                        $.messager.alert('Warning', data.ErrMsg);
                        return {
                            total: 0,
                            rows: []
                        };
                    } else {
                        return data;
                    }
                },
                pagination: true,
                pageSize: 10,
                toolbar: "#manageNewOrder .toolbar"
            });


        });
        //$('#manageNewOrder .grid').datagrid('autoPageSize');
        function editOrderNote() {
            if ($('#manageNewOrder .grid').datagrid('getSelections').length > 1) {
                $.messager.alert('提示', '仅能选一个订单', 'warning');
            }
            else {
                var row = $('#manageNewOrder .grid').datagrid('getSelected');
                if (row) {
                    $.messager.prompt('添加备注', '在下面填写备注', function (r) {
                        if (r && r.length > 2) {
                            $.ajax({
                                type: "post",
                                url: "NewOrderMethod.ashx?do=addnote",
                                cache: false,
                                data: {
                                    ID: row.ID,
                                    Note: r
                                },
                                beforeSend: function () {
                                    mask($("#manageNewOrder .datagrid-wrap"));
                                },
                                error: function (jqXHR, textStatus, errorThrown) {
                                    alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                                },
                                complete: function () {
                                    unmask($("#manageNewOrder .datagrid-wrap"));
                                },
                                success: function (data) {
                                    if (data.IsError) {
                                        $.messager.alert('出错拉！', data.ErrMsg, 'error');
                                    }
                                    else {
                                        $('#manageNewOrder .grid').datagrid('reload');
                                    }
                                }
                            });
                        }
                    });
                }
                else {
                    $.messager.alert('提示', '请选择一个订单', 'warning');
                }
            }
        }
        function submitOrder() {
            var rows = $('#manageNewOrder .grid').datagrid('getSelections');
            if (rows.length > 0) {
                var ids = new Array;
                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].ID);
                }
                $.messager.confirm('确认操作', '确认将所选订单标记为待发货订单？', function (r) {
                    if (r) {
                        $.ajax({
                            type: "post",
                            url: "NewOrderMethod.ashx?do=submitorder",
                            cache: false,
                            data: {
                                IDS: ids.join(",")
                            },
                            beforeSend: function () {
                                mask($("#manageNewOrder .datagrid-wrap"));
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                            },
                            complete: function () {
                                unmask($("#manageNewOrder .datagrid-wrap"));
                            },
                            success: function (data) {
                                if (data.IsError) {
                                    $.messager.alert('出错拉！', data.ErrMsg, 'error');
                                }
                                else {
                                    $('#manageNewOrder .grid').datagrid('reload');
                                }
                            }
                        });
                    }
                });
            }
            else {
                $.messager.alert('提示', '请选择订单', 'warning');
            }
        }
        function cancelOrder() {
            var rows = $('#manageNewOrder .grid').datagrid('getSelections');
            if (rows.length > 0) {
                var ids = new Array;
                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].ID);
                }
                $.messager.confirm('确认操作', '确认将所选订单标记为无效订单？', function(r) {
                    if (r) {
                        $.ajax({
                            type: "post",
                            url: "NewOrderMethod.ashx?do=cancelorder",
                            cache: false,
                            data: {
                                IDS: ids.join(",")
                            },
                            beforeSend: function() {
                                mask($("#manageNewOrder .datagrid-wrap"));
                            },
                            error: function(jqXHR, textStatus, errorThrown) {
                                alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                            },
                            complete: function() {
                                unmask($("#manageNewOrder .datagrid-wrap"));
                            },
                            success: function(data) {
                                if (data.IsError) {
                                    $.messager.alert('出错拉！', data.ErrMsg, 'error');
                                }
                                else {
                                    $('#manageNewOrder .grid').datagrid('reload');
                                }
                            }
                        });
                    }
                });

            }
            else {
                $.messager.alert('提示', '请选择订单', 'warning');
            }
        }
        function selectAll() {
            $('#manageNewOrder .grid').datagrid('selectAll');
        }
        function unSelectAll() {
            $('#manageNewOrder .grid').datagrid('unselectAll');
        }
    </script>

    <div id="manageNewOrder">
        <div style="padding: 20px;">
            <table class="grid" title="新订单">
            </table>
        </div>
        <div class="toolbar">
            <%if (FormServices.IsUserInLevel(user, 14))
              {%>
            <a href="#" class="easyui-linkbutton" plain="true" onclick="selectAll()">全选</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 14))
              {%>
            <a href="#" class="easyui-linkbutton" plain="true" onclick="unSelectAll()">全不选</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 6))
              {%>
            <a href="#" class="easyui-linkbutton" plain="true" onclick="editOrderNote()">添加备注</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 7))
              {%>
            <a href="#" class="easyui-linkbutton" plain="true" onclick="submitOrder()">确认订单</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 8))
              {%>
            <a href="#" class="easyui-linkbutton" plain="true" onclick="cancelOrder()">无效订单</a>
            <%} %>
        </div>
    </div>
    <%}
      else
      {%>
    无权操作
    <%}
    %>
    <%}
      else
      {%>
    登录超时，请重新登录！
    <%}
    %>
</body>
</html>
