﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ManagePendingShipOrder.aspx.cs"
    Inherits="Web.ManagePendingShipOrder" %>

<%@ Import Namespace="Web.Helpers" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
</head>
<body>
    <%if (user != null)
      {%>
    <%if (FormServices.IsUserInLevel(user, 14))
      {%>
    <script type="text/javascript">
        $(function () {
            $("#managePendingShipOrder .grid").datagrid({
                url: "PendingShipOrderMethod.ashx?do=get",
                columns: [[
                 { field: 'OrderID', title: '订单号', width: 120, height: 50 },
                 { field: 'Product', title: '产品', width: 300 },
                 { field: 'Name', title: '客户姓名', width: 100 },
                 { field: 'Phone', title: '电话', width: 100 },
                 { field: 'Note', title: '备注', width: 200 },
                 { field: 'CreateTime', title: '提交时间', width: 150, formatter: function (value, rec) { return FormatDateTime(value) } }
                ]],
                onLoadError: function () {
                    $.messager.alert('Warning', '加载数据失败');
                },
                loadFilter: function (data) {
                    if (data.IsError) {
                        $.messager.alert('Warning', data.ErrMsg);
                        return {
                           total:0,
                           rows:[]
                        };
                    } else {
                        return data;
                    }
                },
                pagination: true,
                singleSelect: true,
                pageSize: 10,
                toolbar: "#managePendingShipOrder .toolbar",
                onClickRow: function (rowIndex) {
                    var row = $('#managePendingShipOrder .grid').datagrid('getSelected');
                    $("#managePendingShipOrder-dialog2 table td[rel='Product']").html(row.Product);
                    $("#managePendingShipOrder-dialog2 table td[rel='Name']").html(row.Name);
                    $("#managePendingShipOrder-dialog2 table td[rel='Phone']").html(row.Phone);
                    $("#managePendingShipOrder-dialog2 table td[rel='Address']").html(row.Address);
                    $("#managePendingShipOrder-dialog2 table td[rel='ZipCode']").html(row.ZipCode);
                    $("#managePendingShipOrder-dialog2 table td[rel='Note']").html(row.Note);
                    $("#managePendingShipOrder-dialog2 form input[name='ID']").val(row.ID);
                    $("#managePendingShipOrder-dialog2 form input[name='ExpCode']").val("");
                    $('#managePendingShipOrder-dialog2').dialog('open').dialog('setTitle', '发货');
                }
            });
        });
        function newPendingShipOrder() {
            $('#managePendingShipOrder-dialog form').form('clear');
            $('#managePendingShipOrder-dialog').dialog('open').dialog('setTitle', '添加订单');
        }
        function savePendingShipOrder() {
            $('#managePendingShipOrder-dialog form').form('submit', {
                onSubmit: function () {
                    if ($(this).form('validate')) {
                        $.ajax({
                            type: "post",
                            url: "PendingShipOrderMethod.ashx?do=savependingshiporder",
                            cache: false,
                            data: $("#managePendingShipOrder-dialog form").serialize(),
                            beforeSend: function () {
                                mask($("#managePendingShipOrder-dialog"));
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                            },
                            complete: function () {
                                unmask($("#managePendingShipOrder-dialog"));
                            },
                            success: function (data) {
                                if (data.IsError) {
                                    $.messager.alert('出错拉！', data.ErrMsg, 'error');
                                }
                                else {
                                    $('#managePendingShipOrder-dialog').dialog('close');
                                    $('#managePendingShipOrder .grid').datagrid('reload');
                                }
                            }
                        });
                    }
                    return false;
                }
            });
        }
        //发货操作
        function sendPendingShipOrder() {
            $('#managePendingShipOrder-dialog2 form').form('submit', {
                onSubmit: function () {
                    if ($(this).form('validate')) {
                        $.ajax({
                            type: "post",
                            url: "PendingShipOrderMethod.ashx?do=sendpendingshiporder",
                            cache: false,
                            data: $("#managePendingShipOrder-dialog2 form").serialize(),
                            beforeSend: function () {
                                mask($("#managePendingShipOrder-dialog2"));
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                            },
                            complete: function () {
                                unmask($("#managePendingShipOrder-dialog2"));
                            },
                            success: function (data) {
                                if (data.IsError) {
                                    $.messager.alert('出错拉！', data.ErrMsg, 'error');
                                }
                                else {
                                    $('#managePendingShipOrder-dialog2').dialog('close');
                                    $('#managePendingShipOrder .grid').datagrid('reload');
                                }
                            }
                        });
                    }
                    return false;
                }
            });
        }
    </script>
    <div id="managePendingShipOrder">
        <div style="padding: 20px;">
            <table class="grid" title="待发货订单">
            </table>
        </div>
        <div class="toolbar">
            <%if (FormServices.IsUserInLevel(user, 5))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-add" plain="true" onclick="newPendingShipOrder()">
                添加订单</a>
            <%} %>
        </div>
        <div id="managePendingShipOrder-dialog" class="easyui-dialog" modal="true" modal="true"
            style="width: 600px; height: 500px; padding: 10px 20px" closed="true" buttons="#managePendingShipOrder .dialog-buttons">
            <form method="post">
            <table class="tbl" style="width: 100%" cellpadding="10" cellspacing="0">
                <colgroup>
                    <col style="width: 25%" />
                    <col style="width: 75%" />
                </colgroup>
                <tr>
                    <td class="filed">
                        产品名称：
                    </td>
                    <td>
                        <input type="text" name="Product" class="easyui-validatebox" required="true" style="width: 90%" />
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        收货人姓名：
                    </td>
                    <td>
                        <input type="text" name="Name" class="easyui-validatebox" required="true" />
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        联系电话：
                    </td>
                    <td>
                        <input type="text" name="Phone" class="easyui-validatebox" required="true" />
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        送货地址：
                    </td>
                    <td>
                        <input type="text" name="Address" class="easyui-validatebox" required="true" style="width: 90%" />
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        广告码：
                    </td>
                    <td>
                        <input type="text" name="AdCode" />
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        邮编：
                    </td>
                    <td>
                        <input type="text" name="ZipCode" />
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        备注：
                    </td>
                    <td>
                        <textarea name="Note"></textarea>
                    </td>
                </tr>
            </table>
            </form>
        </div>
        <div class="dialog-buttons">
            <a href="#" class="easyui-linkbutton" iconcls="icon-ok" onclick="savePendingShipOrder()">
                保存</a> <a href="#" class="easyui-linkbutton" iconcls="icon-cancel" onclick="javascript:$('#managePendingShipOrder-dialog').dialog('close')">
                    取消</a>
        </div>
        <div id="managePendingShipOrder-dialog2" class="easyui-dialog" modal="true" modal="true"
            style="width: 600px; height: 500px; padding: 10px 20px" closed="true" buttons="#managePendingShipOrder .dialog-buttons2">
            <form method="post">
            <table class="tbl" style="width: 100%" cellpadding="10" cellspacing="0">
                <colgroup>
                    <col style="width: 25%" />
                    <col style="width: 75%" />
                </colgroup>
                <tr>
                    <td class="filed">
                        产品名称：
                    </td>
                    <td rel="Product">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        收货人姓名：
                    </td>
                    <td rel="Name">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        联系电话：
                    </td>
                    <td rel="Phone">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        送货地址：
                    </td>
                    <td rel="Address">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        邮编：
                    </td>
                    <td rel="ZipCode">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        备注：
                    </td>
                    <td rel="Note">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        发货：
                    </td>
                    <td>
                        <input type="hidden" name="ID" />
                        快递：<select name="ExpID">
                            <%for (int i = 0; i < expresses.Count; i++)
                              {%>
                            <%if (i == 0)
                              { %>
                            <option value="<%=expresses[i].ID %>" selected="selected">
                                <%=expresses[i].Name %></option>
                            <%}
                              else
                              { %>
                            <option value="<%=expresses[i].ID %>">
                                <%=expresses[i].Name %></option>
                            <%} %>
                            <%} %>
                        </select>单号：<input type="text" name="ExpCode" class="easyui-validatebox" required="true" />
                    </td>
                </tr>
            </table>
            </form>
        </div>
        <div class="dialog-buttons2">
            <a href="#" class="easyui-linkbutton" iconcls="icon-ok" onclick="sendPendingShipOrder()">
                发货</a> <a href="#" class="easyui-linkbutton" iconcls="icon-cancel" onclick="javascript:$('#managePendingShipOrder-dialog2').dialog('close')">
                    取消</a>
        </div>
    </div>
    <%}
      else
      {%>
    无权操作
    <%}
    %>
    <%}
      else
      {%>
    登录超时，请重新登录！
    <%}
    %>
</body>
</html>
