﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ManageRoles.aspx.cs" Inherits="Web.ManageRoles" %>

<%@ Import Namespace="Web.Helpers" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
</head>
<body>
    <%if (user != null)
      {%>
    <%if (FormServices.IsUserInLevel(user, 16))
      {%>

    <script type="text/javascript">
        $(function() {
            $("#manageRoles .grid").datagrid({
                url: "RolesMethod.ashx?do=get",
                columns: [[
                 { field: 'ID', title: 'ID', width: 50 },
                 { field: 'Name', title: '名称', width: 200 }
                ]],
                onLoadError: function() {
                    $.messager.alert('Warning', '加载数据失败');
                },
                loadFilter: function (data) {
                    if (data.IsError) {
                        $.messager.alert('Warning', data.ErrMsg);
                        return {
                            total: 0,
                            rows: []
                        };
                    } else {
                        return data;
                    }
                },
                singleSelect: true,
                toolbar: "#manageRoles .toolbar"
            });
            $('#manageRoles-dialog form .treeLevels').tree({
                checkbox: true,
                onClick: function(node) {
                    $(this).tree('toggle', node.target);
                }
            });
        });
        function newRole() {
            $('#manageRoles-dialog form').form('clear');
            $('#manageRoles-dialog form .treeLevels').tree("options").url = 'LevelMethod.ashx?do=get';
            $('#manageRoles-dialog form .treeLevels').tree("reload");
            $('#manageRoles-dialog').dialog('open').dialog('setTitle', '添加用户组');
        }
        function editRole() {
            var row = $('#manageRoles .grid').datagrid('getSelected');
            if (row) {
                $('#manageRoles-dialog form').form('clear');
                $("#manageRoles-dialog form input[name='ID']").val(row.ID);
                $("#manageRoles-dialog form input[name='Name']").val(row.Name);
                $('#manageRoles-dialog form .treeLevels').tree("options").url = 'LevelMethod.ashx?do=get&RoleID=' + row.ID;
                $('#manageRoles-dialog form .treeLevels').tree("reload");
                $('#manageRoles-dialog').dialog('open').dialog('setTitle', '编辑用户组');
            }
        }
        function saveRole() {
            $('#manageRoles-dialog form').form('submit', {
                onSubmit: function() {
                    if ($(this).form('validate')) {
                        var nodes = $('#manageRoles-dialog form .treeLevels').tree('getChecked');
                        if (nodes.length > 0) {
                            var levels = new Array();
                            for (var i = 0; i < nodes.length; i++) {
                                levels.push(nodes[i].id);
                            }
                            $.ajax({
                                type: "post",
                                url: "RolesMethod.ashx?do=save",
                                cache: false,
                                data: {
                                    ID: $("#manageRoles-dialog form input[name='ID']").val(),
                                    Name: $("#manageRoles-dialog form input[name='Name']").val(),
                                    Levels: levels.join(",")
                                },
                                beforeSend: function() {
                                    mask($("#manageRoles-dialog"));
                                },
                                error: function(jqXHR, textStatus, errorThrown) {
                                    alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                                },
                                complete: function() {
                                    unmask($("#manageRoles-dialog"));
                                },
                                success: function(data) {
                                    if (data.IsError) {
                                        $.messager.alert('出错拉！', data.ErrMsg, 'error');
                                    }
                                    else {
                                        $('#manageRoles-dialog').dialog('close');
                                        $('#manageRoles .grid').datagrid('reload');
                                    }
                                }
                            });
                        }
                        else {
                            $.messager.alert('缺少权限', "至少选择一个权限", 'warning');
                        }
                    }
                    return false;
                }
            });
        }
        function removeRole() {
            var row = $('#manageRoles .grid').datagrid('getSelected');
            if (row) {
                $.messager.confirm('Confirm', '确认要删除此用户组？', function(r) {
                    if (r) {
                        $.ajax({
                            type: "post",
                            url: "RolesMethod.ashx?do=del",
                            cache: false,
                            data: { ID: row.ID },
                            beforeSend: function() {
                                $('#manageRoles .grid').datagrid('loading');
                            },
                            error: function(jqXHR, textStatus, errorThrown) {
                                alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                            },
                            success: function(data) {
                                if (data.IsError) {
                                    $.messager.alert('出错拉！', data.ErrMsg, 'error');
                                }
                                $('#manageRoles .grid').datagrid('reload');
                            }
                        });
                    }
                });
            }
        }
    </script>

    <div id="manageRoles">
        <div style="padding: 20px;">
            <table class="grid" title="用户组管理">
            </table>
        </div>
        <div class="toolbar">
            <%if (FormServices.IsUserInLevel(user, 20))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-add" plain="true" onclick="newRole()">
                添加用户组</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 21))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-edit" plain="true" onclick="editRole()">
                编辑用户组</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 22))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-remove" plain="true" onclick="removeRole()">
                删除用户组</a>
            <%} %>
        </div>
        <div id="manageRoles-dialog" class="easyui-dialog" modal="true" style="width: 600px; height: 400px;
            padding: 10px 20px" closed="true" buttons="#manageRoles .dialog-buttons">
            <form method="post">
            <table class="tbl" style="width: 100%" cellpadding="10" cellspacing="0">
                <colgroup>
                    <col style="width: 25%" />
                    <col style="width: 75%" />
                </colgroup>
                <tr>
                    <td class="filed">
                        用户组名称：
                    </td>
                    <td>
                        <input type="hidden" name="ID" />
                        <input type="text" name="Name" class="easyui-validatebox" required="true" />
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        权限分配：
                    </td>
                    <td>
                        <ul class="treeLevels">
                        </ul>
                    </td>
                </tr>
            </table>
            </form>
        </div>
        <div class="dialog-buttons">
            <a href="#" class="easyui-linkbutton" iconcls="icon-ok" onclick="saveRole()">保存</a>
            <a href="#" class="easyui-linkbutton" iconcls="icon-cancel" onclick="javascript:$('#manageRoles-dialog').dialog('close')">
                取消</a>
        </div>
    </div>
    <%}
      else
      {%>
    无权操作
    <%}
    %>
    <%}
      else
      {%>
    登录超时，请重新登录！
    <%}
    %>
</body>
</html>
