﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ManageShipedOrder.aspx.cs"
    Inherits="Web.ManageShipedOrder" %>

<%@ Import Namespace="Web.Helpers" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
</head>
<body>
    <%if (user != null)
      {%>
    <%if (FormServices.IsUserInLevel(user, 14))
      {%>
    <script type="text/javascript">
        $(function () {
            $("#manageShipedOrder .grid").datagrid({
                url: "ShipedOrderMethod.ashx?do=get",
                columns: [[
                 { field: 'OrderID', title: '订单号', width: 120, height: 50 },
                 { field: 'Product', title: '产品', width: 300 },
                 { field: 'Name', title: '客户姓名', width: 100 },
                 { field: 'Phone', title: '电话', width: 100 },
                 { field: 'Express', title: '快递', width: 100, formatter: function (value, rec) {
                     if (value) {
                         return value.Name
                     } else {
                         return "未知"
                     }
                 }
                 },
                 { field: 'ExpCode', title: '单号', width: 100 },
                 { field: 'SendTime', title: '发货时间', width: 150 }
                ]],
                onLoadError: function () {
                    $.messager.alert('Warning', '加载数据失败');
                },
                loadFilter: function (data) {
                    if (data.IsError) {
                        $.messager.alert('Warning', data.ErrMsg);
                        return {
                            total: 0,
                            rows: []
                        };
                    } else {
                        return data;
                    }
                },
                pagination: true,
                singleSelect: true,
                pageSize: 10,
                toolbar: "#manageShipedOrder .toolbar",
                onClickRow: function (rowIndex) {
                    var row = $('#manageShipedOrder .grid').datagrid('getSelected');
                    $("#manageShipedOrder-dialog table td[rel='Product']").html(row.Product);
                    $("#manageShipedOrder-dialog table td[rel='Name']").html(row.Name);
                    $("#manageShipedOrder-dialog table td[rel='Phone']").html(row.Phone);
                    $("#manageShipedOrder-dialog table td[rel='Address']").html(row.Address);
                    $("#manageShipedOrder-dialog table td[rel='ZipCode']").html(row.ZipCode);
                    $("#manageShipedOrder-dialog table td[rel='Note']").html(row.Note);
                    if (row.Express) {
                        var str = row.ExpCode + "(" + row.Express.Name + ")";
                        if (row.ExpCode != null && row.Express.ExpCode != null) {
                            str += "&nbsp;&nbsp;<a href='javascript:void(0)' onClick=\"searchExpCode('"+row.ExpCode+"','"+row.Express.ExpCode+"')\">查询快递</a>"
                        }
                        $("#manageShipedOrder-dialog table td[rel='ExpCode']").html(str);
                    }
                    else {
                        $("#manageShipedOrder-dialog table td[rel='ExpCode']").html("");
                    }
                    $("#manageShipedOrder-dialog table td[rel='ExpLog']").css("display", "none");
                    $("#manageShipedOrder-dialog form input[name='ID']").val(row.ID);
                    $('#manageShipedOrder-dialog').dialog('open').dialog('setTitle', '查看已发货订单');
                }
            });
        });
        function searchExpCode(orderCode,expCode) {
            $.ajax({
                type: "get",
                url: "http://www.kuaidi100.com/query?type=" + expCode + "&postid=" + orderCode,
                cache: false,
                data: {},
                dataType: "jsonp",
                beforeSend: function () {
                    mask($("#manageShipedOrder-dialog table"));
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                },
                complete: function () {
                    unmask($("#manageShipedOrder-dialog table"));
                },
                success: function (data) {
                    if (data.status) {
                        if (data.status == 200) {
                            var htmlstr = "当前快递单状态：" + numToState(data.state);
                            if (data.data != null && data.data.length > 0) {
                                var index = data.data.length - 1
                                while (index > -1) {
                                    htmlstr += "<br/>" + data.data[index].time + "&nbsp;&nbsp;" + data.data[index].context;
                                    index--;
                                }
                            }
                            $("#manageShipedOrder-dialog table td[rel='ExpLog']").html(htmlstr).slideDown();
                        }
                        else {
                            $.messager.alert('出错拉！', data.message, 'error');
                        }
                    }
                    else {
                        $.messager.alert('出错拉！', "返回数据出错,请直接前往快递公司网站查询", 'error');
                    }
                }
            });
        }
        function numToState(num) {
            switch (num) {
                case "0":
                    return "<span style='color:#EA7500'>在途中</span>"
                case "1":
                    return "<span style='color:#EA7500'>已发货</span>"
                case "2":
                    return "<span style='color:#FF0000'>疑难件</span>"
                case "3":
                    return "<span style='color:#00A600'>已签收</span>"
                case "4":
                    return "<span style='color:#FF0000'>已退货</span>"
                default:
                    return "<span style='color:#FF0000'>运单暂无结果</span>"
            }
        }
        function saveShipedOrder() {
            var ids = new Array();
            ids.push($("#manageShipedOrder-dialog form input[name='ID']").val());
            $.messager.confirm('确认操作', '确认所选订单已签收？', function (r) {
                if (r) {
                    $.ajax({
                        type: "post",
                        url: "ShipedOrderMethod.ashx?do=save",
                        cache: false,
                        data: {
                            IDS: ids.join(",")
                        },
                        beforeSend: function () {
                            mask($("#manageShipedOrder-dialog"));
                        },
                        error: function (jqXHR, textStatus, errorThrown) {
                            alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                        },
                        complete: function () {
                            unmask($("#manageShipedOrder-dialog"));
                        },
                        success: function (data) {
                            if (data.IsError) {
                                $.messager.alert('出错拉！', data.ErrMsg, 'error');
                            }
                            else {
                                $('#manageShipedOrder-dialog').dialog('close');
                                $('#manageShipedOrder .grid').datagrid('reload');
                            }
                        }
                    });
                }
            });
        }
        function cancelShipedOrder() {
            var ids = new Array();
            ids.push($("#manageShipedOrder-dialog form input[name='ID']").val());
            $.messager.confirm('确认操作', '确认所选订单已拒签？', function (r) {
                if (r) {
                    $.ajax({
                        type: "post",
                        url: "ShipedOrderMethod.ashx?do=cancel",
                        cache: false,
                        data: {
                            IDS: ids.join(",")
                        },
                        beforeSend: function () {
                            mask($("#manageShipedOrder-dialog"));
                        },
                        error: function (jqXHR, textStatus, errorThrown) {
                            alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                        },
                        complete: function () {
                            unmask($("#manageShipedOrder-dialog"));
                        },
                        success: function (data) {
                            if (data.IsError) {
                                $.messager.alert('出错拉！', data.ErrMsg, 'error');
                            }
                            else {
                                $('#manageShipedOrder-dialog').dialog('close');
                                $('#manageShipedOrder .grid').datagrid('reload');
                            }
                        }
                    });
                }
            });
        }
        function selectAll() {
            $('#manageShipedOrder .grid').datagrid('selectAll');
        }
        function unSelectAll() {
            $('#manageShipedOrder .grid').datagrid('unselectAll');
        }
    </script>
    <div id="manageShipedOrder">
        <div style="padding: 20px;">
            <table class="grid" title="已发货订单">
            </table>
        </div>
        <%--        <div class="toolbar">
                        <%if (FormServices.IsUserInLevel(user, 14))
              {%>
            <a href="#" class="easyui-linkbutton" plain="true" onclick="selectAll()">全选</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 14))
              {%>
            <a href="#" class="easyui-linkbutton" plain="true" onclick="unSelectAll()">全不选</a>
            <%} %>
        </div>--%>
        <div id="manageShipedOrder-dialog" class="easyui-dialog" modal="true" style="width: 600px; height: 400px;
            padding: 10px 20px" closed="true" buttons="#manageShipedOrder .dialog-buttons">
            <form method="post">
            <table class="tbl" style="width: 100%" cellpadding="10" cellspacing="0">
                <colgroup>
                    <col style="width: 25%" />
                    <col style="width: 75%" />
                </colgroup>
                <tr>
                    <td class="filed">
                        产品名称：<input type="hidden" name="ID" />
                    </td>
                    <td rel="Product">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        收货人姓名：
                    </td>
                    <td rel="Name">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        联系电话：
                    </td>
                    <td rel="Phone">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        送货地址：
                    </td>
                    <td rel="Address">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        邮编：
                    </td>
                    <td rel="ZipCode">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        备注：
                    </td>
                    <td rel="Note">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        快递单号：
                    </td>
                    <td rel="ExpCode">
                    </td>
                </tr>
                <tr>
                    <td colspan="2" rel="ExpLog" style="display: none;">
                    </td>
                </tr>
            </table>
            </form>
        </div>
        <div class="dialog-buttons">
            <%if (FormServices.IsUserInLevel(user, 10))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-ok" onclick="saveShipedOrder()">
                确认签收</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 11))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-cancel" onclick="cancelShipedOrder()">
                确认拒签</a>
            <%} %>
        </div>
    </div>
    <%}
      else
      {%>
    无权操作
    <%}
    %>
    <%}
      else
      {%>
    登录超时，请重新登录！
    <%}
    %>
</body>
</html>
