﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ManageSuccessOrder.aspx.cs"
    Inherits="Web.ManageSuccessOrder" %>

<%@ Import Namespace="Web.Helpers" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
</head>
<body>
    <%if (user != null)
      {%>
    <%if (FormServices.IsUserInLevel(user, 14))
      {%>

    <script type="text/javascript">
        $(function() {
            $("#manageSuccessOrder .grid").datagrid({
                url: "SuccessOrderMethod.ashx?do=get",
                columns: [[
                 { field: 'OrderID', title: '订单号', width: 120, height: 50 },
                 { field: 'Product', title: '产品', width: 200 },
                 { field: 'Name', title: '客户姓名', width: 100 },
                 { field: 'Phone', title: '电话', width: 100 },
                 { field: 'Seller', title: '接待客服', width: 100 },
                 { field: 'AdCode', title: '广告码', width: 100 },
                 { field: 'ExpCode', title: '快递单号', width: 100 },
                 { field: 'CreateTime', title: '创建时间', width: 150, formatter: function(value, rec) { return FormatDateTime(value) } }
                ]],
                onLoadError: function() {
                    $.messager.alert('Warning', '加载数据失败');
                },
                loadFilter: function (data) {
                    if (data.IsError) {
                        $.messager.alert('Warning', data.ErrMsg);
                        return {
                            total: 0,
                            rows: []
                        };
                    } else {
                        return data;
                    }
                },
                pagination: true,
                pageSize: 10,
                queryParams: {
                    stime: $("#manageSuccessOrder .toolbar input[name='stime']").val(),
                    etime: $("#manageSuccessOrder .toolbar input[name='etime']").val()
                },

                toolbar: "#manageSuccessOrder .toolbar"
            });
            $(".datebox :text").attr("readonly", "readonly");

        });
        function delSuccessOrder() {
            var rows = $('#manageSuccessOrder .grid').datagrid('getSelections');
            if (rows.length > 0) {
                var ids = new Array;
                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].ID);
                }
                $.messager.confirm('确认操作', '确认删除所选订单？', function(r) {
                    if (r) {
                        $.ajax({
                            type: "post",
                            url: "SuccessOrderMethod.ashx?do=del",
                            cache: false,
                            data: {
                                IDS: ids.join(",")
                            },
                            beforeSend: function() {
                                mask($("#manageSuccessOrder .datagrid-wrap"));
                            },
                            error: function(jqXHR, textStatus, errorThrown) {
                                alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                            },
                            complete: function() {
                                unmask($("#manageSuccessOrder .datagrid-wrap"));
                            },
                            success: function(data) {
                                if (data.IsError) {
                                    $.messager.alert('出错拉！', data.ErrMsg, 'error');
                                }
                                else {
                                    $('#manageSuccessOrder .grid').datagrid('reload');
                                }
                            }
                        });
                    }
                });
            }
            else {
                $.messager.alert('提示', '请选择订单', 'warning');
            }
        }
        function viewSuccessOrder() {
            if ($('#manageSuccessOrder .grid').datagrid('getSelections').length > 1) {
                $.messager.alert('提示', '仅能选一个订单', 'warning');
            }
            else {
                var row = $('#manageSuccessOrder .grid').datagrid('getSelected');
                if (row) {
                    $("#manageSuccessOrder-dialog table td[rel='OrderID']").html(row.OrderID);
                    $("#manageSuccessOrder-dialog table td[rel='Product']").html(row.Product);
                    $("#manageSuccessOrder-dialog table td[rel='Name']").html(row.Name);
                    $("#manageSuccessOrder-dialog table td[rel='Phone']").html(row.Phone);
                    $("#manageSuccessOrder-dialog table td[rel='Address']").html(row.Address);
                    $("#manageSuccessOrder-dialog table td[rel='ZipCode']").html(row.ZipCode);
                    $("#manageSuccessOrder-dialog table td[rel='Note']").html(row.Note);
                    $("#manageSuccessOrder-dialog table td[rel='AdCode']").html(row.AdCode);
                    $("#manageSuccessOrder-dialog table td[rel='Seller']").html(row.Seller);
                    $("#manageSuccessOrder-dialog table td[rel='CreateTime']").html(FormatDateTime(row.CreateTime));
                    $("#manageSuccessOrder-dialog table td[rel='SendTime']").html(row.SendTime ? FormatDateTime(row.SendTime) : "");
                    if (row.Express != null && row.ExpCode != null) {
                        $("#manageSuccessOrder-dialog table td[rel='ExpCode']").html(row.ExpCode + "(" + row.Express.Name + ")");
                    }
                    else {
                        $("#manageSuccessOrder-dialog table td[rel='ExpCode']").html("");
                    }
                    $("#manageSuccessOrder-dialog table td[rel='Logs']").html(row.Logs);
                    $("#manageSuccessOrder-dialog").dialog('open');
                }
                else {
                    $.messager.alert('提示', '请选择一个订单', 'warning');
                }
            }
        }
        function doSearchSuccessOrder() {
            var queryParams = $('#manageSuccessOrder .grid').datagrid('options').queryParams;
            queryParams.qtype = $("#manageSuccessOrder .toolbar select[name='qtype']").val()
            queryParams.keyword = $("#manageSuccessOrder .toolbar input[name='keyword']").val();
            queryParams.stime = $("#manageSuccessOrder .toolbar input[name='stime']").val();
            queryParams.etime = $("#manageSuccessOrder .toolbar input[name='etime']").val();
            $('#manageSuccessOrder .grid').datagrid('reload');
        }
    </script>

    <div id="manageSuccessOrder">
        <div style="padding: 20px;">
            <table class="grid" title="已签收订单">
            </table>
        </div>
        <div class="toolbar">
            <%if (FormServices.IsUserInLevel(user, 13))
              {%>
            <a href="#" class="easyui-linkbutton" plain="true" onclick="$('#manageSuccessOrder .grid').datagrid('selectAll');">
                全选</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 13))
              {%>
            <a href="#" class="easyui-linkbutton" plain="true" onclick="$('#manageSuccessOrder .grid').datagrid('unselectAll');">
                全不选</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 14))
              {%>
            <a href="#" class="easyui-linkbutton" plain="true" onclick="viewSuccessOrder()">查看订单</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 13))
              {%>
            <a href="#" class="easyui-linkbutton" plain="true" iconcls="icon-remove" onclick="delSuccessOrder()">
                删除订单</a>
            <%} %>
            <select name="qtype">
                <option value="Name" selected="selected">收货人姓名</option>
                <option value="OrderID">订单号</option>
                <option value="AdCode">广告码</option>
                <option value="Seller">客服姓名</option>
                <option value="ExpCode">快递单号</option>
            </select>
            <input type="text" name="keyword" />
            时间：<input type="text" class="easyui-datebox" name="stime" readonly="readonly" value="<% =string.Format("{0:yyyy-MM-dd}",DateTime.Now.AddDays(-7))%>" />到
            <input type="text" class="easyui-datebox" name="etime" readonly="readonly" value="<% =string.Format("{0:yyyy-MM-dd}",DateTime.Now)%>" />
            <a href="#" class="easyui-linkbutton" iconcls="icon-search" plain="true" onclick="doSearchSuccessOrder()">
                搜索</a>
        </div>
        <div id="manageSuccessOrder-dialog" class="easyui-dialog" modal="true" style="width: 600px; height: 500px;
            padding: 10px 20px" closed="true" title="查看订单">
            <table class="tbl" style="width: 100%" cellpadding="10" cellspacing="0">
                <colgroup>
                    <col style="width: 25%" />
                    <col style="width: 75%" />
                </colgroup>
                <tr>
                    <td class="filed">
                        订单号：
                    </td>
                    <td rel="OrderID">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        产品名称：
                    </td>
                    <td rel="Product">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        收货人姓名：
                    </td>
                    <td rel="Name">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        联系电话：
                    </td>
                    <td rel="Phone">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        送货地址：
                    </td>
                    <td rel="Address">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        邮编：
                    </td>
                    <td rel="ZipCode">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        备注：
                    </td>
                    <td rel="Note">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        广告码：
                    </td>
                    <td rel="AdCode">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        接待客服：
                    </td>
                    <td rel="Seller">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        创建时间：
                    </td>
                    <td rel="CreateTime">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        发货时间：
                    </td>
                    <td rel="SendTime">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        快递单号：
                    </td>
                    <td rel="ExpCode">
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        操作日志：
                    </td>
                    <td rel="Logs">
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <%}
      else
      {%>
    无权操作
    <%}
    %>
    <%}
      else
      {%>
    登录超时，请重新登录！
    <%}
    %>
</body>
</html>
