﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ManageUser.aspx.cs" Inherits="Web.ManageUser" %>

<%@ Import Namespace="Web.Helpers" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
</head>
<body>
    <%if (user != null)
      {%>
    <%if (FormServices.IsUserInLevel(user, 15))
      {%>

    <script type="text/javascript">
        $(function() {
            $("#manageUser .grid").datagrid({
                url: "UsersMethod.ashx?do=get",
                columns: [[
                 { field: 'ID', title: 'ID', width: 50 },
                 { field: 'Username', title: '用户名', width: 100 },
                 { field: 'Password', title: '密码', width: 100, formatter: function(value, rec) { return "******"} },
                 { field: 'Roles', title: '用户组', width: 200 },
                 { field: 'Name', title: '姓名', width: 100 },
                 { field: 'Phone', title: '电话', width: 100 },
                 { field: 'QQ', title: 'QQ', width: 100 },
                 { field: 'LastLoginTime', title: '上次登录', width: 100 }
                ]], 
                onLoadError: function() {
                    $.messager.alert('Warning', '加载数据失败');
                },
                loadFilter: function (data) {
                    if (data.IsError) {
                        $.messager.alert('Warning', data.ErrMsg);
                        return {
                            total: 0,
                            rows: []
                        };
                    } else {
                        return data;
                    }
                },
                pagination: true,
                pageSize: 10,
                singleSelect: true,
                toolbar: "#manageUser .toolbar"
            });


        });
        function newUser() {
            $('#manageUser-dialog').dialog('open').dialog('setTitle', '添加用户');
            $('#manageUser-dialog form').form('clear');
            $("#manageUser-dialog form input[name='Username']").prop("readonly", false);
        }
        function editUser() {
            var row = $('#manageUser .grid').datagrid('getSelected');
            if (row) {
                $('#manageUser-dialog form').form('clear');
                $("#manageUser-dialog form input[name='Username']").prop("readonly", true);
                $("#manageUser-dialog form input[name='Username']").val(row.Username);
                $("#manageUser-dialog form input[name='ID']").val(row.ID);
                $("#manageUser-dialog form input[name='Password']").val(row.Password);
                $("#manageUser-dialog form input[name='ConfirmPassword']").val(row.Password);
                $("#manageUser-dialog form input[name='Name']").val(row.Name);
                $("#manageUser-dialog form input[name='Phone']").val(row.Phone);
                $("#manageUser-dialog form input[name='QQ']").val(row.QQ);
                $.get("UsersMethod.ashx?do=getroles&ID=" + row.ID+"&time="+Math.random(), function (data) {
                    if (data.IsError) {
                        $.messager.alert('出错拉！', data.ErrMsg, 'error');
                    }
                    else {
                        for (var i = 0; i < data.Data.length; i++) {
                            $("#manageUser-dialog form input[name='UserInRole']").each(function () {
                                if ($(this).val() == data.Data[i]) {
                                    $(this).prop("checked", true);
                                }
                            });
                            //$("#userForm input[name='UserInRole',value='" + data.Data[i] + "']").prop("checked", true);
                        }
                        $('#manageUser-dialog').dialog('open').dialog('setTitle', '编辑用户');
                    }
                });
            }
        }
        function saveUser() {
            $('#manageUser-dialog form').form('submit', {
                onSubmit: function() {
                    if ($(this).form('validate')) {
                        if ($("#manageUser-dialog form input[name='UserInRole']:checked").length > 0) {
                            $.ajax({
                                type: "post",
                                url: "UsersMethod.ashx?do=save",
                                cache: false,
                                data: $("#manageUser-dialog form").serialize(),
                                beforeSend: function() {
                                    mask($("#manageUser-dialog"));
                                },
                                error: function(jqXHR, textStatus, errorThrown) {
                                    alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                                },
                                complete: function() {
                                    unmask($("#manageUser-dialog"));
                                },
                                success: function(data) {
                                    if (data.IsError) {
                                        $.messager.alert('出错拉！', data.ErrMsg, 'error');
                                    }
                                    else {
                                        $('#manageUser-dialog').dialog('close');
                                        $('#manageUser .grid').datagrid('reload');
                                    }
                                }
                            });
                        }
                        else {
                            $.messager.alert('缺少用户组', "至少选择一个用户组", 'warning');
                        }
                    }
                    return false;
                }
            });
        }
        function removeUser() {
            var row = $('#manageUser .grid').datagrid('getSelected');
            if (row) {
                $.messager.confirm('Confirm', '确认要删除此用户？', function(r) {
                    if (r) {
                        $.ajax({
                            type: "post",
                            url: "UsersMethod.ashx?do=del",
                            cache: false,
                            data: { ID: row.ID },
                            beforeSend: function() {
                                $('#manageUser .grid').datagrid('loading');
                            },
                            error: function(jqXHR, textStatus, errorThrown) {
                                alert(jqXHR.status + " " + textStatus + ":" + errorThrown);
                            },
                            success: function(data) {
                                if (data.IsError) {
                                    $.messager.alert('出错拉！', data.ErrMsg, 'error');
                                }
                                $('#manageUser .grid').datagrid('reload');
                            }
                        });
                    }
                });
            }
        }
        function doSearch() {
            var keyword = $("#manageUser .toolbar input[name='keyword']").val();
            var queryParams = $('#manageUser .grid').datagrid('options').queryParams;
            queryParams.keyword = keyword;
            $('#manageUser .grid').datagrid('reload');
        }
    </script>

    <div id="manageUser">
        <div style="padding: 20px;">
            <table class="grid"  title="用户管理">
            </table>
        </div>
        <div class="toolbar">
            <%if (FormServices.IsUserInLevel(user, 17))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-add" plain="true" onclick="newUser()">
                添加用户</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 18))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-edit" plain="true" onclick="editUser()">
                编辑用户</a>
            <%} %>
            <%if (FormServices.IsUserInLevel(user, 19))
              {%>
            <a href="#" class="easyui-linkbutton" iconcls="icon-remove" plain="true" onclick="removeUser()">
                删除用户</a>
            <%} %>
            <input type="text" name="keyword" /><a href="#" class="easyui-linkbutton" iconcls="icon-search"
                plain="true" onclick="doSearch()">搜索</a>
        </div>
        <div id="manageUser-dialog" class="easyui-dialog" modal="true" style="width: 600px; height: 450px;
            padding: 10px 20px" closed="true" buttons="#manageUser .dialog-buttons">
            <form method="post">
            <table class="tbl" style="width: 100%" cellpadding="10" cellspacing="0">
                <colgroup>
                    <col style="width: 25%" />
                    <col style="width: 75%" />
                </colgroup>
                <tr>
                    <td class="filed">
                        用户名：
                    </td>
                    <td>
                        <input type="hidden" name="ID" />
                        <input type="text" name="Username" class="easyui-validatebox" required="true" />
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        密码：
                    </td>
                    <td>
                        <input type="password" name="Password" class="easyui-validatebox" required="true"
                            validtype="length[6,32]" />
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        确认密码：
                    </td>
                    <td>
                        <input type="password" name="ConfirmPassword" class="easyui-validatebox" required="true"
                            validtype="confirmPassword['#manageUser-dialog input[name=\'Password\']']" />
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        用户组：
                    </td>
                    <td>
                        <%foreach (Model.Role r in roles)
                          {%>
                        <input type="checkbox" name="UserInRole" value="<%=r.ID%>" /><%=r.Name%>
                        <%} %>
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        姓名：
                    </td>
                    <td>
                        <input type="text" name="Name" class="easyui-validatebox" required="true" />
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        电话：
                    </td>
                    <td>
                        <input type="text" name="Phone" class="easyui-validatebox" required="true" />
                    </td>
                </tr>
                <tr>
                    <td class="filed">
                        QQ：
                    </td>
                    <td>
                        <input type="text" name="QQ" class="easyui-validatebox" required="true" />
                    </td>
                </tr>
            </table>
            </form>
        </div>
        <div class="dialog-buttons">
            <a href="#" class="easyui-linkbutton" iconcls="icon-ok" onclick="saveUser()">保存</a>
            <a href="#" class="easyui-linkbutton" iconcls="icon-cancel" onclick="javascript:$('#manageUser-dialog').dialog('close')">
                取消</a>
        </div>
    </div>
    <%}
      else
      {%>
    无权操作
    <%}
    %>
    <%}
      else
      {%>
    登录超时，请重新登录！
    <%}
    %>
</body>
</html>
