﻿<%@ control language="C#" autoeventwireup="true" inherits="Controls_AdvSearch, HTShop.WebUI" %>
<table cellspacing="1" cellpadding="0" class="advsearch">
    <tr>
        <td class="title" colspan="2">
            商品高级搜索</td>
    </tr>
    <tr>
        <td class="label">
            关 键 词：</td>
        <td class="field">
            <input class="tbx" id="Keyword" type="text" style="width: 80px;" runat="server" />
            <span class="n">输入要查找的关键词</span></td>
    </tr>
    <tr>
        <td class="label">
            商品类别：</td>
        <td class="field">
            <asp:DropDownList ID="CategoryList" runat="server">
            </asp:DropDownList>
            <span class="n">选择要查找的关键词的栏目</span></td>
    </tr>
    <tr>
        <td class="label">
            查询范围：</td>
        <td class="field">
            <asp:DropDownList ID="FieldList" runat="server">
            <asp:ListItem Value="all">所有范围</asp:ListItem>
                <asp:ListItem Value="ProductName">产品名称</asp:ListItem>
                <asp:ListItem Value="ProductNo">产品编号</asp:ListItem>
                <asp:ListItem Value="LongDescription">产品介绍</asp:ListItem>
            </asp:DropDownList>
           <span class="n">选择要查找的关键词的范围</span>
        </td>
    </tr>
    <tr>
        <td class="label">
            价格范围：</td>
        <td class="field">
            <input class="tbx" id="StartPrice" type="text" style="width: 80px;" runat="server" />
            元至
            <input class="tbx" id="EndPrice" type="text" style="width: 80px;" runat="server" />
            元
            <span class="n">可以选择一个价格范围对查找的结果数据进行筛选</span>
        </td>
    </tr>
    <tr>
        <td class="label">
            所属品牌：</td>
        <td class="field">
            <input class="tbx" id="BrandName" type="text" runat="server" />
            <span class="n">如果为空,代表所有品牌</span>
        </td>
    </tr>
     <tr>
        <td class="label">
            结果排列：</td>
        <td class="field">
            <asp:RadioButtonList ID="RBL_Sort" runat="server">
            <asp:ListItem Value="ASC" Selected="True">按价格从低到高</asp:ListItem>
            <asp:ListItem Value="DESC">按价格从高到低</asp:ListItem>
            </asp:RadioButtonList>
            <span class="n">请选择一个排列查询结果的方式</span>
        </td>
    </tr>
    
    <tr>
        <td class="submit" colspan="2">
            <input id="BTN_Search" class="btn" type="image" value="搜索" runat="server" ValidationGroup="search" onserverclick="BTN_Search_ServerClick" /></td>
    </tr>
</table>
<asp:ValidationSummary ID="ValidationSummary1" runat="server" ShowMessageBox="True"
            ShowSummary="False" ValidationGroup="search"></asp:ValidationSummary>
            
<asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ErrorMessage="价格只能输入数字，小数点右侧最多两位。"
            ControlToValidate="StartPrice" Display="None" SetFocusOnError="True" ValidationExpression="\d*\.{0,1}\d{0,2}"
            ValidationGroup="search"></asp:RegularExpressionValidator>
            <asp:RegularExpressionValidator ID="RegularExpressionValidator2" runat="server" ErrorMessage="价格只能输入数字，小数点右侧最多两位。"
            ControlToValidate="EndPrice" Display="None" SetFocusOnError="True" ValidationExpression="\d*\.{0,1}\d{0,2}"
            ValidationGroup="search"></asp:RegularExpressionValidator>
